// Cajun bot console commands.
//
// [RH] Moved out of d_netcmd.c (in Cajun source), because they don't really
// belong there.

#include <time.h>
#include "c_cvars.h"
#include "c_dispatch.h"
#include "b_bot.h"
#include "m_argv.h"
#include "doomstat.h"
#include "p_local.h"
#include "cmdlib.h"
#include "sv_main.h"
#include "log.h"

CVAR (Int, bot_next_color, 11, 0)
CVAR (Bool, bot_observer, false, 0)

IMPLEMENT_POINTY_CLASS (DCajunMaster)
 DECLARE_POINTER (getspawned)
 DECLARE_POINTER (botinfo)
 DECLARE_POINTER (firstthing)
// DECLARE_POINTER (things)
 DECLARE_POINTER (body1)
 DECLARE_POINTER (body2)
END_POINTERS

CCMD (addbot)
{

	if (argv.argc() > 2)
	{
		Printf ("addbot [botname] : add a bot to the game\n");
		return;
	}
	if (argv.argc() > 1)	bglobal.SpawnBot(argv[1]);
	else					bglobal.SpawnBot(NULL);
}

void DCajunMaster::ClearBot (int i)
{
	player_t *p;

	// [NightFang]
	if (!playeringame[i])
		return;

	p = players+i;
	const char *bname = p->userinfo.netname;

	// [NightFang] - added for crash-safe
	if (!p->isbot)
	{
		Printf("%s is not a bot!\n", bname);
		return;
	}

	Clear_Bot_Chat(i);

	// [NightFang] - let all other clients know
	ZD_Printf("%s has left the game.\n", bname);
	connlog_printf("%s (bot) has left the game.",  bname);
	ZD_DisconnectBot(i);

	if (p->mo)
	{
		// [NightFang] - added
		ZD_DestroyAActor(p->mo);
		p->mo->Destroy ();
		p->mo = NULL;
	}
	for (botinfo_t *bot=botinfo;  bot;  bot=bot->next)
		if (!stricmp(bname,bot->name))
		{
			bot->inuse = false;
			break;
		}

	client_clear(clients+i);

	playeringame[i] = false;
	GUI_DelPlayer(i);
	notify_del_client(i);

	//Kilgore: implement lead tracking
	#if __CTF__
	if (!ctf)
	#endif
	if (teamplay)
		ZD_Recalc_Team_Lead_States();
	else if (deathmatch)
		ZD_Recalc_Player_Lead_States();

	player_clear(p);

	if (--botnum<=0)
	{
		unsigned long time_now = time(NULL);
		for (int j=top_client; j>=0; j--)
		{
			if (!ZD_ValidClient(j)) continue;
			player_t *p = players + j;
			if (p->spectator) continue;
			p->spreecount = p->multicount = 0;
			p->join_time = time_now;
		}
	}

}

CCMD (removebots)
{
	bglobal.RemoveAllBots (true);
	Printf ("Removed all bots.\n");
}

CCMD (freeze)
{
	if (netgame) return;
	bglobal.freeze = !bglobal.freeze;
	Printf ("Freeze mode %s\n", (bglobal.freeze) ? "on" : "off");
}

CCMD (listbots)
{
	botinfo_t	*b;
	int			n;

	for (n=0, b=bglobal.botinfo;   b;   n++, b=b->next)
		Printf ("%s%s\n", b->name, b->inuse ? " (active)" : "");

	Printf ("> %d bots\n", n);
}

FArchive &operator<< (FArchive &arc, botskill_t &skill)
{
	return arc << skill.aiming << skill.perfection << skill.reaction << skill.isp;
}
