/*
** d_netinf.h
**
**---------------------------------------------------------------------------
** Copyright 1998-2001 Randy Heit
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
**
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote products
**    derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
** THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**---------------------------------------------------------------------------
**
*/

#ifndef __D_NETINFO_H__
#define __D_NETINFO_H__

#include "c_cvars.h"

EXTERN_CVAR (Float, autoaim)

#define MAXPLAYERNAME	15

#define GENDER_MALE		0
#define GENDER_FEMALE	1
#define GENDER_NEUTER	2

int D_GenderToInt (const char *gender);
extern const char *GenderNames[3];

struct userinfo_s
{
	char		netname[MAXPLAYERNAME+1];
	char		short_netname[MAXPLAYERNAME+1];
	int			team;
	int			aimdist;
	int			color;
	int			skin;
	int			gender;
	bool		neverswitch;
	fixed_t		MoveBob, StillBob;
};
typedef struct userinfo_s userinfo_t;

//
// Kilgore: support for lead tracking (for announcements)
//
typedef enum
{
	LS_LEAD_HAS,
	LS_LEAD_TIED,
	LS_LEAD_NOTHAVE,
	LS_LEAD_UNDEFINED			//spectators
} leadstate_t;


enum ETeams
{
	TEAM_Red,
	TEAM_Blue,
	TEAM_Green,
	TEAM_Gold,

	NUM_TEAMS //,				//Kilgore
	//TEAM_None		= 255		//Kilgore
};

const char *GetTeamName(int team);			//Kilgore
void AssignTeamColor(userinfo_t *player);	//Kilgore

//Kilgore
typedef struct
{
	char		*name;
	int			score;
	unsigned	color;
	leadstate_t	lead_state;
} teaminfo_t;

extern teaminfo_t	TeamInfo[NUM_TEAMS];

FArchive &operator<< (FArchive &arc, userinfo_t &info);

void D_ReadUserInfoStrings (int player, byte **stream, bool update);

#endif //__D_CLIENTINFO_H__
