// Emacs style mode select	 -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: g_game.cpp,v 1.4 2004/10/10 18:40:27 incubus Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log: g_game.cpp,v $
// Revision 1.4  2004/10/10 18:40:27  incubus
// Sync with ZDaemon 1.06.07
//
// Revision 1.3  2004/07/23 09:18:12  incubus
// Removal of some unused or unnecessary functions.
//
// Revision 1.2  2004/07/21 22:24:20  incubus
// Remove StatusBar code dependancies. It's not needed in the server.
//
// Revision 1.1.1.1  2004/07/20 02:19:20  incubus
// ZDaemon 1.06 source import
//
//
// DESCRIPTION:  none
//
//-----------------------------------------------------------------------------



#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <time.h>

#include "templates.h"
#include "version.h"
#include "m_alloc.h"
#include "doomdef.h" 
#include "doomstat.h"
#include "d_protocol.h"
#include "d_netinf.h"
#include "z_zone.h"
#include "f_finale.h"
#include "m_argv.h"
#include "m_misc.h"
#include "m_random.h"
#include "i_system.h"
#include "p_setup.h"
#include "p_saveg.h"
#include "p_effect.h"
#include "p_tick.h"
#include "d_main.h"
#include "wi_stuff.h"
#include "hu_stuff.h"
#include "st_stuff.h"
#include "am_map.h"
#include "c_console.h"
#include "c_cvars.h"
#include "c_bind.h"
#include "c_dispatch.h"
#include "v_video.h"
#include "w_wad.h"
#include "p_local.h" 
#include "s_sound.h"
#include "gstrings.h"
#include "r_data.h"
#include "r_sky.h"
#include "r_draw.h"
#include "g_game.h"
#include "g_level.h"
#include "b_bot.h"			//Added by MC:
#include "m_swap.h"

// [NightFang] - We'll be needing these
#include "sv_main.h"
#include "gi.h"

#include <zlib.h>

const int SAVEPICWIDTH = 216;
const int SAVEPICHEIGHT = 135;

void	G_PlayerReborn (int player);

void	G_DoReborn (int playernum, bool freshbot);

void	G_DoNewGame (void);
void	G_DoCompleted (void);
void	G_DoVictory (void);
void	G_DoWorldDone (void);

FIntCVar gameskill ("skill", 2, CVAR_SERVERINFO|CVAR_LATCH);
CVAR (Int, deathmatch, 0, CVAR_SERVERINFO|CVAR_LATCH);
#if __CTF__
//duke
//==
CVAR (Int, ctf, 0, CVAR_SERVERINFO|CVAR_LATCH);
//==
#endif
CVAR (Int, teamplay, 0, CVAR_SERVERINFO|CVAR_LATCH);
CVAR (Bool, chasedemo, false, 0);
CVAR (Bool, storesavepic, true, CVAR_ARCHIVE|CVAR_GLOBALCONFIG)
CVAR (Int, farthestalpha, 100, CVAR_SERVERINFO);

gameaction_t	gameaction;
gamestate_t 	gamestate = GS_STARTUP;
BOOL 			respawnmonsters;

int 			paused;
bool			sendsave;				// send a save event next tic 
bool			sendturn180;			// [RH] send a 180 degree turn next tic
bool 			usergame;				// ok to save / end game
bool			sendcenterview;			// send a center view event next tic

BOOL 			nodrawers;				// for comparative timing purposes 
BOOL 			noblit; 				// for comparative timing purposes 

bool	 		viewactive;

BOOL 			netgame;				// only true if packets are broadcast 
BOOL			multiplayer;
player_t		players[MAXPLAYERS];
bool			playeringame[MAXPLAYERS];

int 			consoleplayer;			// player taking events and displaying 
int 			displayplayer;			// view being displayed 
unsigned 		gametic = 0;

char			demoname[256];
BOOL 			netdemo;
BOOL			demonew;				// [RH] Only used around G_InitNew for demos
int				demover;
byte*			demobuffer;
byte*			demo_p;
size_t			maxdemosize;
byte*			zdemformend;			// end of FORM ZDEM chunk
byte*			zdembodyend;			// end of ZDEM BODY chunk
 
BOOL 			precache = true;		// if true, load all graphics at start 
 
wbstartstruct_t wminfo; 				// parms for world map / intermission 
 
short			consistancy[MAXPLAYERS][BACKUPTICS];
 
byte*			savebuffer;
 
#define TURBOTHRESHOLD	12800

float	 		normforwardmove[2] = {0x19, 0x32};		// [RH] For setting turbo from console
float	 		normsidemove[2] = {0x18, 0x28};			// [RH] Ditto

fixed_t			forwardmove[2], sidemove[2];
fixed_t 		angleturn[4] = {640, 1280, 320, 320};		// + slow turn
fixed_t			flyspeed[2] = {1*256, 3*256};
int				lookspeed[2] = {450, 512};

#define SLOWTURNTICS	6 

CVAR (Bool,		cl_run,			false,	CVAR_ARCHIVE)		// Always run?
CVAR (Bool,		freelook,		false,	CVAR_ARCHIVE)		// Always mlook?
CVAR (Float,	m_pitch,		1.f,	CVAR_ARCHIVE)		// Mouse speeds
CVAR (Float,	m_yaw,			1.f,	CVAR_ARCHIVE)
CVAR (Float,	m_forward,		1.f,	CVAR_ARCHIVE)
CVAR (Float,	m_side,			2.f,	CVAR_ARCHIVE)
 
int 			turnheld;								// for accelerative turning 
 
// mouse values are used once 
int 			mousex;
int 			mousey; 		

// joystick values are repeated
// [RH] now, if the joystick is enabled, it will generate an event every tick
//		so the values here are reset to zero after each tic build (in case
//		use_joystick gets set to 0 when the joystick is off center)
int 			joyxmove;
int 			joyymove;
 
AActor* 		bodyque[BODYQUESIZE]; 
int 			bodyqueslot; 

void R_ExecuteSetViewSize (void);

bool SendLand;
BYTE SendWeaponSlot;
BYTE SendWeaponChoice;
int SendItemSelect;
artitype_t SendItemUse;
artitype_t LocalSelectedItem;

// [RH] Allow turbo setting anytime during game
CUSTOM_CVAR (Float, turbo, 100.f, 0)
{
	if (self < 10.f)
	{
		self = 10.f;
	}
	else if (self > 256.f)
	{
		self = 256.f;
	}
	else
	{
		float scale = self * 0.01f;

		forwardmove[0] = (int)(normforwardmove[0]*scale);
		forwardmove[1] = (int)(normforwardmove[1]*scale);
		sidemove[0] = (int)(normsidemove[0]*scale);
		sidemove[1] = (int)(normsidemove[1]*scale);
	}
}

CCMD (turnspeeds)
{
	if (argv.argc() == 1)
	{
		Printf ("Current turn speeds: %ld %ld %ld %ld\n", angleturn[0],
			angleturn[1], angleturn[2], angleturn[3]);
	}
	else
	{
		int i;

		for (i = 1; i <= 4 && i < argv.argc(); ++i)
		{
			angleturn[i-1] = atoi (argv[i]);
		}
		if (i <= 2)
		{
			angleturn[1] = angleturn[0] * 2;
		}
		if (i <= 3)
		{
			angleturn[2] = angleturn[0] / 2;
		}
		if (i <= 4)
		{
			angleturn[3] = angleturn[2];
		}
	}
}

CCMD (slot)
{
	if (argv.argc() > 1)
	{
		SendWeaponSlot = atoi (argv[1]);
	}
}

CCMD (weapon)
{
	if (argv.argc() > 1)
	{
		SendWeaponChoice = atoi (argv[1]);
	}
}

CCMD (centerview)
{
	sendcenterview = true;
}

CCMD (land)
{
	SendLand = true;
}

CCMD (turn180)
{
	sendturn180 = true;
}

CCMD (weapnext)
{
	Net_WriteByte (DEM_WEAPNEXT);
}

CCMD (weapprev)
{
	Net_WriteByte (DEM_WEAPPREV);
}

CCMD (invnext)
{
	LocalSelectedItem = P_NextInventory (m_Instigator->player, LocalSelectedItem);
	SendItemSelect = (argv.argc() == 1) ? 2 : 1;
}

CCMD (invprev)
{
	LocalSelectedItem = P_PrevInventory (m_Instigator->player, LocalSelectedItem);
	SendItemSelect = (argv.argc() == 1) ? 2 : 1;
}

CCMD (invuse)
{
	SendItemUse = LocalSelectedItem;
}

CCMD (invuseall)
{
	SendItemUse = (artitype_t)-1;
}

CCMD (use)
{
	if (argv.argc() > 1)
	{
		SendItemUse = P_FindNamedInventory (argv[1]);
	}
}

CCMD (select)
{
	if (argv.argc() > 1)
	{
		LocalSelectedItem = P_FindNamedInventory (argv[1]);
	}
	SendItemSelect = 1;
}

//
// G_Ticker
// Make ticcmd_ts for the players.
//
extern DCanvas *page;
void SV_KickPlayer(int pnum, char *reason);

void G_Ticker ()
{
	int			i;
	player_t	*p;
	gamestate_t	oldgamestate;

	// do player reborns if needed
	for (i=top_client;  i>=0;  i--)
	{
		if (playeringame[i] && 
			(players[i].playerstate == PST_REBORN || 
			 players[i].playerstate == PST_ENTER))
		{
			G_DoReborn (i, false);
		}
	}

	// do things to change the game state
	oldgamestate = gamestate;
	while (gameaction != ga_nothing)
	{
		if (gameaction == ga_newgame2)
		{
			gameaction = ga_newgame;
			break;
		}
		switch (gameaction)
		{
		case ga_loadlevel:
			G_DoLoadLevel (-1, false);
			break;
		case ga_newgame2:	// Silence GCC (see above)
		case ga_newgame:
			G_DoNewGame ();
			break;
		case ga_completed:
			G_DoCompleted ();
			break;
		case ga_victory:
//			F_StartFinale ();
			gameaction = ga_nothing;
			break;
		case ga_worlddone:
			G_DoWorldDone ();
			break;
		case ga_fullconsole:
			gameaction = ga_nothing;
			break;
		case ga_nothing:
			break;
		}
	}

	if (oldgamestate == GS_DEMOSCREEN && oldgamestate != gamestate && page)
	{
		delete page;
		page = NULL;
	}

	//Raider: this will indicate at the server which players are using Turbo mode:
	for (i=top_client;  i>=0;  i--)
	{
		if (!ZD_ValidClient(i))	continue;

		p = players + i;
		ticcmd_t *cmd = &p->cmd;

		short fmove = cmd->ucmd.forwardmove;
		if (fmove<0) fmove = -fmove;

		if (fmove>TURBOTHRESHOLD)
		{
			//
			// Fix the chainsaw bug: if the player attacks with the
			// chainsaw, allow for a much higher threshold because the
			// chainsaw "pulls" the attacker inside the other player.
			//
			if ( (cmd->ucmd.buttons & BT_ATTACK) &&
				 (p->readyweapon==wp_chainsaw) &&
				 (fmove<=2*TURBOTHRESHOLD+500) )
				continue;

			// Avoid spurious turbo diagnoses upon connection
			if (++(p->turbo_counter) > 20)
				SV_KickPlayer(i,"TURBO");
		}
	}

	// do main actions
	switch (gamestate)
	{
	case GS_LEVEL:
		P_Ticker ();
		break;

	case GS_INTERMISSION:
		WI_Ticker ();
		break;

	case GS_FINALE:
		F_Ticker ();
		break;

	case GS_DEMOSCREEN:
		break;

	default:
		break;
	}

	// [NightFang] - keep track of the players' playing time
	ZD_DoPlayerTime();

	// [NightFang] - check all packets
	ZD_CheckTimeouts();

	// [NightFang] - update clients with what we've got
	ZD_WriteCommands();

	// [NightFang] - Send the packets!
	ZD_SendOutPackets();
}


//
// PLAYER STRUCTURE FUNCTIONS
// also see P_SpawnPlayer in P_Mobj
//

//
// G_PlayerFinishLevel
// Called when a player completes a level.
//
void G_PlayerFinishLevel (int player, EFinishLevelType mode)
{
	player_t *p;
	int i;
	int flightPower;

	p = &players[player];

	// Strip all current powers
	flightPower = p->powers[pw_flight];
	memset (p->powers, 0, sizeof (p->powers));
	if (!deathmatch && mode == FINISH_SameHub)
	{ // Keep flight if moving to another level in same hub
		p->powers[pw_flight] = flightPower;
	}
	p->mo->flags &= ~MF_SHADOW; 		// cancel invisibility
	p->mo->RenderStyle = STYLE_Normal;
	p->mo->alpha = FRACUNIT;
	p->extralight = 0;					// cancel gun flashes
	p->fixedcolormap = 0;				// cancel ir goggles
	p->damagecount = 0; 				// no palette changes
	p->bonuscount = 0;
	p->poisoncount = 0;
	p->rain1 = NULL;
	p->rain2 = NULL;
	p->inventorytics = 0;

	if (mode != FINISH_SameHub)
	{
		memset (p->keys, 0, sizeof (p->keys));	// Take away keys
		p->inventory[arti_fly] = 0;				// Take away flight
	}

	if (mode == FINISH_NoHub)
	{ // Reduce all owned inventory to 1 item each
		for (i = 0; i < NUMINVENTORYSLOTS; i++)
		{
			if (p->inventory[i])
				p->inventory[i] = 1;
		}
	}

	if (p->morphTics)
	{ // Undo morph
		P_UndoPlayerMorph (p, true);
	}

	// [NightFang] - Bring all players into spectator mode (not bots though)
	p->spectator = !p->isbot;

	p->lead_state = LS_LEAD_UNDEFINED;		//Kilgore: reset lead state
}


//
// G_PlayerReborn
// Called after a player dies
// almost everything is cleared and initialized
//
void G_PlayerReborn (int player)
{
	player_t*	p;
	bool		spectator;		// [NightFang] - for spectators
	bool		isbot;
	int			experience, level;
	int			time, time2;	// [NightFang] - time (in minutes) for players
	int 		i;
	int 		frags[MAXPLAYERS];
	int			fragcount;	// [RH] Cumulative frags
	int 		killcount;
	int			deathcount;
	int 		itemcount;
	int 		secretcount;
	unsigned long	join_time, past_time;
	leadstate_t	ls;				//Kilgore
	userinfo_t  userinfo;	// [RH] Save userinfo
	botskill_t  b_skill;//Added by MC:
	APlayerPawn *actor;
	const TypeInfo *cls;
	int			chat_prob[CHAT_EVENT_COUNT];

	p = &players[player];
	memcpy (frags, p->frags, sizeof(frags));
	fragcount = p->fragcount;
	killcount = p->killcount;
	deathcount = p->deathcount;
	itemcount = p->itemcount;
	secretcount = p->secretcount;
    b_skill = p->skill;    //Added by MC:
	memcpy(chat_prob,p->chat_probability,sizeof(chat_prob));
	memcpy (&userinfo, &p->userinfo, sizeof(userinfo));
	actor = p->mo;
	cls = p->cls;
	// [NightFang] - zdaemon stuff
	spectator = p->spectator;
	time = p->minutesingame;
	time2 = p->timeplay;
	experience = p->experience;
	join_time = p->join_time;
	past_time = p->past_time;
	level = p->level;
	ls = p->lead_state;			//Kilgore
	isbot = p->isbot;

	GUI_Save(p);				// [NightFang] - keep it real

	memset (p, 0, sizeof(*p));

	memcpy (p->frags, frags, sizeof(p->frags));
	p->fragcount = fragcount;
	p->killcount = killcount;
	p->deathcount = deathcount;
	p->itemcount = itemcount;
	p->secretcount = secretcount;
	memcpy (&p->userinfo, &userinfo, sizeof(userinfo));
	p->mo = actor;
	p->cls = cls;

	// [NightFang] - zdaemon stuff
	p->spectator = spectator;
	p->minutesingame = time;
	p->timeplay = time2;
	p->experience = experience;
	p->join_time = join_time;
	p->past_time = past_time;
	p->level = level;
	p->lead_state = ls;			//Kilgore
	p->isbot = isbot;

	GUI_Restore(p);				// [NightFang] - keep it real

    p->skill = b_skill;			//Added by MC:
	memcpy(p->chat_probability,chat_prob,sizeof(chat_prob));

	p->oldbuttons = 255;		// don't do anything immediately
	p->playerstate = PST_LIVE;

	for (i = 0; i < NUMAMMO; i++)
		p->maxammo[i] = maxammo[i];

	actor->GiveDefaultInventory ();

    //Added by MC: Init bot structure.

	if (p->isbot)
        bglobal.CleanBotstuff(p);

	// [BC] Handle temporary invulnerability when respawned
	// [NightFang] - In all games as well
	if (dmflags2 & DF2_YES_INVUL) //&&
		//(deathmatch || alwaysapplydmflags))
	{
		p->powers[pw_invulnerability] = 2*TICRATE;
		actor->effects |= FX_RESPAWNINVUL;	// [RH] special effect
	}
}

//
// G_CheckSpot	
// Returns false if the player cannot be respawned
// at the given mapthing2_t spot  
// because something is occupying it 
//

BOOL G_CheckSpot (int playernum, mapthing2_t *mthing)
{
	fixed_t x;
	fixed_t y;
	fixed_t z, oldz;
	int i;

	x = mthing->x << FRACBITS;
	y = mthing->y << FRACBITS;
	z = mthing->z << FRACBITS;

	z += R_PointInSubsector (x, y)->sector->floorplane.ZatPoint (x, y);

	if (!players[playernum].mo)
	{ // first spawn of level, before corpses
		for (i = 0; i < playernum; i++)
			if (players[i].mo && players[i].mo->x == x && players[i].mo->y == y)
				return false;
		return true;
	}

	oldz = players[playernum].mo->z;	// [RH] Need to save corpse's z-height
	players[playernum].mo->z = z;		// [RH] Checks are now full 3-D

	// killough 4/2/98: fix bug where P_CheckPosition() uses a non-solid
	// corpse to detect collisions with other players in DM starts
	//
	// Old code:
	// if (!P_CheckPosition (players[playernum].mo, x, y))
	//    return false;

	players[playernum].mo->flags |=  MF_SOLID;
	i = P_CheckPosition(players[playernum].mo, x, y);
	players[playernum].mo->flags &= ~MF_SOLID;
	players[playernum].mo->z = oldz;	// [RH] Restore corpse's height
	if (!i)
		return false;

	return true;
}

// [RH] Select a deathmatch spawn spot at random (original mechanism)
static mapthing2_t *SelectRandomDeathmatchSpot(int playernum, int selections)
{
	int i, j;

	for (j=0; j<20; j++)
	{
		i = P_Random (pr_dmspawn) % selections;
		if (G_CheckSpot (playernum, &deathmatchstarts[i]) )
		{
			return &deathmatchstarts[i];
		}
	}

	// [RH] return a spot anyway, since we allow telefragging when a player spawns
	return &deathmatchstarts[i];
}

// [RH] Returns the distance of the closest player to the given mapthing2_t.
static fixed_t PlayersRangeFromSpot(mapthing2_t *spot)
{
	int			i;
	fixed_t		closest, distance;
	player_t	*p;

	closest = INT_MAX;
	for (i=top_client;  i>=0;  i--)
	{
		p = players + i;
		if (!playeringame[i] || p->mo==NULL || p->health<=0 || p->spectator)
			continue;
		distance = P_AproxDistance (p->mo->x - spot->x * FRACUNIT,
									p->mo->y - spot->y * FRACUNIT);
		if (distance < closest)
			closest = distance;
	}

	return closest;
}

// [RH] Select the deathmatch spawn spot farthest from everyone.
// Kilgore: added an element of randomness to it; the degree of
// randomness is controlled through the "farthestalpha" cvar.
// It can range from -100 (meaning completely random selection),
// up to +100 (meaning that we always want the farthest spot).
// Values in between are compromises between these 2 extremes.
static mapthing2_t *SelectFarthestDeathmatchSpot(int playernum, int selections)
{
	int			i, alpha, nsel, randval;
	fixed_t		maxdistance, distance;
	mapthing2_t	*bestspot;
	double		dexp, sumweight, sd, ddist[64], weight[64];

	alpha = farthestalpha;
	if (alpha<-99)
		return SelectRandomDeathmatchSpot(playernum, selections);

	nsel = selections;
	if (nsel> (int)(sizeof(ddist)/sizeof(ddist[0])))
		nsel = sizeof(ddist)/sizeof(ddist[0]);
	maxdistance = 0;
	bestspot = NULL;
	for (i=0; i<nsel; i++)
	{
		if ( (distance=PlayersRangeFromSpot(&deathmatchstarts[i])) > maxdistance )
		{
			maxdistance = distance;
			bestspot = &deathmatchstarts[i];
		}
		ddist[i] = distance;
	}
	if (maxdistance==0)
		return SelectRandomDeathmatchSpot(playernum, selections);
	if (alpha>99) return bestspot;

	// We've established that -100 < alpha < 100
	// Now determine the weights; we first normalize distances
	// to the 0..1 range (1 meaning it's equal to maxdist) and
	// then apply the power function to determine the weights.
	dexp = 200.0/(100.0-(double)alpha) - 1.0;
	sumweight = 0.0;
	for (i=0; i<nsel; i++)
	{
		sd = ddist[i] / (double) maxdistance;
		weight[i] =	(sd<0.0001) ?	0.0 :
					(sd>0.9999) ?	1.0 :
									exp(dexp*log(sd));
		sumweight += weight[i];
	}
	// All weights are zero? then go for a random selection
	if (sumweight<0.0001)
		return SelectRandomDeathmatchSpot(playernum, selections);

	// Now scale the weights so that they add up to 100
	for (i=0; i<nsel; i++)
		weight[i] = 100.0 * weight[i] / sumweight;

	// Now draw a random variable in the 0..isum-1 range and
	// determine the interval on which it falls; this gives us
	// the desired respawn point.
	randval = P_Random(pr_dmspawn) % 100;
	sumweight = 0.0;
	for (i=0; i<nsel; i++)
	{
		sumweight += weight[i];
		if ( ((int)(sumweight + 0.5)) >= randval ) break;
	}
	if (i>=nsel)		//cannot happen: just put the safeguard though
		i = nsel-1;
	return &deathmatchstarts[i];
}

/********************
// HSDEBUG
// Returns the distance of the closest hostile player to the given mapthing2_t.
static fixed_t Team_PlayersRangeFromSpot(int tm,mapthing2_t *spot)
{
	int			i;
	fixed_t		closest, distance;
	player_t	*p;

	closest = INT_MAX;
	for (i=top_client;  i>=0;  i--)
	{
		p = players + i;
		if (!playeringame[i] || p->mo==NULL || p->health<=0 ||
			p->userinfo.team==tm  || p->spectator)
			continue;
		distance = P_AproxDistance (p->mo->x - spot->x * FRACUNIT,
									p->mo->y - spot->y * FRACUNIT);
		if (distance < closest)
			closest = distance;
	}
	return closest;
}
********************/


/*****************
 HSDEBUG: Examine this better in the future
static mapthing2_t *SelectTeamDMFarthestDeathmatchSpot(int tm, int selections)
{
	fixed_t bestdistance = 0;
	mapthing2_t *bestspot = NULL;
	int i;

	for (i = 0; i < selections; i++)
	{
		fixed_t distance = Team_PlayersRangeFromSpot(tm,&deathmatchstarts[i]);
		if (distance > bestdistance)
		{
			bestdistance = distance;
			bestspot = &deathmatchstarts[i];
		}
	}
	return bestspot;
}
***************/

#if __CTF__		//CTF_FIX LATER
//duke
//==
static mapthing2_t *SelectCTFRandomRedTeamSpot (int playernum, int selections)
{
	int i, j;

	for (j=0; j < 20; j++)
	{
		i = P_Random (pr_dmspawn) % selections;
		if (G_CheckSpot (playernum, &redteamstarts[i]) )
		{
			return &redteamstarts[i];
		}
	}
	return &redteamstarts[i];
}
static mapthing2_t *SelectCTFRandomBlueTeamSpot (int playernum, int selections)
{
	int i, j;

	for (j=0; j < 20; j++)
	{
		i = P_Random (pr_dmspawn) % selections;
		if (G_CheckSpot (playernum, &blueteamstarts[i]) )
		{
			return &blueteamstarts[i];
		}
	}
	return &blueteamstarts[i];
}

/****************
HSDEBUG: Examine this better in the future
// Select the deathmatch spawn spot farthest from all opponents.
static mapthing2_t *SelectCTFFarthestRedTeamSpot(int selections)
{
	fixed_t bestdistance = 0;
	mapthing2_t *bestspot = NULL;
	int i;

	for (i = 0; i < selections; i++)
	{
		fixed_t distance = Team_PlayersRangeFromSpot(0,&redteamstarts[i]);
		if (distance > bestdistance)
		{
			bestdistance = distance;
			bestspot = &redteamstarts[i];
		}
	}
	return bestspot;
}
// Select the deathmatch spawn spot farthest from all opponents.
static mapthing2_t *SelectCTFFarthestBlueTeamSpot(int selections)
{
	fixed_t bestdistance = 0;
	mapthing2_t *bestspot = NULL;
	int i;

	for (i = 0; i < selections; i++)
	{
		fixed_t distance = Team_PlayersRangeFromSpot(1,&blueteamstarts[i]);
		if (distance > bestdistance)
		{
			bestdistance = distance;
			bestspot = &blueteamstarts[i];
		}
	}
	return bestspot;
}
****************/
//== end
#endif

//
// G_DeathMatchSpawnPlayer 
// Spawns a player at one of the random death match spots 
// called at level load and each death 
//
//HSDEBUG (Kilgore)
//Something is screwy with the "spawn farthest" functions for
//team modes.

void G_DeathMatchSpawnPlayer (int playernum)
{
	int selections;
	mapthing2_t *spot;

	selections = deathmatchstarts.Size ();
	// [RH] We can get by with just 1 deathmatch start
	if (selections < 1)
		I_Error ("No deathmatch starts");

	// At level start, none of the players have mobjs attached to them,
	// so we always use the random deathmatch spawn. During the game,
	// though, we use whatever dmflags specifies.
	int spawn_farthest = ((dmflags & DF_SPAWN_FARTHEST)!=0 && players[playernum].mo!=NULL);

	#if __CTF__		//CTF_FIX LATER
	//duke
	//==
	if (ctf)
	{
		int team = players[playernum].userinfo.team;

		if (players[playernum].spectator)
		{
			spot = SelectRandomDeathmatchSpot (playernum, selections);
		}
		else
		{
			int redselec = redteamstarts.Size ();
			int blueselec = blueteamstarts.Size ();
			if (redselec < 1)	I_Error("ZDCTF: No Red Team Starts");
			if (blueselec < 1)	I_Error("ZDCTF: No Blue Team Starts");
			switch (team)
			{
				case 0:		
					spot = //(spawn_farthest) ? 
							//	SelectCTFFarthestRedTeamSpot(redselec) :
								SelectCTFRandomRedTeamSpot(playernum, redselec);
					break;
				case 1:		
					spot = //(spawn_farthest) ? 
							//	SelectCTFFarthestBlueTeamSpot(blueselec) :
								SelectCTFRandomBlueTeamSpot(playernum, blueselec);
					break;
				default:	
					spot = SelectRandomDeathmatchSpot(playernum, selections);
					break;
			}
		}
	}
	else
	{
		if (spawn_farthest)
			spot = //(teamplay) ? SelectTeamDMFarthestDeathmatchSpot(players[playernum].userinfo.team,selections) :
								SelectFarthestDeathmatchSpot(playernum, selections);
		else
			spot = SelectRandomDeathmatchSpot(playernum, selections);
	}
	#else
	if (spawn_farthest)
		spot = //(teamplay) ? SelectTeamDMFarthestDeathmatchSpot(players[playernum].userinfo.team,selections) :
							SelectFarthestDeathmatchSpot(playernum, selections);
	else	
		spot = SelectRandomDeathmatchSpot(playernum, selections);
	//== end
	#endif

	if (!spot)
	{ // no good spot, so the player will probably get stuck
		spot = &playerstarts[playernum];
	}
	else
	{
		if (playernum < 4)
			spot->type = playernum+1;
		else
			spot->type = playernum+4001-4;	// [RH] > 4 players
	}

	P_SpawnPlayer(spot, playernum);
}

//
// G_QueueBody
//
static void G_QueueBody (AActor *body)
{
	// [NightFang] - not needed
	return;

	// flush an old corpse if needed
	if (bodyqueslot >= BODYQUESIZE)
	{
		bodyque[bodyqueslot%BODYQUESIZE]->Destroy ();
		// [NightFang] - added
		//ZD_DestroyAActor(bodyque[bodyqueslot%BODYQUESIZE]);
	}
	bodyque[bodyqueslot%BODYQUESIZE] = body;
	bodyqueslot++;
}

//
// G_DoReborn
//
void G_DoReborn (int playernum, bool freshbot)
{
		// respawn at the start

		// first disassociate the corpse
		if (players[playernum].mo)
		{
			G_QueueBody (players[playernum].mo);
			players[playernum].mo->player = NULL;
		}

		// spawn at random spot if in death match
		if (deathmatch)
		{
			G_DeathMatchSpawnPlayer (playernum);
			return;
		}

		// Cooperative net-play, retain keys and weapons
		bool oldweapons[NUMWEAPONS];
		bool oldkeys[NUMKEYS];
		int oldpieces = 0;

		if (!freshbot)
		{
			memcpy (oldweapons, players[playernum].weaponowned, sizeof(oldweapons));
			memcpy (oldkeys, players[playernum].keys, sizeof(oldkeys));
			oldpieces = players[playernum].pieces;
		}

		int playerindex = playernum % 4;
		if (G_CheckSpot (playernum, &playerstarts[playerindex]) )

		{
			P_SpawnPlayer (&playerstarts[playerindex],playernum);
		}
		/*	[Danni] No need for that now
		else		
		{
			// try to spawn at one of the other players' spots
			for (int i=0; i<MAXPLAYERS; i++)
			{
				if (G_CheckSpot (playernum, &playerstarts[i]) )
				{
					int oldtype = playerstarts[i].type;

					// fake as other player
					playerstarts[i].type = (playernum < 4) ? playernum + 1 : playernum + 4001 - 4;
					P_SpawnPlayer (&playerstarts[i]);
					playerstarts[i].type = oldtype; 			// restore 
					return;
				}
				// he's going to be inside something.  Too bad.
			}
			P_SpawnPlayer (&playerstarts[playerindex],playernum);
		}
		*/
		if (!freshbot)
		{ // Restore keys and weapons

			// [NightFang] - Nice weapons replaced this
			//memcpy (players[playernum].weaponowned, oldweapons, sizeof(oldweapons));

			// [NightFang] - Keeping the keys is a new DM flag now
			if ((dmflags2 & DF2_KEEP_KEYS) && !deathmatch)
			{
				memcpy (players[playernum].keys, oldkeys, sizeof(oldkeys));
				players[playernum].pieces = oldpieces;
			}

			/* [NightFang] - Better dmflags2 take care of this
			// Give the player some ammo, based on the weapons owned
			for (i = 0; i < NUMWEAPONS; i++)
			{
				if (players[playernum].weaponowned[i])
				{
					int ammo = wpnlev1info[i]->ammo;
					players[playernum].ammo[ammo] =
						MAX (25, players[playernum].ammo[ammo]);
				}
			}*/
	}
}




CVAR (Int, autosavenum, 0, CVAR_NOSET|CVAR_ARCHIVE|CVAR_GLOBALCONFIG)
CVAR (Int, disableautosave, 0, CVAR_ARCHIVE|CVAR_GLOBALCONFIG)

extern void P_CalcHeight (player_t *);


