#ifndef IP2C_H__
#define IP2C_H__

#if __IP2C_DLL__
#include <windows.h>
#define IP2C_EXPORT	WINAPI
#else
#define IP2C_EXPORT
#endif

//---------------------------------------------------------------------------------
// The following are useful for load-time linking
//---------------------------------------------------------------------------------
int		IP2C_EXPORT ip2c_version(void);

int		IP2C_EXPORT ip2c_info_s(const char *ip_address,
				const char **c2,
				const char **name,
				const char **flag);

int		IP2C_EXPORT	ip2c_info_n(unsigned long ip_address,
				const char **c2,
				const char **name,
				const char **flag);

int		IP2C_EXPORT ip2c_info_s2(const char *ip_address,
				const char **c2,
				const char **name,
				const char **flag,
				const char **flag2);

int		IP2C_EXPORT	ip2c_info_n2(unsigned long ip_address,
				const char **c2,
				const char **name,
				const char **flag,
				const char **flag2);

int		IP2C_EXPORT	ip2c_info_c2(const char *c2,const char **name,
				const char **flag, const char **flag2);

//---------------------------------------------------------------------------------
// The following are useful for run-time linking (LoadLibrary/GetProcAddress)
//---------------------------------------------------------------------------------
typedef int (IP2C_EXPORT *IP2C_VERSION_P)(void);

typedef int (IP2C_EXPORT *IP2C_INFO_S_P)(const char *ip_address,
				const char **c2,
				const char **name,
				const char **flag);

typedef int (IP2C_EXPORT *IP2C_INFO_N_P)(unsigned long ip_address,
				const char **c2,
				const char **name,
				const char **flag);

typedef int (IP2C_EXPORT *IP2C_INFO_S2_P)(const char *ip_address,
				const char **c2,
				const char **name,
				const char **flag,
				const char **flag2);

typedef int (IP2C_EXPORT *IP2C_INFO_N2_P)(unsigned long ip_address,
				const char **c2,
				const char **name,
				const char **flag,
				const char **flag2);

typedef int (IP2C_EXPORT *IP2C_INFO_C2_P)(const char *c2,const char **name,
				const char **flag, const char **flag2);

//---------------------------------------------------------------------------------


#endif
