#ifndef __MD5_H__
#define __MD5_H__

/*
 * To compute the message digest of a chunk of bytes, declare a
 * variable of the class MD5 and call its init() method. Call
 * the update() method as needed on buffers full of bytes, and
 * then call the final() method, which will fill a supplied
 * 16-byte array with the digest.
 */
struct MD5Context
{
	unsigned /* UWORD32 */ buf[4];
	unsigned /* UWORD32 */ bytes[2];
	unsigned /* UWORD32 */ in[16];
};

class MD5
{
	public:
			MD5();
	void	init();
	void	update(unsigned char const *buf, unsigned len);
	void	final(unsigned char *digest);

	private:
	struct MD5Context mdc;
};

#endif
