#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#if _WIN32
	#include <process.h>
#else
	#include <sys/types.h>
	#include <unistd.h>
	#include <ctype.h>
#endif
#include "doomdef.h"
#include "d_player.h"
#include "sv_main.h"
#include "inet.h"
#ifdef _WIN32
	#include <direct.h>
	#define MKDIR(a) _mkdir (a)
#else
	#include <sys/types.h>
	#include <sys/stat.h>
	#define MKDIR(a)	mkdir((a),S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH)
#endif

EXTERN_CVAR (Int, master_advertise)

//
// 0 -> No action
// 1 -> Moved to old-logs directory
// 2 -> Deleted
CVAR (Int, log_disposition, 2, CVAR_SERVERINFO|CVAR_ARCHIVE);

static char *pending_tpl	= "pending%d.txt";
static char *temp_file		= "pending.tmp";

void 
submit_add(char *fname, int log_id)
{
	FILE		*f;
	unsigned	n;
	char		buf[PATH_MAX+3],pending_file[PATH_MAX+1];

	if (master_advertise==0) return;
	sprintf(pending_file,pending_tpl,log_id);
	if ( (f=fopen(pending_file,"r")) != NULL )
	{
		while (fgets(buf,sizeof(buf)-1,f))
		{
			n = strlen(buf);
			if (n && buf[n-1]=='\n')
				buf[n-1] = '\0';
			if (!stricmp(buf,fname))
			{
				fclose(f);
				return;
			}
		}
		fclose(f);
	}
	if ( (f=fopen(pending_file,"a")) != NULL )
	{
		fputs(fname,f);
		fputs("\n",f);
		fclose(f);
	}
}

static char **
get_unique_pending(char *pending_file)
{
	FILE	*f;
	int		n, i, j, npending;
	char	**pend_files,buf[PATH_MAX+3];

	if ( (f=fopen(pending_file,"r")) == NULL )
		return NULL;
	npending = 0;
	while (fgets(buf,sizeof(buf)-1,f))
		npending++;
	if (!npending)
	{
		fclose(f);
		remove(pending_file);
		return NULL;
	}
	if ( (pend_files=(char **)malloc((npending+1)*sizeof(char *))) == NULL )
	{
		fclose(f);
		return NULL;
	}
	memset(pend_files,0,(npending+1)*sizeof(char *));
	fseek(f,0,SEEK_SET);
	i = 0;
	while (fgets(buf,sizeof(buf)-1,f))
	{
		n = strlen(buf);
		if (n && buf[n-1]=='\n')
			buf[n-1] = '\0';
		for (j=i-1; j>=0; j--)
		{
			if (!stricmp(buf,pend_files[j]))
				break;
		}
		if (j<0)	//ie., it's unique
		{
			if ( (pend_files[i]=strdup(buf)) != NULL )
				i++;
		}
	}
	fclose(f);
	pend_files[i] = NULL;
	return pend_files;
}

static void 
remove_pending(char *fname,char *pending_file)
{
	FILE		*fin, *fout;
	unsigned	n, npending;
	char		buf[PATH_MAX+3];

	if ( (fin=fopen(pending_file,"r")) == NULL ) return;
	if ( (fout=fopen(temp_file,"w")) == NULL )
	{
		fclose(fin);
		return;
	}
	npending = 0;
	while (fgets(buf,sizeof(buf)-1,fin))
	{
		n = strlen(buf);
		if (n && buf[n-1]=='\n')
			buf[n-1] = '\0';
		if (stricmp(buf,fname))
		{
			npending++;
			fputs(buf,fout);
			fputs("\n",fout);
		}
	}
	fclose(fin);
	fclose(fout);
	if (npending==0)
	{
		remove(temp_file);
		remove(pending_file);
		return;
	}
	copy_file(temp_file,pending_file);
	remove(temp_file);
}

static bool
is_empty(const char *fname)
{
	FILE	*f;
	int		rc;
	char	buf[32];

	if ( (f=fopen(fname,"r")) == NULL ) return true;
	rc = fread(buf,1,sizeof(buf),f);
	fclose(f);
	return (rc<=0);
}

static bool
is_missing(const char *fname)
{
	FILE	*f;

	if ( (f=fopen(fname,"r")) == NULL ) return true;
	fclose(f);
	return false;
}


int 
transf_cb(void *cookie,unsigned char *buf,int buflen)
{
	char *resp_buf = (char *)cookie;

	if (*resp_buf=='\0')
	{
		if (buflen>31) buflen = 31;
		memcpy(resp_buf,buf,buflen);
	}
	return 1;
}

#define SUBMISSION_URL	"http://zdstats.ath.cx:8001/stats/stats-submit.php"
//#define SUBMISSION_URL	"http://zserv.keystone.gr/zserv-submit.php"

static bool 
submit_file(char *fname, int log_id)
{
	FILE			*f;
	inet_error_type	err;
	int				n;
	char			dateval[16], resp_buf[32];

	if ( (f=fopen(temp_file,"w")) == NULL )
		return false;

	fprintf(f,"PORT=%d\n",localport);
	fprintf(f,"LOGID=%d\n",log_id);

	n = strlen(fname);
	if (n>13)
		memcpy(dateval,fname + n - 12,8);
	else
		strcpy(dateval,"XXXXXXXX");
	dateval[8] = '\0';
	fprintf(f,"DATE=%s\n",dateval);
	fprintf(f,"@DATAFILE=%s\n",fname);
	fclose(f);

	memset(resp_buf,0,sizeof(resp_buf));
	err =  inet_post(SUBMISSION_URL, temp_file, transf_cb, 0, resp_buf, 60 );
	remove(temp_file);
	if (err == INETERR_NOERROR)
	{
		if (memcmp(resp_buf,"OK",2))
			err = INETERR_BADRESPONSE;
	}
	return (err==INETERR_NOERROR);
}

void
dispose_log(char *logname)
{
	int		sld;
	char	newlogname[PATH_MAX+1];
	static char *old_log_dir = "old-logs";

	sld = log_disposition;
	if (sld<0 || sld>2) sld = 2;
	switch (sld)
	{
		case 1:			// Moved to old_logs directory
			MKDIR(old_log_dir);
			sprintf(newlogname,"%s/%s",old_log_dir,logname);
			copy_file(logname,newlogname);
			remove(logname);
			break;
		case 2:			// Deleted
			remove(logname);
			break;
	}
}

static void STACK_ARGS 
submit_attempt_aux(void *pv)
{
	int		i, log_id;
	char	**pend_files, pending_file[PATH_MAX+1];

	for (log_id=1; log_id<=2; log_id++)
	{
		sprintf(pending_file,pending_tpl,log_id);
		if ( (pend_files=get_unique_pending(pending_file)) != NULL )
		{
			for (i=0; pend_files[i]; i++)
			{
				if (is_missing(pend_files[i]))
				{
					remove_pending(pend_files[i],pending_file);
				}
				else if (is_empty(pend_files[i]))
				{
					remove_pending(pend_files[i],pending_file);
					dispose_log(pend_files[i]);
				}
				else if (submit_file(pend_files[i], log_id))
				{
					remove_pending(pend_files[i],pending_file);
					dispose_log(pend_files[i]);
				}
				free(pend_files[i]);
			}
			free(pend_files);
		}
	}
}

void 
submit_attempt(void)
{
	if (master_advertise==0) return;
	#if _WIN32
		_beginthread(submit_attempt_aux,0,NULL);
	#else
		switch (fork())
		{
			case -1:
				Printf("fork() failed. Cannot submit logs\n");
				break;
			case 0:
				submit_attempt_aux(NULL);
				_exit(0);
				break;
		}
	#endif
}
