
#if defined(__WINDOWS__) || defined(__NT__) || defined(_MSC_VER) || defined(_WIN32)
#       define __WIN32__
#endif


#include <stdio.h>
#ifdef	WIN32
#include <conio.h>
#endif


#ifdef  __WIN32__
#       define WIN32_LEAN_AND_MEAN
#       include <winsock2.h>
#else
#       include <sys/types.h>
#       include <sys/socket.h>
#       include <netinet/in.h>
#       include <arpa/inet.h>
#       include <errno.h>
#       include <unistd.h>
#       include <netdb.h>
#       include <sys/ioctl.h>
#       include <sys/time.h>
#		define SOCKET_ERROR -1
#		define INVALID_SOCKET -1
#		define closesocket close
#		define ioctlsocket ioctl
#		define Sleep(x)        usleep (x * 1000)
		typedef int SOCKET;
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <ctype.h>
#include <math.h>



#include "doomdef.h"
#include "doomstat.h"
#include "gstrings.h"
#include "d_player.h"
#include "c_cvars.h"
#include "c_dispatch.h"
#include "c_bind.h"
#include "c_console.h"
#include "p_local.h"
#include "i_system.h"
#include "g_game.h"
#include "gstrings.h"
#include "s_sound.h"
#include "m_argv.h"
#include "cmdlib.h"
#include "version.h"
#include "m_misc.h"

#include "a_sharedglobal.h"
#include "a_doomglobal.h"
#include "a_action.h"


#include "sv_main.h"

SOCKET      net_socket;
int         localport;
netadr_t    net_from;   // address of who sent the packet

sizebuf_t   msg_read;
netadr_t	net_local_adr;

u_long		listening_ip_address = INADDR_ANY;


#ifdef	WIN32
WSADATA		winsockdata;
#endif

void HuffEncode(unsigned char *in,unsigned char *out,int inlen,int *outlen);
void HuffDecode(unsigned char *in,unsigned char *out,int inlen,int *outlen);

// Client side only
static void	Network_Error(const char	*s)
{
//Kilgore: avoid MessageBox() to facilitate restarts (HSDEBUG)
//#ifdef USEGUI
//	MessageBox(0,s,"ZServ32 Error",MB_ICONSTOP|MB_OK);
//#else
	Printf("FATAL ERROR\n---------------------\n%s\n---------------------\n\n", s);
//#endif
	exit(-10);
}


//
// ZD_UDPsocket
//
SOCKET ZD_UDPsocket (void)
{
        SOCKET s;

        // allocate a socket
        s = socket (PF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if (s == INVALID_SOCKET)
		{
			Network_Error("can't create socket!");
		}

        return s;
}

//
// ZD_BindToLocalPort
//
void ZD_BindToLocalPort (SOCKET s, u_short port)
{
	int v;
	struct sockaddr_in address;

	memset (&address, 0, sizeof(address));
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = htonl(listening_ip_address);
	address.sin_port = htons(port);

	v = bind (s, (sockaddr *)&address, sizeof(address));
	if (v == SOCKET_ERROR)
	{
		Network_Error( (listening_ip_address==INADDR_ANY) ?
				"Cannot bind to the specified port; are you running "
				"another instance of zserv?" :
				"Cannot bind to the specified IP address and port: either the IP address "
				"is invalid, or the port is already in use."
				);
	}
}		   


void ZD_CloseNetwork (void)
{
	closesocket (net_socket);
#ifdef __WIN32__
    WSACleanup ();
#endif
}

void SockadrToNetadr (struct sockaddr_in *s, netadr_t *a)
{
     *(int *)&a->ip = *(int *)&s->sin_addr;
     a->port = s->sin_port;
}

static void NetadrToSockadr (const netadr_t * const a, struct sockaddr_in *s)
{
     memset (s, 0, sizeof(*s));
     s->sin_family = AF_INET;

     *(int *)&s->sin_addr = *(int *)&a->ip;
     s->sin_port = a->port;
}

char *NET_AdrToString (const netadr_t * const a)
{
     static  char    s[64];

     sprintf (s, "%i.%i.%i.%i:%i", a->ip[0], a->ip[1], a->ip[2], a->ip[3], ntohs(a->port));

     return s;
}

bool NET_StringToAdr (const char *s, netadr_t *a)
{
	struct hostent		*h;
	struct sockaddr_in	sadr;
	char				*colon,copy[256];

	memset (&sadr, 0, sizeof(sadr));
	sadr.sin_family = AF_INET;
	sadr.sin_port = 0;
	strcpy (copy, s);
	// strip off a trailing :port if present
	if ( (colon=strchr(copy,':')) != NULL )
	{
		*colon++ = '\0';
		sadr.sin_port = htons(atoi(colon));
	}
	if (copy[0] >= '0' && copy[0] <= '9')
	{
		*(int *)&sadr.sin_addr = inet_addr(copy);
	}
	else
	{
		if (! (h = gethostbyname(copy)) )	return false;
		*(int *)&sadr.sin_addr = *(int *)h->h_addr_list[0];
	}
	SockadrToNetadr (&sadr, a);
	return true;
}

bool NET_CompareAdr (netadr_t *a, netadr_t *b)
{
	return (!memcmp(a->ip,b->ip,4) && a->port == b->port);
}


//////////////////////////////////////////////////////

static unsigned char huffbuff[65536];

int ZD_GetPackets (void)
{
	int 	ret;
	struct sockaddr_in	from;
	int		fromlen;

    fromlen = sizeof(from);
    
#ifdef	WIN32
	ret = recvfrom (net_socket, (char *)huffbuff, MAX_UDP_PACKET+32, 0, (struct sockaddr *)&from, &fromlen);
#else
	ret = recvfrom (net_socket, (char *)huffbuff, MAX_UDP_PACKET+32, 0, (struct sockaddr *)&from, (socklen_t *)&fromlen);
#endif


    if (ret == -1) 
    { 
#ifdef __WIN32__
        errno = WSAGetLastError();

        if (errno == WSAEWOULDBLOCK)
            return false;
		
		// connection reset by peer...dosent mean anything to the server
		if (errno == WSAECONNRESET)
			return false;

        if (errno == WSAEMSGSIZE) 
		{
             ZD_Printf ("Warning:  Oversize packet from %s\n",
                      NET_AdrToString (&net_from));
             return false;
        }

        ZD_Printf ("ZD_GetPackets(%d) Error(%d): %s\n", ret, errno, strerror(errno));
		return false;
#else
        if (errno == EWOULDBLOCK)
            return false;
        if (errno == ECONNREFUSED)
            return false;
	    
        ZD_Printf ("ZD_GetPackets: %s\n", strerror(errno));
        return false;
#endif
    }

	// No packets or an error, dont process anything.
	if (ret <= 0)	return 0;

	// Not using anymore gay ass huffman encoding
	if (memcmp(huffbuff,LAUNCHER_CHALLENGE,4))
		HuffDecode(huffbuff, (unsigned char *)msg_read.data,ret,&ret);
	else
		memcpy( msg_read.data, huffbuff, ret );

	msg_read.readcount = 0;
	msg_read.cursize = ret;

    SockadrToNetadr (&from, &net_from);

	//Printf(PRINT_HIGH, "*** got THIS: %d\n", msg_read.cursize);
	
	return msg_read.cursize;
}

static void ZD_LaunchPacket(unsigned char *outbuf,int outsz, const netadr_t * const to, bool use_compression)
{
	int					ret;
	int					final_outsz;
	struct sockaddr_in	addr;

	if (outsz <= 0)	return;

	if (use_compression)
	{
		HuffEncode(outbuf, huffbuff, outsz, &final_outsz);
		outbuf = huffbuff;
	}
	else
	{
		final_outsz = outsz;
	}

    NetadrToSockadr(to, &addr);

	ret = sendto(net_socket, (const char*)outbuf, final_outsz, 0, (struct sockaddr *)&addr, sizeof(addr));
    
    if (ret == -1) 
    {
#ifdef __WIN32__
          int err = WSAGetLastError();

          // wouldblock is silent
          if (err == WSAEWOULDBLOCK)
              return;
#else	  
          if (errno == EWOULDBLOCK)
              return;
          if (errno == ECONNREFUSED)
              return;
          Printf ("NET_SendPacket: %s\n", strerror(errno));
#endif	  
    }

}

//
// NET_GetLocalAddress - Old stuff
//

void NET_GetLocalAddress (void)
{
	int					namelen;
	struct sockaddr_in	address;
	char				buff[512];

	gethostname(buff, 512);
	buff[512-1] = 0;

	NET_StringToAdr (buff, &net_local_adr);
	namelen = sizeof(address);
#ifndef	WIN32
	if (getsockname (net_socket, (struct sockaddr *)&address, (socklen_t *)&namelen) == -1)
#else
	if (getsockname (net_socket, (struct sockaddr *)&address, &namelen) == -1)
#endif
	{
		Network_Error("NET_Init: getsockname:");//, strerror(errno));
	}
	net_local_adr.port = address.sin_port;

	if (listening_ip_address != INADDR_ANY)
	{
		* (u_long *) (net_local_adr.ip) = htonl(listening_ip_address);
	}

	Printf("IP address %s\n", NET_AdrToString (&net_local_adr));
}


// Huffman stuff
void HuffInit(void);



//
// InitNetCommon
//
static void InitNetCommon(void)
{
   int		i;
   unsigned long _true = true;

	// Init our read buffer
	SZ_Init(&msg_read, 8*(MAX_UDP_PACKET+32));

   HuffInit();

#ifdef __WIN32__
   WSADATA   wsad;
   int r = WSAStartup( MAKEWORD( 2, 0 ), &wsad );

   if (r)
   { Network_Error("Winsock initialization failed!!"); }

   Printf("winsock initialization succeeded\n");
#endif

   net_socket = ZD_UDPsocket ();
   ZD_BindToLocalPort (net_socket, localport);
   if (ioctlsocket (net_socket, FIONBIO, &_true) == -1)
       printf ("ZD_UDPsocket: ioctl FIONBIO: %s", strerror(errno));

   // determine my name & address
   NET_GetLocalAddress ();

   Printf("UDP Initialized\n");

   // [NightFang] - this was called at the change of every level, but since we have
   // players coming in and out, we'll do it one time and one time only. Here.
   memset (playeringame, 0, sizeof(playeringame));

	// Init the array
	for (i=0; i<ZD_MAX_MAPS; i++)
	{
		zd_mapcycle[i] = new char;
	}

	// We're initially not using any custom map cycles until addmap is used
	zd_cycleactive = false;
	zd_nextmap = 0;
	top_client = -1;
}

void InitNetCommon2(void)
{
	int	i,n;

	// [NightFang] - also init all buffers
	n = maxclients;
	for (i=0; i<n; i++)
	{
		SZ_Init(&clients[i].netbuf, 8*(MAX_UDP_PACKET+32));
		clients[i].netbuf.maxsize = MAX_UDP_PACKET;
		clients[i].netbuf.cursize = 0;
		clients[i].netbuf.readcount = 0;
		SZ_Init(&clients[i].relpackets, 1024*50);		// 50 k
		GUI_Init(i);
	}
}

void I_SetPort(netadr_t *addr, int port)
{
   addr->port = htons(port);
}


void ZD_StartNetwork(void)
{
	const char *val;

	localport = SERVER_PORT;

	// No? Okay, use a custom -port
	val = Args.CheckValue ("-port");
	if (val)
	{
		localport = atoi(val);
		Printf("Using port %d\n", localport);
	}

	val = Args.CheckValue("-ip");
	if (val)
	{
		unsigned v[4];

		if ( sscanf(val,"%u.%u.%u.%u",v+0,v+1,v+2,v+3)==4 &&
			 v[0]<256 && v[1]<256 && v[2]<256 && v[3]<256 )
		{
			listening_ip_address =  ((v[0] * 256 + v[1])*256 + v[2])*256 + v[3];
		}
	}

	InitNetCommon();

	GUI_UpdateWindow();
}

void SZ_Clear(sizebuf_t *buf)
{
	buf->cursize = 0;
}

void SZ_Init(sizebuf_t *buf, int length)
{
	memset (buf, 0, sizeof(*buf));
	buf->data = new byte[length+32];
	memset(buf->data,0,length+32);
	buf->maxsize = length;
	buf->cursize = 0;
}

//
// ZD_CheckBuffer - checks the clients buffer and makes sure we have
// enough room for the upcoming message
//

static void ZD_CheckBuffer(int cl, int size)
{
	// Gonna overflow
	if ((clients[cl].netbuf.cursize + (size+5)) >= clients[cl].netbuf.maxsize)
		ZD_SendPacket(cl);
}


static byte *SZ_GetSpace (sizebuf_t *buf, int length)
{
	byte	*data;

	// [NightFang] - check both the buffer length and the cvar 'maxrate'
	if (buf->cursize + length > buf->maxsize)
	{
		if (length > buf->maxsize)
			Printf("SZ_GetSpace: %i is > full buffer size", length);
		else
			Printf ("SZ_GetSpace: overflow\n");

// [NightFang] Purposely make this crash to find out what caused the overflow
#ifdef	_DEBUG
		int one=1, two=0;
		int t;
		t = one/two;
#endif

		SZ_Clear (buf);
		return 0;
	}

	data = buf->data + buf->cursize;
	buf->cursize += length;
	
	return data;
}

void SZ_Write(sizebuf_t *buf, void *data, int length)
{
	if (length<=0) return;		//Kilgore: extra check
	byte *datapos = SZ_GetSpace( buf, length );
	if (!datapos) return;
	memcpy( datapos, data, length );
}


//====================================================================
//
// ZDAEMON I/O PACKET FUNCTIONS
//
//====================================================================

ZD_OutPacket::ZD_OutPacket()
{
	plast = buf + sizeof(buf);
	Init();
}

void ZD_OutPacket::WriteByte(int c)
{
	if (pout+1>plast)
	{
		Printf("ZD_OutPacket::WriteByte: overflow\n");
		return;
	}
	*pout++ = (unsigned char) (char) c;
}

void ZD_OutPacket::WriteBytes(const void *bufp,int bufsz)
{
	if (bufsz<=0) return;

	if (pout+bufsz>plast)
	{
		Printf("ZD_OutPacket::WriteBytes: overflow\n");
		return;
	}
	memcpy(pout,bufp,bufsz);
	pout += bufsz;
}

void ZD_OutPacket::WriteShort(int v)
{
	short s = (short) v;

	if (pout+2>plast)
	{
		Printf("ZD_OutPacket::WriteShort: overflow\n");
		return;
	}
	memcpy(pout,&s,2);		//WARNING: Endian dependence
	pout += 2;
}

void ZD_OutPacket::WriteWord(unsigned v)
{
	unsigned short s = (unsigned short) v;

	if (pout+2>plast)
	{
		Printf("ZD_OutPacket::WriteWord: overflow\n");
		return;
	}
	memcpy(pout,&s,2);		//WARNING: Endian dependence
	pout += 2;
}

void ZD_OutPacket::WriteLong(unsigned long v)
{
	if (pout+4>plast)
	{
		Printf("ZD_OutPacket::WriteLong: overflow\n");
		return;
	}
	memcpy(pout,&v,4);		//WARNING: Endian dependence
	pout += 4;
}

void ZD_OutPacket::WriteFloat(float f)
{
	if (pout+4>plast)
	{
		Printf("ZD_OutPacket::WriteFloat: overflow\n");
		return;
	}
	memcpy(pout,&f,4);		//WARNING: bin. representation dependence
	pout += 4;
}

void ZD_OutPacket::WriteString(const char *s)
{
	unsigned n;

	if (!s) s = "";
	n = strlen(s)+1;
	if (pout+n>plast)
	{
		Printf("ZD_OutPacket::WriteString: overflow\n");
		return;
	}
	memcpy(pout,s,n);
	pout += n;
}

void ZD_OutPacket::ToPlayer(int cl)
{
	int sz;
	
	if ( (sz = (int)(pout - buf)) == 0 ) return;
	ZD_CheckBuffer(cl,sz);
	SZ_Write(&clients[cl].netbuf,buf,sz);
}

void ZD_OutPacket::SendTo(const netadr_t *adr, bool do_compress)
{
	int sz;
	
	if ( (sz = (int)(pout - buf)) == 0 ) return;
	ZD_LaunchPacket(buf, sz, adr, do_compress);
}


void ZD_OutPacket::Broadcast()
{
	int i, sz;
	
	if ( (sz = (int)(pout - buf)) == 0 ) return;
	for (i=top_client;  i>=0;  i--)
	{
		if (!ZD_ValidClient(i)) continue;
		ZD_CheckBuffer(i,sz);
		SZ_Write(&clients[i].netbuf,buf,sz);
	}
}

ZD_OutPacket ZDOP;

//
//====================================================================
//



//
// reading functions
//

void ZD_BeginReading (void)
{
	msg_read.readcount = 0;
}

// returns -1 if no more characters are available

int ZD_ReadChar (void)
{
	int	c;
	
	if (msg_read.readcount+1 > msg_read.cursize)
		c = -1;
	else
		c = (signed char)msg_read.data[msg_read.readcount];
	msg_read.readcount++;
	
	return c;
}

int ZD_ReadByte (void)
{
	int	c;
	
	if (msg_read.readcount+1 > msg_read.cursize)
		c = -1;
	else
		c = (unsigned char)msg_read.data[msg_read.readcount];
	msg_read.readcount++;
	
	return c;
}


bool ZD_ReadBytes(byte *buf,int bufsz)
{
	if (msg_read.readcount+bufsz > msg_read.cursize)
	{
		memset(buf,0,bufsz);
		return false;
	}
	else
	{
		memcpy(buf,&(msg_read.data[msg_read.readcount]),bufsz);
		msg_read.readcount += bufsz;
		return true;
	}
}

int ZD_ReadShort (void)
{
	int	c;
	
	if (msg_read.readcount+2 > msg_read.cursize)
		c = -1;
	else		
		c = (short)(msg_read.data[msg_read.readcount]
		+ (msg_read.data[msg_read.readcount+1]<<8));
	
	msg_read.readcount += 2;
	
	return c;
}

int ZD_ReadWord (void)
{
	short v;// = (((*stream)[0]) << 8) | (((*stream)[1]));
	if (msg_read.readcount+2 > msg_read.cursize)
		v = -1;
	else
		v = (msg_read.data[msg_read.readcount]) 
			+ (msg_read.data[msg_read.readcount+1] << 8);
	
	msg_read.readcount += 2;
	return v;
}

int ZD_ReadLong (void)
{
	int	c;
	
	if (msg_read.readcount+4 > msg_read.cursize)
		c = -1;
	else
		c = msg_read.data[msg_read.readcount]
		+ (msg_read.data[msg_read.readcount+1]<<8)
		+ (msg_read.data[msg_read.readcount+2]<<16)
		+ (msg_read.data[msg_read.readcount+3]<<24);
	
	msg_read.readcount += 4;
	
	return c;
}

char *ZD_ReadString (void)
{
	static char	string[2048];
	//int		l,c;
	signed	char	c;
	unsigned int	l;

	l = 0;
	do
	{
		c = ZD_ReadChar ();
		if (c == -1 || c == 0)
			break;
		string[l] = c;
		l++;
	} while (l < sizeof(string)-1);

	string[l] = '\0';

	return string;
}


int		stdin_ready = 0;
int		do_stdin = 1;

//
// I_ConsoleInput - [NightFang] - pulled from the old 0.99 code
//
char *I_ConsoleInput (void)
{
#ifndef	WIN32
	static 	char	text[256];
	int				len;

	if (!stdin_ready || !do_stdin)		return NULL;
	stdin_ready = 0;
	len = read(0, text, sizeof(text)-1);
	if (len < 1)	return NULL;
	text[len-1] = 0;
	return text;
#else
	
// Windows code
	static char		text[256];
	static int		len;
	int				c;

	if (!do_stdin) return NULL;

    // read a line out
    while (_kbhit())
    {
		switch (c = _getch())
		{
			case '\r':
				putch(c);
				putch('\n');
				text[len] = '\0';
				len = 0;
				return text;

			case '\b':
				if (len>0)
				{
					putch (c);
					putch (' ');
				    putch (c);
				    len--;
				}
				break;

			default:
				if (len<sizeof(text)-1)
				{
					putch (c);
					text[len++] = c;
				}
        }
	}
    return NULL;
#endif
}


void I_DoSelect (void)
{
#ifdef		WIN32
    struct timeval   timeout;
    fd_set           fdset;

    FD_ZERO(&fdset);
    FD_SET(net_socket, &fdset);
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    if (select (net_socket+1, &fdset, NULL, NULL, &timeout) == -1)
        return;
#else
    struct timeval   timeout;
    fd_set           fdset;

    FD_ZERO(&fdset);
    if (do_stdin)
    	FD_SET(0, &fdset);
    FD_SET(net_socket, &fdset);
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    if (select (net_socket+1, &fdset, NULL, NULL, &timeout) == -1)
        return;

    stdin_ready = FD_ISSET(0, &fdset);
#endif
}

void
copy_file(const char *infile,const char *outfile)
{
	FILE	*fin,*fout;
	int		n;
	char	fbuf[8192];

	if ( (fin = fopen(infile,"r")) == NULL ) return;
	if ( (fout = fopen(outfile,"w")) == NULL )
	{
		fclose(fin);
		return;
	}
	for (;;)
	{
		n = fread(fbuf,1,sizeof(fbuf),fin);
		if (n<=0) break;
		fwrite(fbuf,1,n,fout);
	}
	fclose(fin);
	fclose(fout);
}
