/***************************************************************************
                          sv_mapcycle.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Zombie Ryushu
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>

#ifdef		WIN32
#include <conio.h>
#endif

#include "doomdef.h"
#include "doomstat.h"
#include "gstrings.h"
#include "d_player.h"
#include "c_cvars.h"
#include "c_dispatch.h"
#include "c_bind.h"
#include "c_console.h"
#include "g_game.h"
#include "g_level.h"
#include "gi.h"
#include "p_local.h"
#include "i_system.h"
#include "g_game.h"
#include "gstrings.h"
#include "s_sound.h"
#include "m_argv.h"
#include "cmdlib.h"
#include "version.h"
#include "m_misc.h"
#include "w_wad.h"
#include "sv_main.h"


// 36 maps can be added at 8 chars a piece
char		*zd_mapcycle[ZD_MAX_MAPS];
int			zd_nummaps;
bool		zd_cycleactive;					// Are we using our map cycle or the engines?
int			zd_nextmap;						// Next # in the array


CCMD(maplist)
{
	int		i,count=0;

	for (i=0; i<zd_nummaps; i++)
	{
		if (strlen(zd_mapcycle[i]) > 0)
		{
			count++;
			Printf("%d. %s\n", i+1, zd_mapcycle[i]);
		}
	}

	Printf("TOTAL: %d\n", zd_nummaps);
}


//
// clearmaplist - starting over fresh
// 

CCMD(clearmaplist)
{
	Printf("Cleared %d maps from que.\n", zd_nummaps);
	zd_nummaps = 0;
	zd_nextmap = 0;
	zd_cycleactive = false;
}


//
// ZD_Addmap - Attempts to add a map the the array
//

void ZD_Addmap(char *map)
{
	if (zd_nummaps >= ZD_MAX_MAPS)
	{
		Printf("ZD_Addmap: Limit reached.\n");
		return;
	}

	if (W_CheckNumForName (map) == -1)
	{
		Printf("ZD_Addmap: No map %s\n", map);
		return;
	}

	zd_mapcycle[zd_nummaps] = copystring(map);

	// We're using custom cycle now...AND FOREVER
	zd_cycleactive = true;

	// Let our user know dis here wak sheit
	if (gamestate == GS_STARTUP)
		Printf("ZD_Addmap: Added %s in slot %d.\n", map, zd_nummaps+1);

	//me it up!
	zd_nummaps++;
}

//
// ZD_NextMap
//

void ZD_NextMap(void)
{
	zd_nextmap++;

	// [NightFang] - error checking
	if (zd_nextmap >= zd_nummaps)
		zd_nextmap = 0;			// restart the cycle
}

//
// ZD_PrevMap
//

void ZD_PrevMap(void)
{
	zd_nextmap--;

	// [NightFang] - error checking
	if (zd_nextmap <= 0)
		zd_nextmap = zd_nummaps;			// restart the cycle
}


//
// addmap - And the command to go with it -- cheers
//

CCMD(addmap)
{
	if (argv.argc() > 1)
		ZD_Addmap(argv[1]);
	else
		Printf("addmap: Adds a map to the playlist.\nUsage: addmap <map>\n");
}

