// Emacs style mode select	 -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: i_net.cpp,v 1.2 2004/10/10 18:49:53 incubus Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// DESCRIPTION:
//		Low-level networking code. Uses BSD sockets for UDP networking.
//
//-----------------------------------------------------------------------------

/* [Petteri] Check if compiling for Win32:	*/
#if defined(__WINDOWS__) || defined(__NT__) || defined(_MSC_VER) || defined(_WIN32)
#	define __WIN32__
#endif
/* Follow #ifdef __WIN32__ marks */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/* [Petteri] Use Winsock for Win32: */
#ifdef __WIN32__
	#define WIN32_LEAN_AND_MEAN
	#include <winsock2.h>
#else
	#ifdef OSF1
	// Need to do this to get unistd.h to declare usleep for us under OSF/1
		#define _XOPEN_SOURCE_EXTENDED
	# endif
	#include <unistd.h>
	#ifdef OSF1
		#undef _XOPEN_SOURCE_EXTENDED
	#endif
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <arpa/inet.h>
	#include <errno.h>
	#include <netdb.h>
	#include <sys/ioctl.h>
#endif

#include "doomtype.h"
#include "i_system.h"
#include "d_event.h"
#include "d_net.h"
#include "m_argv.h"
#include "m_alloc.h"
#include "m_swap.h"
#include "doomstat.h"
#include "i_net.h"

//
// I_InitNetwork
//
void I_InitNetwork (void)
{
	char *v;

	doomcom = new doomcom_t;
	memset (doomcom, 0, sizeof(*doomcom));
	
	// set up for network
	v = Args.CheckValue ("-dup");
	if (v)
	{
		doomcom->ticdup = (short)(v[0]-'0');
		if (doomcom->ticdup < 1)
			doomcom->ticdup = 1;
		if (doomcom->ticdup > 9)
			doomcom->ticdup = 9;
	}
	else
		doomcom-> ticdup = 1;
		
	if (Args.CheckParm ("-extratic"))
		doomcom->extratics = 1;
	else
		doomcom->extratics = 0;
				
	v = Args.CheckValue ("-port");
	if (v)
		Printf ("using alternate port %d\n", atoi (v));
	
	netgame = false;
	doomcom->id = DOOMCOM_ID;
	doomcom->numplayers = doomcom->numnodes = 1;
	doomcom->consoleplayer = 0;
}
