// Emacs style mode select	 -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: wi_stuff.cpp,v 1.3 2004/10/10 18:40:30 incubus Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log: wi_stuff.cpp,v $
// Revision 1.3  2004/10/10 18:40:30  incubus
// Sync with ZDaemon 1.06.07
//
// Revision 1.2  2004/07/21 04:55:40  incubus
// Sync with ZDaemon 1.06.04b
//
// Revision 1.1.1.1  2004/07/20 02:19:20  incubus
// ZDaemon 1.06 source import
//
//
// DESCRIPTION:
//		Intermission screens.
//
//-----------------------------------------------------------------------------


#include <ctype.h>
#include <stdio.h>

#include "z_zone.h"
#include "m_random.h"
#include "m_swap.h"
#include "i_system.h"
#include "w_wad.h"
#include "g_game.h"
#include "g_level.h"
#include "r_local.h"
#include "s_sound.h"
#include "doomstat.h"
#include "v_video.h"
//#include "i_video.h"
#include "wi_stuff.h"
#include "c_console.h"
#include "hu_stuff.h"
#include "v_palette.h"
#include "s_sndseq.h"
#include "gi.h"

// [NightFang] - client/server stuff
#include "sv_main.h"

EXTERN_CVAR (Int,	minplayers)			//Kilgore

// States for the intermission
typedef enum
{
	NoState = -1,
	StatCount,
	ShowNextLoc,
	LeavingIntermission
} stateenum_t;

CVAR (Bool, wi_percents, true, CVAR_ARCHIVE)

void WI_loadData ();
void WI_unloadData ();

#define NEXTSTAGE		(gameinfo.gametype == GAME_Doom ? "weapons/rocklx" : "doors/dr1_clos")
#define PASTSTATS		(gameinfo.gametype == GAME_Doom ? "weapons/shotgr" : "plats/pt1_stop")
//
// Data needed to add patches to full screen intermission pics.
// Patches are statistics messages, and animations.
// Loads of by-pixel layout and placement, offsets etc.
//

#define NUMEPISODES 	6
#define NUMMAPS 		9

// GLOBAL LOCATIONS
#define WI_TITLEY				2
#define WI_SPACINGY 			33

// SINGPLE-PLAYER STUFF
#define SP_STATSX				50
#define SP_STATSY				50

#define SP_TIMEX				16
#define SP_TIMEY				(200-32)


// NET GAME STUFF
#define NG_STATSY				50
#define NG_STATSX				(32 + SHORT(star->width)/2 + 32*!dofrags)

#define NG_SPACINGX 			64


// DEATHMATCH STUFF
#define DM_MATRIXX				42
#define DM_MATRIXY				68

#define DM_SPACINGX 			40

#define DM_TOTALSX				269

#define DM_KILLERSX 			10
#define DM_KILLERSY 			100
#define DM_VICTIMSX 			5
#define DM_VICTIMSY 			50




typedef enum
{
	ANIM_ALWAYS,
	ANIM_LEVEL
} animenum_t;

typedef struct
{
	int x, y;
} yahpt_t;

typedef struct
{
	animenum_t	type;
	int 		period;	// period in tics between animations
	int 		nanims;	// number of animation frames
	yahpt_t 	loc;	// location of animation
	int 		data;	// ALWAYS: n/a, RANDOM: period deviation (<256)
	patch_t*	p[3];	// actual graphics for frames of animations

	// following must be initialized to zero before use!
	int 		nexttic;	// next value of bcnt (used in conjunction with period)
	int 		ctr;		// next frame number to animate
	int 		state;		// used by RANDOM and LEVEL when animating
} in_anim_t;

static yahpt_t lnodes[NUMEPISODES][NUMMAPS] =
{
//
// Doom 1 Episodes
//
	// Episode 1 World Map
	{
		{ 185, 164 },	// location of level 1 (CJ)
		{ 148, 143 },	// location of level 2 (CJ)
		{ 69, 122 },	// location of level 3 (CJ)
		{ 209, 102 },	// location of level 4 (CJ)
		{ 116, 89 },	// location of level 5 (CJ)
		{ 166, 55 },	// location of level 6 (CJ)
		{ 71, 56 }, 	// location of level 7 (CJ)
		{ 135, 29 },	// location of level 8 (CJ)
		{ 71, 24 }		// location of level 9 (CJ)
	},

	// Episode 2 World Map
	{
		{ 254, 25 },	// location of level 1 (CJ)
		{ 97, 50 }, 	// location of level 2 (CJ)
		{ 188, 64 },	// location of level 3 (CJ)
		{ 128, 78 },	// location of level 4 (CJ)
		{ 214, 92 },	// location of level 5 (CJ)
		{ 133, 130 },	// location of level 6 (CJ)
		{ 208, 136 },	// location of level 7 (CJ)
		{ 148, 140 },	// location of level 8 (CJ)
		{ 235, 158 }	// location of level 9 (CJ)
	},

	// Episode 3 World Map
	{
		{ 156, 168 },	// location of level 1 (CJ)
		{ 48, 154 },	// location of level 2 (CJ)
		{ 174, 95 },	// location of level 3 (CJ)
		{ 265, 75 },	// location of level 4 (CJ)
		{ 130, 48 },	// location of level 5 (CJ)
		{ 279, 23 },	// location of level 6 (CJ)
		{ 198, 48 },	// location of level 7 (CJ)
		{ 140, 25 },	// location of level 8 (CJ)
		{ 281, 136 }	// location of level 9 (CJ)
	},
//
// Heretic Episodes
//
	{
		{ 172, 78 },
		{ 86, 90 },
		{ 73, 66 },
		{ 159, 95 },
		{ 148, 126 },
		{ 132, 54 },
		{ 131, 74 },
		{ 208, 138 },
		{ 52, 101 }
	},
	{
		{ 218, 57 },
		{ 137, 81 },
		{ 155, 124 },
		{ 171, 68 },
		{ 250, 86 },
		{ 136, 98 },
		{ 203, 90 },
		{ 220, 140 },
		{ 279, 106 }
	},
	{
		{ 86, 99 },
		{ 124, 103 },
		{ 154, 79 },
		{ 202, 83 },
		{ 178, 59 },
		{ 142, 58 },
		{ 219, 66 },
		{ 247, 57 },
		{ 107, 80 }
	}
};


//
// Animation locations for episode 0 (1).
// Using patches saves a lot of space,
//	as they replace 320x200 full screen frames.
//
static in_anim_t epsd0animinfo[] =
{
	{ ANIM_ALWAYS, TICRATE/3, 3, { 224, 104 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 184, 160 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 112, 136 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 72, 112 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 88, 96 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 64, 48 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 192, 40 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 136, 16 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 80, 16 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 64, 24 } }
};

static in_anim_t epsd1animinfo[] =
{
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 1 },
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 2 },
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 3 },
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 4 },
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 5 },
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 6 },
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 7 },
	{ ANIM_LEVEL, TICRATE/3, 3, { 192, 144 }, 8 },
	{ ANIM_LEVEL, TICRATE/3, 1, { 128, 136 }, 8 }
};

static in_anim_t epsd2animinfo[] =
{
	{ ANIM_ALWAYS, TICRATE/3, 3, { 104, 168 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 40, 136 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 160, 96 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 104, 80 } },
	{ ANIM_ALWAYS, TICRATE/3, 3, { 120, 32 } },
	{ ANIM_ALWAYS, TICRATE/4, 3, { 40, 0 } }
};

static int NUMANIMS[NUMEPISODES] =
{
	sizeof(epsd0animinfo)/sizeof(in_anim_t),
	sizeof(epsd1animinfo)/sizeof(in_anim_t),
	sizeof(epsd2animinfo)/sizeof(in_anim_t)
};

static in_anim_t *anims[NUMEPISODES] =
{
	epsd0animinfo,
	epsd1animinfo,
	epsd2animinfo
};

// [RH] Map name -> index mapping
static char names[NUMEPISODES][NUMMAPS][8] =
{
	{ "E1M1", "E1M2", "E1M3", "E1M4", "E1M5", "E1M6", "E1M7", "E1M8", "E1M9" },
	{ "E2M1", "E2M2", "E2M3", "E2M4", "E2M5", "E2M6", "E2M7", "E2M8", "E2M9" },
	{ "E3M1", "E3M2", "E3M3", "E3M4", "E3M5", "E3M6", "E3M7", "E3M8", "E3M9" }
};

//
// GENERAL DATA
//

//
// Locally used stuff.
//
#define FB (screen)


// States for single-player
#define SP_KILLS				0
#define SP_ITEMS				2
#define SP_SECRET				4
#define SP_FRAGS				6 
#define SP_TIME 				8 
#define SP_PAR					ST_TIME

#define SP_PAUSE				1

#define SHOWNEXTLOCDELAY		4			// in seconds

static int				acceleratestage;	// used to accelerate or skip a stage
static int				me;					// wbs->pnum
static stateenum_t		state;				// specifies current state
static wbstartstruct_t *wbs;				// contains information passed into intermission
static wbplayerstruct_t*plrs;				// wbs->plyr[]
static int				cnt;				// used for general timing
static int				bcnt;				// used for timing of background animation
static int				epsd;				// episode currently displayed

static int				cnt_kills[MAXPLAYERS];
static int				cnt_items[MAXPLAYERS];
static int				cnt_secret[MAXPLAYERS];
static int				cnt_time;
static int				cnt_par;
static int				cnt_pause;

//
//		GRAPHICS
//

static patch_t* 		yah[2];		// You Are Here graphic
static patch_t* 		splat;		// splat
static patch_t* 		percent;	// %, : graphics
static patch_t* 		colon;
static patch_t*			slash;
static patch_t* 		num[10];	// 0-9 graphic
static patch_t* 		wiminus;	// minus sign
static patch_t* 		finished;	// "Finished!" graphics
static patch_t* 		entering;	// "Entering" graphic
static patch_t* 		sp_secret;	// "secret"
static patch_t* 		kills;		// "Kills", "Scrt", "Items", "Frags"
static patch_t* 		secret;
static patch_t* 		items;
static patch_t* 		frags;
static patch_t* 		time;		// Time sucks.
static patch_t* 		par;
static patch_t* 		sucks;
static patch_t* 		killers;	// "killers", "victims"
static patch_t* 		victims;
static patch_t* 		total;		// "Total", your face, your dead face
static patch_t* 		star;
static patch_t* 		bstar;
static patch_t* 		p;			// Player graphic
static patch_t*			lnames[2];	// Name graphics of each level (centered)

// [RH] Info to dynamically generate the level name graphics
static int				lnamewidths[2];
static char				*lnametexts[2];

static DCanvas			*background;

//
// CODE
//

void WI_slamBackground ()
{
	if (background)
	{
		background->Blit (0, 0, background->GetWidth(), background->GetHeight(),
			FB, 0, 0, SCREENWIDTH, SCREENHEIGHT);
	}
	else if (state != NoState)
	{
		int lump = W_CheckNumForName ("FLOOR16", ns_flats);
		if (lump >= 0)
		{
			FB->FlatFill (0, 0, SCREENWIDTH, SCREENHEIGHT,
				(byte *)W_CacheLumpNum (lump, PU_CACHE));
		}
		else
		{
			FB->Clear (0, 0, SCREENWIDTH, SCREENHEIGHT, 0);
		}
	}
}

static int WI_CalcWidth (char *str)
{
	return 0;
}

int WI_MapToIndex (char *map, int ep)
{
	int i;

	if (gameinfo.gametype == GAME_Heretic)
	{
		ep -= 10;
	}

	for (i = 0; i < NUMMAPS; i++)
	{
		if (!strnicmp (names[ep][i], map, 8))
			break;
	}
	return i;
}

void WI_drawOnLnode (int n, patch_t *c[], int episode)
{

	int 	i;
	int 	left;
	int 	top;
	int 	right;
	int 	bottom;
	BOOL 	fits = false;

	if (gameinfo.gametype == GAME_Heretic)
	{
		episode -= 7;
	}
	i = 0;
	do
	{
		left = lnodes[episode][n].x - SHORT(c[i]->leftoffset);
		top = lnodes[episode][n].y - SHORT(c[i]->topoffset);
		right = left + SHORT(c[i]->width);
		bottom = top + SHORT(c[i]->height);

		if (left >= 0 && right < 320 && top >= 0 && bottom < 200)
		{
			fits = true;
		}
		else
		{
			i++;
		}
	} while (!fits && i != 2);

	if (fits && i<2)
	{
		FB->DrawPatchIndirect (c[i], lnodes[episode][n].x, lnodes[episode][n].y);
	}
	else
	{ // DEBUG
		DPrintf ("Could not place patch on level %d", n+1); 
	}
}

void WI_End ()
{
	WI_unloadData ();
	if (background)
	{
		delete background;
		background = NULL;
	}

	//Added by mc
	bglobal.RemoveAllBots(minplayers>0 && consoleplayer!=Net_Arbitrator);
	state = LeavingIntermission;
}

void WI_initNoState ()
{
	state = NoState;
	acceleratestage = 0;
	cnt = 10;
}

void WI_updateNoState ()
{
	if (!--cnt)
	{
		WI_End();
		G_WorldDone();
	}
}

static BOOL snl_pointeron = false;

void WI_initShowNextLoc ()
{
	state = ShowNextLoc;
	acceleratestage = 0;
	cnt = SHOWNEXTLOCDELAY * TICRATE;
	if (epsd != wbs->next_ep && gameinfo.gametype == GAME_Doom)
	{
		WI_unloadData ();
		epsd = wbs->next_ep;
		WI_loadData ();
	}
}

void WI_updateShowNextLoc ()
{
	if (!--cnt || acceleratestage)
		WI_initNoState();
	else
		snl_pointeron = (cnt & 31) < 20;
}

void WI_drawShowNextLoc ()
{
	int i;

	if (gamemode != commercial)
	{
		if ((gameinfo.gametype != GAME_Doom || epsd > 2) &&
			(gameinfo.gametype != GAME_Heretic || epsd > 12 || epsd < 10))
		{
			return;
		}

		int ep = (gameinfo.gametype == GAME_Doom) ? epsd : epsd - 10;

		// draw a splat on taken cities.
		for (i = 0; i < NUMMAPS; i++)
		{
			if (FindLevelInfo (names[ep][i])->flags & LEVEL_VISITED)
				WI_drawOnLnode (i, &splat, epsd);
		}

		// draw flashing ptr
		if (snl_pointeron)
			WI_drawOnLnode (WI_MapToIndex (wbs->next, wbs->next_ep), yah, wbs->next_ep); 
	}
}

void WI_drawNoState ()
{
	snl_pointeron = true;
	WI_drawShowNextLoc ();
}

int WI_fragSum (int playernum)
{
	int i, frags;
	
	frags = 0;
	for (i=top_client; i>=0; i--)
	{
		if (playeringame[i] && i!=playernum)
		{
			frags += plrs[playernum].frags[i];
		}
	}
		
	// JDC hack - negative frags.
	frags -= plrs[playernum].frags[playernum];

	return frags;
}

static int dm_state;
static int dm_frags[MAXPLAYERS][MAXPLAYERS];
static int dm_totals[MAXPLAYERS];

void WI_initDeathmatchStats (void)
{
	int i, j;

	state = StatCount;
	acceleratestage = 0;
	dm_state = 1;

	cnt_pause = TICRATE;

	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i]) continue;
		for (j=top_client;  j>=0;  j--)
		{
			if (playeringame[j])
				dm_frags[i][j] = 0;
		}
		dm_totals[i] = 0;
	}
}

void WI_updateDeathmatchStats ()
{
	int i, j;
	BOOL stillticking;

	if (acceleratestage && dm_state != 4)
	{
		acceleratestage = 0;

		for (i=top_client;  i>=0;  i--)
		{
			if (!playeringame[i]) continue;
			for (j=top_client;  j>=0;  j--)
			{
				if (playeringame[j])
					dm_frags[i][j] = plrs[i].frags[j];
			}

			dm_totals[i] = WI_fragSum(i);
		}
		

		S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
		dm_state = 4;
	}

	if (dm_state == 2)
	{
		if (!(bcnt&3))
			S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);
		
		stillticking = false;

		for (i=0 ; i<=top_client ; i++)
		{
			if (playeringame[i])
			{
				for (j=0 ; j<=top_client; j++)
				{
					if (playeringame[j]
						&& dm_frags[i][j] != plrs[i].frags[j])
					{
						if (plrs[i].frags[j] < 0)
							dm_frags[i][j]--;
						else
							dm_frags[i][j]++;

						if (dm_frags[i][j] > 99)
							dm_frags[i][j] = 99;

						if (dm_frags[i][j] < -99)
							dm_frags[i][j] = -99;
						
						stillticking = true;
					}
				}
				dm_totals[i] = WI_fragSum(i);

				if (dm_totals[i] > 99)
					dm_totals[i] = 99;
				
				if (dm_totals[i] < -99)
					dm_totals[i] = -99;
			}
			
		}
		if (!stillticking)
		{
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
			dm_state++;
		}

	}
	else if (dm_state == 4)
	{
		if (acceleratestage)
		{
			S_Sound (CHAN_VOICE, "players/male/gibbed", 1, ATTN_NONE);

			if (gamemode == commercial)
				WI_initNoState();
			else
				WI_initShowNextLoc();
		}
	}
	else if (dm_state & 1)
	{
		if (!--cnt_pause)
		{
			dm_state++;
			cnt_pause = TICRATE;
		}
	}
}

static int cnt_frags[MAXPLAYERS];
static int dofrags;
static int ng_state;

void WI_initNetgameStats ()
{
	int i;

	state = StatCount;
	acceleratestage = 0;
	ng_state = 1;
	cnt_pause = TICRATE;
	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i]) continue;
		cnt_kills[i] = cnt_items[i] = cnt_secret[i] = cnt_frags[i] = 0;
		dofrags += WI_fragSum (i);
	}
	dofrags = !!dofrags;
}

void WI_updateNetgameStats ()
{
	int i;
	int fsum;
	BOOL stillticking;

	if (acceleratestage && ng_state != 10)
	{
		acceleratestage = 0;

		for (i=top_client;  i>=0;  i--)
		{
			if (!playeringame[i]) continue;
			cnt_kills[i] = plrs[i].skills;
			cnt_items[i] = plrs[i].sitems;
			cnt_secret[i] = plrs[i].ssecret;
			if (dofrags) cnt_frags[i] = WI_fragSum (i);
		}
		S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
		ng_state = 10;
	}

	if (ng_state == 2)
	{
		if (!(bcnt&3))
			S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);

		stillticking = false;
		for (i=top_client;  i>=0;  i--)
		{
			if (!playeringame[i]) continue;
			cnt_kills[i] += 2;
			if (cnt_kills[i] > plrs[i].skills)
				cnt_kills[i] = plrs[i].skills;
			else
				stillticking = true;
		}
		
		if (!stillticking)
		{
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
			ng_state++;
		}
	}
	else if (ng_state == 4)
	{
		if (!(bcnt&3))
			S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);

		stillticking = false;
		for (i=top_client;  i>=0;  i--)
		{
			if (!playeringame[i]) continue;
			cnt_items[i] += 2;
			if (cnt_items[i] > plrs[i].sitems)
				cnt_items[i] = plrs[i].sitems;
			else
				stillticking = true;
		}
		if (!stillticking)
		{
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
			ng_state++;
		}
	}
	else if (ng_state == 6)
	{
		if (!(bcnt&3))
			S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);

		stillticking = false;
		for (i=top_client;  i>=0;  i--)
		{
			if (!playeringame[i]) continue;
			cnt_secret[i] += 2;
			if (cnt_secret[i] > plrs[i].ssecret)
				cnt_secret[i] = plrs[i].ssecret;
			else
				stillticking = true;
		}
		
		if (!stillticking)
		{
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
			ng_state += 1 + 2*!dofrags;
		}
	}
	else if (ng_state == 8)
	{
		if (!(bcnt&3))
			S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);

		stillticking = false;
		for (i=top_client;  i>=0;  i--)
		{
			if (!playeringame[i]) continue;
			cnt_frags[i] += 1;
			if (cnt_frags[i] >= (fsum = WI_fragSum(i)))
				cnt_frags[i] = fsum;
			else
				stillticking = true;
		}
		
		if (!stillticking)
		{
			S_Sound (CHAN_VOICE, "player/male/death1", 1, ATTN_NONE);
			ng_state++;
		}
	}
	else if (ng_state == 10)
	{
		if (acceleratestage)
		{
			S_Sound (CHAN_VOICE, PASTSTATS, 1, ATTN_NONE);
			if ( gamemode == commercial )
				WI_initNoState();
			else
				WI_initShowNextLoc();
		}
	}
	else if (ng_state & 1)
	{
		if (!--cnt_pause)
		{
			ng_state++;
			cnt_pause = TICRATE;
		}
	}
}

static int sp_state;

void WI_initStats ()
{
	state = StatCount;
	acceleratestage = 0;
	sp_state = 1;
	cnt_kills[0] = cnt_items[0] = cnt_secret[0] = -1;
	cnt_time = cnt_par = -1;
	cnt_pause = TICRATE;
}

void WI_updateStats ()
{
	if ((gameinfo.gametype != GAME_Doom || acceleratestage)
		&& sp_state != 10)
	{
		if (acceleratestage)
		{
			acceleratestage = 0;
			sp_state = 10;
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
		}
		cnt_kills[0] = plrs[me].skills;
		cnt_items[0] = plrs[me].sitems;
		cnt_secret[0] = plrs[me].ssecret;
		cnt_time = plrs[me].stime / TICRATE;
		cnt_par = wbs->partime / TICRATE;
	}

	if (sp_state == 2)
	{
		if (gameinfo.gametype == GAME_Doom)
		{
			cnt_kills[0] += 2;

			if (!(bcnt&3))
				S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);
		}
		if (cnt_kills[0] >= plrs[me].skills)
		{
			cnt_kills[0] = plrs[me].skills;
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
			sp_state++;
		}
	}
	else if (sp_state == 4)
	{
		if (gameinfo.gametype == GAME_Doom)
		{
			cnt_items[0] += 2;

			if (!(bcnt&3))
				S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);
		}
		if (cnt_items[0] >= plrs[me].sitems)
		{
			cnt_items[0] = plrs[me].sitems;
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
			sp_state++;
		}
	}
	else if (sp_state == 6)
	{
		if (gameinfo.gametype == GAME_Doom)
		{
			cnt_secret[0] += 2;

			if (!(bcnt&3))
				S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);
		}
		if (cnt_secret[0] >= plrs[me].ssecret)
		{
			cnt_secret[0] = plrs[me].ssecret;
			S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
			sp_state++;
		}
	}
	else if (sp_state == 8)
	{
		if (gameinfo.gametype == GAME_Doom)
		{
			if (!(bcnt&3))
				S_Sound (CHAN_VOICE, "weapons/pistol", 1, ATTN_NONE);

			cnt_time += 3;
			cnt_par += 3;
		}

		if (cnt_time >= plrs[me].stime / TICRATE)
			cnt_time = plrs[me].stime / TICRATE;

		if (cnt_par >= wbs->partime / TICRATE)
		{
			cnt_par = wbs->partime / TICRATE;

			if (cnt_time >= plrs[me].stime / TICRATE)
			{
				S_Sound (CHAN_VOICE, NEXTSTAGE, 1, ATTN_NONE);
				sp_state++;
			}
		}
	}
	else if (sp_state == 10)
	{
		if (acceleratestage)
		{
			S_Sound (CHAN_VOICE, PASTSTATS, 1, ATTN_NONE);

			if (gamemode == commercial)
				WI_initNoState();
			else
				WI_initShowNextLoc();
		}
	}
	else if (sp_state & 1)
	{
		if (!--cnt_pause)
		{
			sp_state++;
			cnt_pause = TICRATE;
		}
	}
}

EXTERN_CVAR (Int, maxteams)	//Kilgore

//Kilgore: announcements about the game outcome
static int check_for_trouncing(int best, int second_best)
{
	const static double f1 = 2.0;
	const static double f2 = 3.0;
	const static double f3 = 4.0;
	const static double epsilon = 1.0e-6;
	int lower_limit;
	double dbest, dsecbest;

	#if __CTF__
	if (ctf) lower_limit = 3;
	else
	#endif
	lower_limit = 5;
	if (best<0)			best = 0;
	if (second_best<0)	second_best = 0;
	dbest = best;
	dsecbest = second_best;

	if (second_best < lower_limit)
	{
		if ( dbest >= dsecbest + (f3-1.0)*lower_limit - epsilon )	return SE_HOLY_SHIT;
		if ( dbest >= dsecbest + (f2-1.0)*lower_limit - epsilon )	return SE_HUMILIATION;
		if ( dbest >= dsecbest + (f1-1.0)*lower_limit - epsilon )	return SE_IMPRESSIVE;
	}
	else
	{
		if ( dbest >= f3*dsecbest - epsilon )	return SE_HOLY_SHIT;
		if ( dbest >= f2*dsecbest - epsilon )	return SE_HUMILIATION;
		if ( dbest >= f1*dsecbest - epsilon )	return SE_IMPRESSIVE;
	}
	return -1;		// Defaults to invalid (ie., no announcement)
}


//Kilgore: announcements about the game outcome
static void announce_results(void)
{
	int		se, i, tm, nplayers, nteams, best, second_best, l_maxteams, nmembers[NUM_TEAMS];

	best = second_best = -100000;
	if (teamplay)
	{
		l_maxteams = maxteams;
		memset(nmembers,0,sizeof(nmembers));
		for (i=top_client;  i>=0;  i--)
		{
			if (!wminfo.plyr[i].in || wminfo.plyr[i].spectator) continue;
			tm = wminfo.plyr[i].team;
			if (tm<0 || tm>=l_maxteams) continue;
			(nmembers[tm])++;
		}
		nteams = 0;
		for (i=0; i<NUM_TEAMS; i++)
		{
			if (nmembers[i]) nteams++;
		}
		if (nteams>1)
		{
			for (i=top_client;  i>=0;  i--)
			{
				if (!wminfo.plyr[i].in ||
					wminfo.plyr[i].spectator ||
					wminfo.plyr[i].lead_state == LS_LEAD_UNDEFINED) continue;
				ZD_Special_To_Player(i,
					(wminfo.plyr[i].lead_state==LS_LEAD_HAS) ?	SE_WIN :
					(wminfo.plyr[i].lead_state==LS_LEAD_TIED) ?	SE_TIED :
																SE_LOSE,
					0);
			}
			for (i=0; i<l_maxteams; i++)
			{
				if (TeamInfo[i].score>=best)
				{
					second_best = best;
					best = TeamInfo[i].score;
				}
				else if (TeamInfo[i].score>second_best)
				{
					second_best = TeamInfo[i].score;
				}
			}
		}
	}
	else if (deathmatch)
	{
		nplayers = 0;
		for (i=top_client;  i>=0;  i--)
		{
			if (wminfo.plyr[i].in && !wminfo.plyr[i].spectator)	nplayers++;
		}
		if (nplayers>1)
		{
			for (i=top_client;  i>=0;  i--)
			{
				if (!wminfo.plyr[i].in ||
					wminfo.plyr[i].spectator ||
					wminfo.plyr[i].lead_state == LS_LEAD_UNDEFINED) continue;
				ZD_Special_To_Player(i,
					(wminfo.plyr[i].lead_state==LS_LEAD_HAS) ?	SE_WIN :
					(wminfo.plyr[i].lead_state==LS_LEAD_TIED) ?	SE_TIED :
																SE_LOSE,
					0);
			}
			for (i=top_client;  i>=0;  i--)
			{
				if (!wminfo.plyr[i].in || wminfo.plyr[i].spectator) continue;
				if (wminfo.plyr[i].fragcount>=best)
				{
					second_best = best;
					best = wminfo.plyr[i].fragcount;
				}
				else if (wminfo.plyr[i].fragcount>second_best)
				{
					second_best = wminfo.plyr[i].fragcount;
				}
			}
		}
	}
	// Check for impressive/humiliation/holy_shit
	se = check_for_trouncing(best,second_best);
	if (se>=0)	ZD_Special_To_All((spec_event_t) se,0);
}



// [NightFang] - added
int		wi_stopwatch;

void WI_checkForAccelerate (void)
{
	int i, intermission_time;
	player_t *player;

	// [NightFang] - go anyway after 16 seconds
	wi_stopwatch++;

	if (wi_stopwatch == 2*TICRATE)				//Kilgore: announce win/lose after 2 secs.
	{
		announce_results();
	}

	intermission_time = (teamplay) ? 20*TICRATE : 15*TICRATE;

	if (wi_stopwatch == intermission_time-3*TICRATE)	//Kilgore: announce 3 secs. before start
		ZD_Special_To_All(SE_PREPARE,0);

	if (wi_stopwatch >= intermission_time)
	{
		wi_stopwatch = 0;
		acceleratestage = 1;
	}

	// check for button presses to skip delays
	// [NightFang] - everything is done with timers
	for (i=top_client;  i>=0;  i--)
	{
		player = players + i;
		if (playeringame[i])
		{
			if ((player->cmd.ucmd.buttons ^ player->oldbuttons) &&
				((players[i].cmd.ucmd.buttons & players[i].oldbuttons)
					== players[i].oldbuttons))
			{
				// [NightFang] - player is Ready!
				player->readytogo = 10;

				// [NightFang] - todo: relay this message to all clients and 
				//				 have it displayed visually
			}
			player->oldbuttons = player->cmd.ucmd.buttons;
		}
	}
}

// Updates stuff each tick
void WI_Ticker ()
{
	// counter for general background animation
	bcnt++;  

	// [NightFang] - keep updating laggers with the exit flag
	// every half second or so...
	if (!(bcnt % 17))
	{
		for (int i=top_client;  i>=0;  i--)
		{	
			// Either not playing or already ready
			if (!ZD_ValidClient(i) || players[i].readytogo > 0)	continue;
			ZDOP.Init();
			ZDOP.WriteByte(sv_exitlevel);
			ZDOP.WriteByte(zd_nextpos);
			ZDOP.ToPlayer(i);
			ZD_SendPacket(i);
		}
	}

	if (bcnt == 1)
	{
		// intermission music
		S_ChangeMusic(	(gameinfo.gametype == GAME_Heretic)	?	"mus_intr" :
						(gamemode == commercial)			?	"d_dm2int" :
																"d_inter" ); 
	}

	WI_checkForAccelerate ();

	switch (state)
	{
	case StatCount:
		if (deathmatch)
			WI_updateDeathmatchStats ();
		else if (multiplayer)
			WI_updateNetgameStats ();
		else
			WI_updateStats ();
		break;
	
	case ShowNextLoc:
		WI_updateShowNextLoc ();
		break;
	
	case NoState:
		WI_updateNoState ();
		break;

	case LeavingIntermission:
		break;	// Silence GCC
	}
}

void WI_loadData ()
{
	int i, j;
	char name[9];
	in_anim_t *a;

	if (gameinfo.gametype == GAME_Doom)
	{
		for (i = 0; i < 2; i++)
		{
			char *lname = (i == 0 ? wbs->lname0 : wbs->lname1);

			j = lname ? W_CheckNumForName (lname) : -1;

			if (j >= 0)
			{
				lnames[i] = (patch_t *)W_CacheLumpNum (j, PU_STATIC);
			}
			else
			{
				lnames[i] = NULL;
				lnametexts[i] = FindLevelInfo (i == 0 ? wbs->current : wbs->next)->level_name;
				lnamewidths[i] = WI_CalcWidth (lnametexts[i]);
			}
		}
	}
	else
	{
		background = NULL;
	}

	if (gameinfo.gametype == GAME_Doom &&
		gamemode != commercial &&
		epsd < 3)
	{
		for (j = 0; j < NUMANIMS[epsd]; j++)
		{
			a = &anims[epsd][j];
			for (i = 0; i < a->nanims; i++)
			{
				// MONDO HACK!
				if (epsd != 1 || j != 8) 
				{
					// animations
					sprintf (name, "WIA%d%.2d%.2d", epsd, j, i);  
					a->p[i] = (patch_t *)W_CacheLumpName (name, PU_STATIC);
				}
				else
				{
					// HACK ALERT!
					a->p[i] = anims[1][4].p[i];
				}
			}
		}
	}

	if (gameinfo.gametype == GAME_Doom)
	{
		if (gamemode != commercial)
		{
			yah[0] = (patch_t *)W_CacheLumpName ("WIURH0", PU_STATIC);	// you are here
			yah[1] = (patch_t *)W_CacheLumpName ("WIURH1", PU_STATIC);	// you are here (alt.)
			splat = (patch_t *)W_CacheLumpName ("WISPLAT", PU_STATIC);	// splat
		}
		wiminus = (patch_t *)W_CacheLumpName ("WIMINUS", PU_STATIC);	// minus sign
		percent = (patch_t *)W_CacheLumpName ("WIPCNT", PU_STATIC);		// percent sign
		finished = (patch_t *)W_CacheLumpName ("WIF", PU_STATIC);		// "finished"
		entering = (patch_t *)W_CacheLumpName ("WIENTER", PU_STATIC);	// "entering"
		kills = (patch_t *)W_CacheLumpName ("WIOSTK", PU_STATIC);		// "kills"
		secret = (patch_t *)W_CacheLumpName ("WIOSTS", PU_STATIC);		// "scrt"
		sp_secret = (patch_t *)W_CacheLumpName ("WISCRT2", PU_STATIC);	// "secret"
		items = (patch_t *)W_CacheLumpName ("WIOSTI", PU_STATIC);		// "items"
		frags = (patch_t *)W_CacheLumpName ("WIFRGS", PU_STATIC);		// "frgs"
		colon = (patch_t *)W_CacheLumpName ("WICOLON", PU_STATIC);		// ":"
		time = (patch_t *)W_CacheLumpName ("WITIME", PU_STATIC);		// "time"
		sucks = (patch_t *)W_CacheLumpName ("WISUCKS", PU_STATIC);		// "sucks"
		par = (patch_t *)W_CacheLumpName ("WIPAR", PU_STATIC);			// "par"
		killers = (patch_t *)W_CacheLumpName ("WIKILRS", PU_STATIC);	// "killers" (vertical)
		victims = (patch_t *)W_CacheLumpName ("WIVCTMS", PU_STATIC);	// "victims" (horiz)
		total = (patch_t *)W_CacheLumpName ("WIMSTT", PU_STATIC);		// "total"
		star = (patch_t *)W_CacheLumpName ("STFST01", PU_STATIC);		// your face
		bstar = (patch_t *)W_CacheLumpName("STFDEAD0", PU_STATIC);		// dead face
		p = (patch_t *)W_CacheLumpName ("STPBANY", PU_STATIC);

		for (i = 0; i < 10; i++)
		{ // numbers 0-9
			sprintf (name, "WINUM%d", i);	 
			num[i] = (patch_t *)W_CacheLumpName (name, PU_STATIC);
		}
	}
	else
	{
		yah[0] =
		yah[1] = (patch_t *)W_CacheLumpName ("IN_YAH", PU_STATIC);
		splat = (patch_t *)W_CacheLumpName ("IN_X", PU_STATIC);
		wiminus = (patch_t *)W_CacheLumpName ("FONTB13", PU_STATIC);
		percent = (patch_t *)W_CacheLumpName ("FONTB05", PU_STATIC);
		colon = (patch_t *)W_CacheLumpName ("FONTB26", PU_STATIC);
		slash = (patch_t *)W_CacheLumpName ("FONTB15", PU_STATIC);
		star = (patch_t *)W_CacheLumpName ("FACEA0", PU_STATIC);
		bstar = (patch_t *)W_CacheLumpName ("FACEB0", PU_STATIC);

		for (i = 0; i < 10; i++)
		{
			sprintf (name, "FONTB%d", 16 + i);
			num[i] = (patch_t *)W_CacheLumpName (name, PU_STATIC);
		}

		for (i = 0; i < 2; i++)
		{
			lnames[i] = NULL;
			lnametexts[i] = FindLevelInfo (i == 0 ? wbs->current : wbs->next)->level_name;
			lnamewidths[i] = WI_CalcWidth (lnametexts[i]);
		}
	}
}

void WI_unloadData ()
{
	int i, j;

	Z_ChangeTag (wiminus, PU_CACHE);

	for (i = 0; i < 10; i++)
	{
		Z_ChangeTag (num[i], PU_CACHE);
	}

	for (i = 0; i < 2; i++)
	{
		if (lnames[i])
		{
			Z_ChangeTag (lnames[i], PU_CACHE);
			lnames[i] = NULL;
		}
	}
	
	if (gamemode != commercial)
	{
		Z_ChangeTag (yah[0], PU_CACHE);
		Z_ChangeTag (yah[1], PU_CACHE);
		Z_ChangeTag (splat, PU_CACHE);
		
		if (gameinfo.gametype == GAME_Doom && epsd < 3)
		{
			for (j = 0; j < NUMANIMS[epsd]; j++)
			{
				if (epsd != 1 || j != 8)
				{
					for (i = 0; i < anims[epsd][j].nanims; i++)
						Z_ChangeTag (anims[epsd][j].p[i], PU_CACHE);
				}
			}
		}
	}

	if (percent)	{ Z_ChangeTag (percent, PU_CACHE);		percent = NULL; }
	if (colon)		{ Z_ChangeTag (colon, PU_CACHE);		colon = NULL; }
	if (finished)	{ Z_ChangeTag (finished, PU_CACHE);		finished = NULL; }
	if (entering)	{ Z_ChangeTag (entering, PU_CACHE);		entering = NULL; }
	if (kills)		{ Z_ChangeTag (kills, PU_CACHE);		kills = NULL; }
	if (secret)		{ Z_ChangeTag (secret, PU_CACHE);		secret = NULL; }
	if (sp_secret)	{ Z_ChangeTag (sp_secret, PU_CACHE);	sp_secret = NULL; }
	if (items)		{ Z_ChangeTag (items, PU_CACHE);		items = NULL; }
	if (frags)		{ Z_ChangeTag (frags, PU_CACHE);		frags = NULL; }
	if (time)		{ Z_ChangeTag (time, PU_CACHE);			time = NULL; }
	if (sucks)		{ Z_ChangeTag (sucks, PU_CACHE);		sucks = NULL; }
	if (par)		{ Z_ChangeTag (par, PU_CACHE);			par = NULL; }
	if (victims)	{ Z_ChangeTag (victims, PU_CACHE);		victims = NULL; }
	if (killers)	{ Z_ChangeTag (killers, PU_CACHE);		killers = NULL; }
	if (total)		{ Z_ChangeTag (total, PU_CACHE);		total = NULL; }
	if (p)			{ Z_ChangeTag (p, PU_CACHE);			p = NULL; }
	if (slash)		{ Z_ChangeTag (slash, PU_CACHE);		slash = NULL; }
}


void WI_initVariables (wbstartstruct_t *wbstartstruct)
{
	wbs = wbstartstruct;

	acceleratestage = 0;
	cnt = bcnt = 0;
	me = wbs->pnum;
	plrs = wbs->plyr;
	epsd = wbs->finished_ep;
}

void WI_Start (wbstartstruct_t *wbstartstruct)
{
	V_SetBlend (0,0,0,0);
	WI_initVariables (wbstartstruct);
	WI_loadData ();
	if (deathmatch)
		WI_initDeathmatchStats();
	else if (multiplayer)
		WI_initNetgameStats();
	else
		WI_initStats();
	S_StopAllChannels ();
	SN_StopAllSequences ();
}
