#!/bin/sh
GCCVER=`gcc --version | head -1 | sed -e 's/[^0-9]//g' | sed -e 's/^\(.\).*$/\1/g'`

case "`uname -s`" in 
  FreeBSD)
	MC="gmake -f makefile.freebsd.$GCCVER"
	;;
  NetBSD)
	MC="gmake -f makefile.netbsd"
	;;
  OpenBSD)
        MC="gmake -f makefile.openbsd"
        ;;
  DragonFly)
	MC="gmake -f makefile.dragonfly"
	;;
  Linux)	
	MC="make -f makefile.linux.$GCCVER"
	;;
  *)
	echo "X-Doom isn't supported on this platform."
	echo "Supported Platforms: Linux, FreeBSD, OpenBSD, NetBSD, DragonFlyBSD"
	exit 0
	;;
esac

echo "Building X-Doom (Old-School ZDaemon Server)..." 
$MC  
