/*******************************************
* B_game.h                                 *
* Description:                             *
* Misc things that has to do with the bot, *
* like it's spawning etc.                  *
* Makes the bot fit into game              *
*                                          *
*******************************************/
/*The files which are modified for Cajun Purpose
D_player.h (v0.85: added some variables)
D_netcmd.c (v0.71)
D_netcmd.h (v0.71)
D_main.c   (v0.71)
D_ticcmd.h (v0.71)
G_input.c  (v0.95: added some keycommands)
G_input.h  (v0.95)
P_mobj.c   (v0.95: changed much in the P_MobjThinker(), a little in P_SpawnPlayerMissile(), maybee something else )
P_mobj.h   (v0.95: Removed some unnecessary variables)
P_user.c   (v0.95: It's only one change maybee it already was there in 0.71)
P_inter.c  (v0.95: lot of changes)
P_pspr.c   (v0.71)
P_map.c    (v0.95: Test missile for bots)
P_tick.c   (v0.95: Freeze mode things only)
P_local.h  (v0.95: added> extern int tmsectortype)
Info.c     (v0.95: maybee same as 0.71)
Info.h     (v0.95: maybee same as 0.71)
M_menu.c   (v0.95: an extra menu in the key setup with the new commands)
R_main.c   (v0.95: Fix for bot's view)
wi_stuff.c (v0.97: To remove bots correct)

(v0.85) Removed all my code from: P_enemy.c
New file: b_move.c

******************************************
What I know has to be done. in near future.

- Do some hunting/fleeing functions.
- Make the roaming 100% flawfree.
- Fix all SIGSEVS (Below is known SIGSEVS)
      -Nada (but they might be there)
******************************************
Everything that is changed is marked (maybe commented) with "Added by MC"
*/

#include <time.h>
#include "doomdef.h"
#include "p_local.h"
#include "b_bot.h"
#include "g_game.h"
#include "m_random.h"
#include "z_zone.h"
#include "r_things.h"
#include "doomstat.h"
#include "cmdlib.h"
#include "sc_man.h"
#include "stats.h"
#include "m_misc.h"
#include "sv_main.h"
#include "log.h"
#include "wi_stuff.h"

//Externs
DCajunMaster bglobal;
cycle_t BotThinkCycles, BotSupportCycles;

EXTERN_CVAR (Int,	maxteams)				//Kilgore
EXTERN_CVAR (Int,	minplayers)				//Kilgore
EXTERN_CVAR (Int,   removebotswhenhumans)	//Kilgore

void update_lead_states_on_enter(player_t *player);


static const char *BotConfigStrings[] =
{
	"name",
	"aiming",
	"perfection",
	"reaction",
	"isp",
	"esp",
	"chatprob",
	NULL
};

enum
{
	BOTCFG_NAME,
	BOTCFG_AIMING,
	BOTCFG_PERFECTION,
	BOTCFG_REACTION,
	BOTCFG_ISP,
	BOTCFG_ESP,
	BOTCFG_CHATPROB
};


void G_DoReborn (int playernum, bool freshbot);

//This function is called every tick (from g_game.c),
//send bots into thinking (+more).
void DCajunMaster::Main (int buf)
{
	BotThinkCycles = 0;

	Process_Bot_Chat();

	if (gamestate != GS_LEVEL)	return;

	m_Thinking = true;

	//Think for bots.
	if (botnum)
	{
		clock(BotThinkCycles);
		for (int i=top_client; i>=0; i--)
		{
			if (playeringame[i] && players[i].isbot && players[i].mo && !freeze)
				Think (players[i].mo, &players[i].cmd); 
		}
		unclock (BotThinkCycles);
	}

	//Add new bots?
	if (wanted_botnum > botnum && !freeze)
	{
		if ( ++bot_spawn_timer >= SPAWN_DELAY )
		{
			const char * const botname = (getspawned) ? getspawned->GetArg(spawn_tries) : NULL;
            if (!SpawnBot(botname))	wanted_botnum--;
            spawn_tries++;
			bot_spawn_timer = 0;
		}
	}

	m_Thinking = false;
}

void DCajunMaster::Init ()
{
	botnum = 0;
	thingnum = 0;
	firstthing = NULL;
	itemsdone = false;
	spawn_tries = 0;
	freeze = false;
	observer = false;
	body1 = NULL;
	body2 = NULL;
	bot_spawn_timer = 0;
	botchat_head = NULL;

	//Determine Combat distance for each weapon.
	if (deathmatch)
	{
		combatdst[wp_pistol]       = 25000000;
		combatdst[wp_shotgun]      = 24000000;
		combatdst[wp_chaingun]     = 27000000;
		combatdst[wp_missile]      = (SAFE_SELF_MISDIST*2);
		combatdst[wp_plasma]       = 27000000;
		combatdst[wp_bfg]          = 10000000;
		combatdst[wp_supershotgun] = 15000000;

		combatdst[wp_goldwand]     = 25000000;
		combatdst[wp_crossbow]     = 24000000;
		combatdst[wp_blaster]      = 27000000;
		combatdst[wp_skullrod]     = 27000000;
		combatdst[wp_phoenixrod]   = (SAFE_SELF_MISDIST*2);
		combatdst[wp_mace]         = 10000000;
	}
	else
	{
		combatdst[wp_pistol]       = 15000000;
		combatdst[wp_shotgun]      = 14000000;
		combatdst[wp_chaingun]     = 17000000;
		combatdst[wp_missile]      = (SAFE_SELF_MISDIST*3/2);
		combatdst[wp_plasma]       = 17000000;
		combatdst[wp_bfg]          = 6000000;
		combatdst[wp_supershotgun] = 10000000;

		combatdst[wp_goldwand]     = 15000000;
		combatdst[wp_crossbow]     = 14000000;
		combatdst[wp_blaster]      = 17000000;
		combatdst[wp_skullrod]     = 17000000;
		combatdst[wp_phoenixrod]   = (SAFE_SELF_MISDIST*3/2);
		combatdst[wp_mace]         = 60000000;
	}
	combatdst[wp_fist]         = 1;
	combatdst[wp_chainsaw]     = 1;
	combatdst[wp_staff]        = 1;
	combatdst[wp_gauntlets]    = 1;
	combatdst[wp_beak]         = 1;
	combatdst[wp_snout]        = 1;
	combatdst[wp_ffist]        = 1;
	combatdst[wp_cmace]        = 1;

	if (!botinfo)
	{
		LoadBots();
	}
	else
	{
		for (botinfo_t *b=botinfo;  b;  b=b->next)
			b->inuse = false;
	}
}

//Called on each level exit (from g_game.c).
void DCajunMaster::End ()
{
	//Arrange wanted botnum and their names, so they can be spawned next level.
	if (getspawned)	getspawned->FlushArgs ();
	else			getspawned = new DArgs;
	for (int i=top_client; i>=0; i--)
	{
		if (playeringame[i] && players[i].isbot)
		{
			if (minplayers<=0 && deathmatch)
				getspawned->AppendArg(players[i].userinfo.netname);
		}
	}
	wanted_botnum = getspawned->NumArgs();
}

//Name can be optional, if = NULL
//then a random bot is spawned.
//If no bot with name = name found
//the function will CONS print an
//error message and will not spawn
//anything.
//The color parameter can be either a
//color (range from 0-10), or = NOCOLOR.
//The color parameter overides bots
//induvidual colors if not = NOCOLOR.

bool DCajunMaster::SpawnBot (const char *name, int color)
{
	int			i, bnum;
	botinfo_t	*thebot;

	//COLORS
	static const char colors[11][17] =
	{
		"\\color\\40 cf 00",	//0  = Green
		"\\color\\b0 b0 b0",	//1  = Gray
		"\\color\\50 50 60",	//2  = Indigo
		"\\color\\8f 00 00",	//3  = Deep Red
		"\\color\\ff ff ff",	//4  = White
		"\\color\\ff af 3f",	//5  = Bright Brown
		"\\color\\bf 00 00",	//6  = Red
		"\\color\\00 00 ff",	//7  = Blue
		"\\color\\00 00 7f",	//8  = Dark Blue
		"\\color\\ff ff 00",	//9  = Yellow
		"\\color\\cf df 90"		//10 = Bleached Bone
	};

	if (ZD_PlayerCount()>=(int)maxplayers)
	{
		Printf ("The maximum of %d players/bots has been reached\n", (int)maxplayers);
		return false;
	}
	for (i=0; i<MAXPLAYERS; i++)
	{
		if (!playeringame[i]) break;
	}
	if (i>=MAXPLAYERS || i>=(int)maxclients)
	{
		Printf ("The maximum of %d clients has been reached\n", (int)maxclients);
		return false;
	}
	bnum = i;

	if (name)
	{
		thebot = botinfo;

		// Check if exist or already in the game.
		while (thebot && stricmp (name, thebot->name))
			thebot = thebot->next;

		if (thebot == NULL)
		{
   		 	Printf ("couldn't find %s in %s\n", name, BOTFILENAME);
			return false;
		}
		else if (thebot->inuse)
		{
   		 	Printf ("%s is already in the thick\n", name);
			return false;
		}
	}
	else if (botnum < loaded_bots)
	{
		bool vacant = false;  //Spawn a random bot from bots.cfg if no name given.
		while (!vacant)
		{
			int rnum = (P_Random(pr_botspawn) % loaded_bots);
			thebot = botinfo;
			while (rnum)
				--rnum, thebot = thebot->next;
			if (!thebot->inuse)
				vacant = true;
		}
	}
	else
	{
		Printf ("Couldn't spawn bot; no bot left in %s\n", BOTFILENAME);
		return false;
	}

	Net_WriteByte (DEM_ADDBOT);
	Net_WriteByte (bnum);
	//Set color.
	if (color == NOCOLOR && bot_next_color < NOCOLOR && bot_next_color >= 0)
	{
		char tmps[256];

		strcpy (tmps, thebot->info);
		strcat (tmps, colors[bot_next_color]);
		Net_WriteString(tmps);
	}
	else
	{
		Net_WriteString(thebot->info);
	}

	// [NightFang] - spawn the bot manually
	if (!bglobal.DoAddBot(bnum, thebot->info))
		return false;

	thebot->inuse = true;
	players[bnum].skill = thebot->skill;
	memcpy(players[bnum].chat_probability,thebot->chat_probability,sizeof(thebot->chat_probability));

	//Increment this.
	if (++botnum==1)
	{
		unsigned long	t0,t1,time_now;
		player_t		*p;

		time_now = time(NULL);
		for (int i=top_client; i>=0; i--)
		{
			if (!ZD_ValidClient(i)) continue;
			p = players + i;
			if (p->spectator) continue;
			if ( (t0=p->join_time) != 0 )
			{
				if ( (t1=time_now) > t0 )
				{
					t1 -= t0;
					p->past_time += t1;
				}
				p->join_time = 0;
			}
		}
	}
	Bot_Chatter_At_Entry(bnum);
	return true;
}

bool DCajunMaster::DoAddBot (int bnum, char *info)
{
	player_clear(players+bnum);

	D_ReadUserInfoStrings (bnum, (byte **)&info, false);
	if (!deathmatch && playerstarts[bnum].type == 0)
	{
		Printf ("%s tried to join, but there was no player %d start\n",
			players[bnum].userinfo.netname, bnum+1);
		return false;
	}
	else
	{
		player_t *p;

		p = players+bnum;
		multiplayer = true; //Prevents cheating and so on; emulates real netgame (almost).
		p->isbot = true;
		playeringame[bnum] = true;
		//players[bnum].mo = NULL;
		p->playerstate = PST_ENTER;
		// Keep track of highest used index in the player/client arrays
		notify_add_client(bnum);

		CleanBotstuff(p);

		// [NightFang] - set the play timer
		p->timeplay = 0;
		
		const char *bname = p->userinfo.netname;
		if (teamplay)
		{
			int i,t, minv, count[NUM_TEAMS];	//Kilgore: determine least populous team to join

			memset(count,0,sizeof(count));
			for (i=top_client; i>=0; i--)
			{
				if (i==bnum) continue;
				if (!playeringame[i]) continue;
				t = players[i].userinfo.team;
				if (t<0 || t>=NUM_TEAMS) continue;
				count[t]++;
			}
			t = -1;
			minv = 10000;
			for (i=maxteams-1;  i>=0;  i--)
			{
				if (count[i]<=minv)
				{
					minv = count[i];
					t = i;
				}
			}
			if (t<0)	t = 0;
			p->userinfo.team = t;
			AssignTeamColor(&p->userinfo);
			ZD_Printf("%s joined the game on the %s team.\n", bname,GetTeamName(p->userinfo.team));
			connlog_printf("%s (bot) joined the game on the %s team.", bname,GetTeamName(p->userinfo.team));
		}
		else
		{
			ZD_Printf ("%s joined the game\n",  bname);
			connlog_printf("%s (bot) joined the game.",  bname);
		}

		G_DoReborn (bnum, true);

		// [NightFang] - update server list
		GUI_AddPlayer(bnum);


		// [NightFang] - update userinfo to all clients
		ZD_UpdateUserinfo(bnum,false);

		update_lead_states_on_enter(players+bnum);	//Kilgore
		return true;
	}
}

void DCajunMaster::RemoveAllBots (bool fromlist)
{
	for (int i=top_client; i>=0; i--)
	{
		if (playeringame[i] && players[i].isbot)
			ClearBot(i);
	}
	if (fromlist)	wanted_botnum = 0;
}

void DCajunMaster::RemoveBottomBot()
{
	int i, tgt, bottom_frags;

	bottom_frags = 100000000;
	tgt = -1;
	for (i=top_client;  i>=0;  i--)
	{
		if (playeringame[i] && players[i].isbot && players[i].fragcount<bottom_frags)
		{
			bottom_frags = players[i].fragcount;
			tgt = i;
		}
	}
	if (tgt>=0)
		ClearBot(tgt);
}

//Kilgore: spawn / remove bots as necessary when minplayers is set
void DCajunMaster::min_player_control(void)
{
	int nmin, nhumans, nbots, nbots_desired, i;

	nmin = minplayers;
	if (nmin<=1) return;

	nhumans = nbots = 0;
	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i]) continue;
		if (players[i].isbot)				nbots++;
		else if (!players[i].spectator)		nhumans++;
	}
	nbots_desired =	(nhumans==0) ? 0  : 
					(nhumans>1 && removebotswhenhumans!=0) ? 0 :
					(nhumans < nmin) ? nmin - nhumans :
					0;
	if (nbots>nbots_desired)
	{
		for (i=nbots - nbots_desired;  i>0;  i--)
			RemoveBottomBot();
		nbots = nbots_desired;
	}
	wanted_botnum = nbots_desired;
	// Reset bot spawn timer only if countdown is NOT active
	if (nbots >= wanted_botnum)
		bot_spawn_timer = 0;
}

//Clean the bot part of the player_t
//Used when bots are respawned or at level starts.
void DCajunMaster::CleanBotstuff (player_t *p)
{
	p->angle = ANG45;
	p->dest = NULL;
	p->enemy = NULL; //The dead meat.
	p->missile = NULL; //A threatening missile that needs to be avoided.
	p->mate = NULL;    //Friend (used for grouping in templay or coop.
	p->last_mate = NULL; //If bot's mate dissapeared (not if died) that mate is pointed to by this. Allows bot to roam to it if necessary.
	//Tickers
	p->t_active = 0; //Open door, lower lift stuff, door must open and lift must go down before bot does anything radical like try a stuckmove
	p->t_respawn = 0;
	p->t_strafe = 0;
	p->t_react = 0;
	//Misc bools
	p->first_shot = true; //Used for reaction skill.
	p->sleft = false; //If false, strafe is right.
	p->allround = false;
}

//------------------
//Reads data for bot from
//a .bot file.
//The skills and other data should
//be arranged as follows in the bot file:
//
//{
// Name			bot's name
// Aiming		0-100
// Perfection	0-100
// Reaction		0-100
// Isp			0-100 (Instincts of Self Preservation)
// ???			any other valid userinfo strings can go here
//}

static void appendinfo (char *&front, const char *back)
{
	char *newstr;

	if (front)
	{
		newstr = new char[strlen (front) + strlen (back) + 2];
		strcpy (newstr, front);
		delete[] front;
	}
	else
	{
		newstr = new char[strlen (back) + 2];
	}
	strcat (newstr, "\\");
	strcat (newstr, back);
	front = newstr;
}

void DCajunMaster::ForgetBots ()
{
	botinfo_t *thebot = botinfo;

	while (thebot)
	{
		botinfo_t *next = thebot->next;
		delete[] thebot->name;
		delete[] thebot->info;
		delete thebot;
		thebot = next;
	}

	botinfo = NULL;
	loaded_bots = 0;
}

static bool atoint(char **s,int *rv)
{
	char	*p;
	int		v;
	bool	is_neg;

	p = *s;
	while (*p==' ') p++;
	if (*p=='-')
	{
		is_neg = true;
		p++;
	}
	else
	{
		is_neg = false;
	}
	if (*p<'0' || *p>'9') return false;
	v = 0;
	do
	{
		v = 10*v  + (int)(*p - '0');
		p++;
	}
	while (*p>='0' && *p<='9');
	while (*p==' ' || *p=='t')
		p++;
	*s = p;
	*rv = (is_neg) ? -v : v;
	return true;
}

bool DCajunMaster::LoadBots ()
{
	int			i, new_prob[CHAT_EVENT_COUNT], def_prob[CHAT_EVENT_COUNT];
	char		*pprob;
	botinfo_t	*newinfo;
	botskill_t	def_skill;
	bool		in_header;
	static int	original_default_prob[CHAT_EVENT_COUNT] =
	{	90,		//Entry
		100,	//End - Top
		90,		//End - Middle
		90,		//End - Bottom
		25,		//Frag
		25,		//Suicide
		35		//BFG Death
	};

	memcpy(def_prob,original_default_prob,sizeof(def_prob));
	memset(&def_skill,0,sizeof(def_skill));
	def_skill.esp = 100;

	bglobal.ForgetBots ();

#ifndef unix
	if (!FileExists ("zcajun/" BOTFILENAME))
	{
		Printf ("No " BOTFILENAME ", so no bots\n");
		return false;
	}
	else
		SC_OpenFile ("zcajun/" BOTFILENAME);
#else
	char *tmp = GetUserFile (BOTFILENAME);
	if (!FileExists (tmp))
	{
		if (!FileExists ("zcajun/" BOTFILENAME))
		{
			Printf ("No " BOTFILENAME ", so no bots\n");
			return false;
		}
		else
			SC_OpenFile ("zcajun/" BOTFILENAME);
	}
	else
	{
		SC_OpenFile (tmp);
	}
	if (tmp)
	{
		delete[] tmp;
	}
#endif

	in_header = true;
	while (SC_GetString ())
	{
		if (in_header)
		{
			switch (SC_MatchString (BotConfigStrings))
			{
				case BOTCFG_AIMING:
					SC_MustGetNumber ();
					def_skill.aiming = sc_Number;
					continue;
				case BOTCFG_PERFECTION:
					SC_MustGetNumber ();
					def_skill.perfection = sc_Number;
					continue;
				case BOTCFG_REACTION:
					SC_MustGetNumber ();
					def_skill.reaction = sc_Number;
					continue;
				case BOTCFG_ISP:
					SC_MustGetNumber ();
					def_skill.isp = sc_Number;
					continue;
				case BOTCFG_ESP:
					SC_MustGetNumber ();
					def_skill.esp = sc_Number;
					continue;
				case BOTCFG_CHATPROB:
					SC_MustGetString ();
					for (i=0; i<CHAT_EVENT_COUNT; i++)
						new_prob[i] = -1;
					pprob = sc_String;
					for (i=0; i<CHAT_EVENT_COUNT; i++)
					{
						if (!atoint(&pprob,new_prob+i))
							break;
					}
					for (i=0; i<CHAT_EVENT_COUNT; i++)
					{
						if (new_prob[i]>=0 && new_prob[i]<=100)
							def_prob[i] = new_prob[i];
					}
					continue;
			}
			in_header = false;
		}

		if (!SC_Compare ("{"))
		{
			SC_ScriptError ("Unexpected token '%s'\n", (const char **)&sc_String);
		}

		newinfo = new botinfo_t;
		memset (newinfo, 0, sizeof(*newinfo));
		memcpy(newinfo->chat_probability,def_prob,sizeof(def_prob));
		memcpy(&newinfo->skill,&def_skill,sizeof(def_skill));
		newinfo->info = copystring ("\\autoaim\\0");

		for (;;)
		{
			SC_MustGetString ();

			if (SC_Compare ("}"))
				break;

			switch (SC_MatchString (BotConfigStrings))
			{
			case BOTCFG_NAME:
				SC_MustGetString ();
				appendinfo (newinfo->info, "name");
				appendinfo (newinfo->info, sc_String);
				newinfo->name = copystring (sc_String);
				break;

			case BOTCFG_AIMING:
				SC_MustGetNumber ();
				newinfo->skill.aiming = sc_Number;
				break;

			case BOTCFG_PERFECTION:
				SC_MustGetNumber ();
				newinfo->skill.perfection = sc_Number;
				break;

			case BOTCFG_REACTION:
				SC_MustGetNumber ();
				newinfo->skill.reaction = sc_Number;
				break;

			case BOTCFG_ISP:
				SC_MustGetNumber ();
				newinfo->skill.isp = sc_Number;
				break;

			case BOTCFG_ESP:
				SC_MustGetNumber ();
				newinfo->skill.esp = sc_Number;
				break;

			case BOTCFG_CHATPROB:
				SC_MustGetString ();
				for (i=0; i<CHAT_EVENT_COUNT; i++)
					new_prob[i] = -1;
				pprob = sc_String;
				for (i=0; i<CHAT_EVENT_COUNT; i++)
				{
					if (!atoint(&pprob,new_prob+i))
						break;
				}
				for (i=0; i<CHAT_EVENT_COUNT; i++)
				{
					if (new_prob[i]>=0 && new_prob[i]<=100)
						newinfo->chat_probability[i] = new_prob[i];
				}
				break;

			default:
				appendinfo (newinfo->info, sc_String);
				SC_MustGetString ();
				appendinfo (newinfo->info, sc_String);
				break;
			}
		}
		newinfo->next = bglobal.botinfo;
		bglobal.botinfo = newinfo;
		bglobal.loaded_bots++;
	}
	SC_Close ();

	Printf("%d bots read from %s\n", bglobal.loaded_bots, BOTFILENAME);

	return true;
}

ADD_STAT (bots, out)
{
	sprintf (out, "think = %04.1f ms  support = %04.1f ms",
		(double)BotThinkCycles * 1000 * SecondsPerCycle,
		(double)BotSupportCycles * 1000 * SecondsPerCycle);
}

////////////////////////////////////////////////////////////////

void DCajunMaster::Clear_Bot_Chat(int bnum)
{
	botchatstr_t	*p, *next, *last;

	last = NULL;
	for (p=botchat_head;  p;   )
	{
		if (p->bnum==bnum)
		{
			next = p->next;
			if (last)	last->next = next;
			else		botchat_head = next;
			free(p);
			p = next;
		}
		else
		{
			last = p;
			p = p->next;
		}
	}
}

////////////////////////////////////////////////////////////////

void DCajunMaster::Add_Bot_Chat(int bnum, const char *s, int ndelay)
{
	botchatstr_t	*p;

	if ( (p=(botchatstr_t *)malloc(sizeof(botchatstr_t)+strlen(s))) == NULL )
		return;
	p->next = botchat_head;
	p->bnum = bnum;
	p->time_counter = ndelay;
	strcpy(p->s,s);
	botchat_head = p;
}

////////////////////////////////////////////////////////////////

void DCajunMaster::Process_Bot_Chat()
{
	botchatstr_t	*p, *next, *last;

	last = NULL;
	for (p=botchat_head;  p;   )
	{
		if (--(p->time_counter) <= 0)
		{
			ZD_ChatSend(0,p->s,p->bnum,-1);
			next = p->next;
			if (last)	last->next = next;
			else		botchat_head = next;
			free(p);
			p = next;
		}
		else
		{
			last = p;
			p = p->next;
		}
	}
}

////////////////////////////////////////////////////////////////

static int bounded_random(int minsecs, int maxsecs)
{
	int interval;

	interval = (maxsecs - minsecs)*TICRATE;
	return minsecs*TICRATE + (rand() % interval);
}

////////////////////////////////////////////////////////////////

static int
player_id_by_score(int v, int self_id)
{
	int			i;
	player_t	*p;

	if (gamestate == GS_INTERMISSION)
		for (i=top_client; i>=0; i--)
		{
			if (i==self_id) continue;
			if (!wminfo.plyr[i].in) continue;
			if (wminfo.plyr[i].spectator) continue;
			if (wminfo.plyr[i].fragcount==v)
				return i;
		}
	else
		for (i=top_client; i>=0; i--)
		{
			if (i==self_id) continue;
			if (!playeringame[i]) continue;
			p = players + i;
			if (p->spectator) continue;
			if (p->fragcount==v)
				return i;
		}

	return -1;
}

////////////////////////////////////////////////////////////////

static const char *
strip_clan_tags(const char *s0)
{
	const char	*s;
	char		*pout, *pstart, c;
	static char	buf[256];

	s = s0;
	pout = buf;
	while ( (c = *s++) != '\0')
	{
		if (c!='{' && c!='[' && c!='(' && c!='%' && c!='<')
		{
			*pout++ = c;
		}
		else
		{
			if (pout>buf && pout[-1]==' ')
				pout--;
			if		(c=='{')	c = '}';
			else if	(c=='[')	c = ']';
			else if	(c=='(')	c = ')';
			else if (c=='%')	c = '%';
			else c = '>';
			while (*s!=c)
			{
				if (*s == '\0')		//Hopeless: just return the full name
				{
					strcpy(buf,s0);
					return buf;
				}
				s++;
			}
			s++;
			while (*s==' ') s++;
		}
	}
	// Trim trailing blanks
	while (pout>buf && pout[-1]==' ')
		pout--;
	*pout = '\0';
	// Trim leading blanks
	pstart = buf;
	while (*pstart==' ') pstart++;
	// If empty, just return the full name
	if (*pstart=='\0')
		strcpy(pstart = buf,s0);
	return pstart;
}

////////////////////////////////////////////////////////////////

static const char *get_short_netname(int id)
{
	player_t	*p;
	char		*p1, *p2, *pout;
	int			nwords, n1, n2;
	char		temp[256];

	if (id<0 || id>top_client) return "***";
	p = players + id;
	pout = p->userinfo.short_netname;
	if (*pout) return pout;

	strcpy(temp,strip_clan_tags(p->userinfo.netname));
	p1 = temp;
	while (*p1==' ') p1++;
	nwords = (*p1) ? 1 : 0;
	for (;;)
	{
		if ( (p2=strchr(p1,' ')) == NULL ) break;
		nwords++;
		while (*p2==' ') p2++;
		p1 = p2;
	}
	switch (nwords)
	{
		case 0:
		case 1:
			strcpy(pout,temp);
			break;

		case 2:
			p1 = temp;
			p2 = strchr(p1,' ');
			*p2++ = '\0';
			n1 = strlen(p1);
			n2 = strlen(p2);
			strcpy(pout, (n1>n2) ? p1 : p2);
			break;

		default:
			p1 = temp;
			while (*p1==' ') p1++;
			for (;;)
			{
				*pout++ = *p1;
				if ( (p2=strchr(p1,' ')) == NULL ) break;
				while (*p2==' ') p2++;
				p1 = p2;
			}
			*pout = '\0';
	}
	return p->userinfo.short_netname;
}

// %b -> bottom
// %t -> top
// %s -> self
// %o -> other player (frag victim)
static const char *
translate_bot_chat(const char *s, int minv, int maxv,
				   int self_id, int other_id)
{
	char		*pout, c;
	const char	*name;
	static char	buf[1024];

	pout = buf;
	while ( (c = *s++) != '\0')
	{
		if (c != '%')
		{
			*pout++ = c;
			continue;
		}
		c = *s++;
		if (c == '\0')
			break;
		else if (c == 't')
		{
			name = get_short_netname(player_id_by_score(maxv, self_id));
			strcpy(pout,name);
			pout += strlen(name);
		}
		else if (c == 'b')
		{
			name = get_short_netname(player_id_by_score(minv, self_id));
			strcpy(pout,name);
			pout += strlen(name);
		}
		else if (c == 's')
		{
			name = get_short_netname(self_id);
			strcpy(pout,name);
			pout += strlen(name);
		}
		else if (c == 'o')
		{
			name = get_short_netname(other_id);
			strcpy(pout,name);
			pout += strlen(name);
		}
		else
		{
			*pout++ = c;
		}
	}
	*pout = '\0';
	return buf;
}

////////////////////////////////////////////////////////////////

static const char *bc_msg(const char *msgs[], int nmsgs, int prob_talk,
						  int minv, int maxv, int self_id, int other_id)
{
	if (prob_talk<=0 || nmsgs<=0) return NULL;
	if (prob_talk>100) prob_talk = 100;
	if ( prob_talk<100 &&  (rand() % 100)>=prob_talk )
		return NULL;
	return translate_bot_chat(msgs[rand() % nmsgs],minv,maxv,self_id,other_id);
}

////////////////////////////////////////////////////////////////
#include "b_strings.h"
////////////////////////////////////////////////////////////////

static int count_msgs(const char *msgs[])
{
	int i;

	for (i=0; msgs[i];  i++)
		;
	return i;
}

////////////////////////////////////////////////////////////////

static const char *bc_entry_msg(int minv, int maxv, int self_id, int prob_talk)
{
	static int	nmsgs = 0;

	if (nmsgs==0)	nmsgs = count_msgs(bc_entry_msg_list);
	return bc_msg(bc_entry_msg_list, nmsgs, prob_talk, minv, maxv, self_id, -1);
}

////////////////////////////////////////////////////////////////

static const char *bc_end_top_msg(int minv,int maxv,int self_id, int prob_talk)
{
	static int	nmsgs = 0;

	if (nmsgs==0)	nmsgs = count_msgs(bc_end_top_msg_list);
	return bc_msg(bc_end_top_msg_list, nmsgs, prob_talk, minv, maxv, self_id, -1);
}

////////////////////////////////////////////////////////////////

static const char *bc_end_middle_msg(int minv, int maxv, int self_id, int prob_talk)
{
	static int	nmsgs = 0;

	if (nmsgs==0)	nmsgs = count_msgs(bc_end_middle_msg_list);
	return bc_msg(bc_end_middle_msg_list, nmsgs, prob_talk, minv, maxv, self_id, -1);
}

////////////////////////////////////////////////////////////////

static const char *bc_end_bottom_msg(int minv, int maxv, int self_id, int prob_talk)
{
	static int	nmsgs = 0;

	if (nmsgs==0)	nmsgs = count_msgs(bc_end_bottom_msg_list);
	return bc_msg(bc_end_bottom_msg_list, nmsgs, prob_talk, minv, maxv, self_id, -1);
}

////////////////////////////////////////////////////////////////

static const char *bc_frag_msg(int self_id, int victim_id, int prob_talk)
{
	static int	nmsgs = 0;

	if (nmsgs==0)	nmsgs = count_msgs(bc_frag_msg_list);
	return bc_msg(bc_frag_msg_list, nmsgs, prob_talk, -1000, 1000, self_id, victim_id);
}

////////////////////////////////////////////////////////////////

static const char *bc_suicide_msg(int self_id, int prob_talk)
{
	static int	nmsgs = 0;

	if (nmsgs==0)	nmsgs = count_msgs(bc_suicide_msg_list);
	return bc_msg(bc_suicide_msg_list, nmsgs, prob_talk, -1000, 1000, self_id, -1);
}

////////////////////////////////////////////////////////////////

static const char *bc_bfg_death_msg(int self_id, int killer_id, int prob_talk)
{
	static int	nmsgs = 0;

	if (nmsgs==0)	nmsgs = count_msgs(bc_bfg_death_msg_list);
	return bc_msg(bc_bfg_death_msg_list, nmsgs, prob_talk, -1000, 1000, self_id, killer_id);
}

////////////////////////////////////////////////////////////////

void DCajunMaster::Bot_Chatter_At_End(void)
{
	int			i, minv, maxv, v, nplayers;
	const char	*s;
	player_t	*p;

	if (botnum<=0) return;

	minv = 100000;
	maxv = -minv;
	nplayers = 0;
	for (i=top_client; i>=0; i--)
	{
		if (!wminfo.plyr[i].in) continue;
		if (wminfo.plyr[i].spectator) continue;
		v = wminfo.plyr[i].fragcount;
		if (v>maxv) maxv = v;
		if (v<minv) minv = v;
		nplayers++;
	}

	if (nplayers<2) return;

	for (i=top_client;  i>=0;  i--)
	{
		if (!wminfo.plyr[i].in)	continue;
		p = players + i;
		if (!p->isbot) continue;
		v = wminfo.plyr[i].fragcount;
		s = (maxv==minv) ?	bc_end_middle_msg(minv,maxv,i,p->chat_probability[CHAT_EVENT_MIDDLE]) :
			(v==minv)	 ?	bc_end_bottom_msg(minv,maxv,i,p->chat_probability[CHAT_EVENT_BOTTOM]) :
			(v==maxv)	 ?	bc_end_top_msg(minv,maxv,i,p->chat_probability[CHAT_EVENT_END_TOP]) :
							bc_end_middle_msg(minv,maxv,i,p->chat_probability[CHAT_EVENT_MIDDLE]);
		if (s)
			Add_Bot_Chat(i, s, bounded_random(1,7));
	}
}

////////////////////////////////////////////////////////////////

void DCajunMaster::Bot_Chatter_At_Entry(int bnum)
{
	int			i, minv, maxv, v, nclients, nplayers;
	const char	*s;
	player_t	*p;

	minv = 100000;
	maxv = -minv;
	nclients = nplayers = 0;
	for (i=top_client; i>=0; i--)
	{
		if (i==bnum) continue;
		if (!playeringame[i]) continue;
		nclients++;
		p = players + i;
		if (p->spectator) continue;
		nplayers++;
		v = p->fragcount;
		if (v>maxv) maxv = v;
		if (v<minv) minv = v;
	}
	if (nclients==0) return;
	if (nplayers==0)	//Get a random spectator for the top / bottom names
		maxv = minv = 0;
	s = bc_entry_msg(minv,maxv,bnum,players[bnum].chat_probability[CHAT_EVENT_ENTRY]);
	if (s)
		Add_Bot_Chat(bnum, s, bounded_random(0,2));
}

////////////////////////////////////////////////////////////////

void DCajunMaster::Bot_Chatter_At_Frag(int bnum, int victim)
{
	const char *s;

	if (bnum==victim)
	{
		s = bc_suicide_msg(bnum,players[bnum].chat_probability[CHAT_EVENT_SUICIDE]);
	}
	else
	{
		if (players[bnum].fragcount<players[victim].fragcount) return;
		s = bc_frag_msg(bnum,victim,players[bnum].chat_probability[CHAT_EVENT_FRAG]);
	}
	if (s)
		Add_Bot_Chat(bnum, s, bounded_random(1,2));
}

////////////////////////////////////////////////////////////////

void DCajunMaster::Bot_Chatter_At_BFG_Death(int bnum, int killer)
{
	const char *s;

	if (bnum==killer) return;
	if (players[bnum].fragcount>players[killer].fragcount)
		return;
	s = bc_bfg_death_msg(bnum,killer,players[bnum].chat_probability[CHAT_EVENT_BFG_DEATH]);
	if (s)
		Add_Bot_Chat(bnum, s, bounded_random(1,2));
}

////////////////////////////////////////////////////////////////
