/********************************
* B_Think.c                     *
* Description:                  *
* Functions for the different   *
* states that the bot           *
* uses. These functions are     *
* the main AI                   *
*                               *
*********************************/

#include "doomdef.h"
#include "doomstat.h"
#include "p_local.h"
#include "p_inter.h"
#include "b_bot.h"
#include "g_game.h"
#include "m_random.h"
#include "r_main.h"
#include "stats.h"

// [NightFang] - client/server stuff
#include "sv_main.h"

#include "c_dispatch.h"
static int show_bot_thoughts[MAXPLAYERS];

//This function is called each tic for each bot,
//so this is what the bot does.
void DCajunMaster::Think (AActor *actor, ticcmd_t *cmd)
{
	memset (cmd, 0, sizeof(*cmd));

	if (actor->player->enemy && actor->player->enemy->health <= 0)
		actor->player->enemy = NULL;

	if (actor->health > 0) //Still alive
	{
		// Kilgore: this looks wrong and leads to wrong bot behavior.
		// Maybe teamplay means coop in ZDoom. In ZDaemon it means
		// a deathmatch-type mode (eg., Team DM or CTF), so the bot
		// should not follow anyone (unless we make them more sophi-
		// sticated in the future).
		if (/*teamplay ||*/ !deathmatch)				
			actor->player->mate = Choose_Mate (actor);	

		angle_t oldyaw = actor->angle;
		int oldpitch = actor->pitch;

int botid = actor->player->netid;
if (show_bot_thoughts[botid])
{
	const char *selfname = actor->player->userinfo.netname;
	const char *opponentname, *destname;

	Set_enemy (actor);
	opponentname = (actor->player->enemy) ? actor->player->enemy->player->userinfo.netname : "NONE";
	destname = (actor->player->dest) ? actor->player->dest->StaticType()->Name : "NONE" ;
	Printf("%s: After Set_Enemy: enemy=<%s>   dest=<%s>\n",selfname,opponentname,destname);

	ThinkForMove (actor, cmd);

	opponentname = (actor->player->enemy) ? actor->player->enemy->player->userinfo.netname : "NONE";
	destname = (actor->player->dest) ? actor->player->dest->StaticType()->Name : "NONE" ;
	Printf("%s: After ThinkForMove: enemy=<%s>   dest=<%s>\n",selfname,opponentname,destname);

	show_bot_thoughts[botid] = 0;
}
else
{
		Set_enemy (actor);
		ThinkForMove (actor, cmd);
}

		TurnToAng (actor);

		cmd->ucmd.yaw = (short)((actor->angle - oldyaw) >> 16) / ticdup;
		cmd->ucmd.pitch = (short)((oldpitch - actor->pitch) >> 16);
		if (cmd->ucmd.pitch == -37268)
			cmd->ucmd.pitch = -32767;
		cmd->ucmd.pitch /= ticdup;
		actor->angle = oldyaw + (cmd->ucmd.yaw << 16) * ticdup;
		actor->pitch = oldpitch - (cmd->ucmd.pitch << 16) * ticdup;
	}

	if (actor->player->t_active)	actor->player->t_active--;
	if (actor->player->t_strafe)	actor->player->t_strafe--;
	if (actor->player->t_react)		actor->player->t_react--;
	if (actor->player->t_fight)		actor->player->t_fight--;
	if (actor->player->t_rocket)	actor->player->t_rocket--;
	if (actor->player->t_roam)		actor->player->t_roam--;

	//Respawn ticker
	if (actor->player->t_respawn)
	{
		actor->player->t_respawn--;
	}
	else if (actor->health <= 0)
	{ // Time to respawn
		cmd->ucmd.buttons |= BT_USE;
	}
}

//how the bot moves.
//MAIN movement function.
void DCajunMaster::ThinkForMove (AActor *actor, ticcmd_t *cmd)
{
	player_t *b;
	fixed_t dist;
	bool stuck;
	int r;

	b = actor->player;
	if (!b->isbot)
		return;

	// [NightFang] - we gotta have at least 2 players before any
	// thinking can be done.
	if (ZD_ClientCount()<2)
		return;

	stuck = false;
	dist = b->dest ? P_AproxDistance(actor->x-b->dest->x, actor->y-b->dest->y) : 0;

	if (b->missile &&
		((!b->missile->momx || !b->missile->momy) || !Check_LOS(actor, b->missile, SHOOTFOV*3/2)))
	{
		b->sleft = !b->sleft;
		b->missile = NULL; //Probably ended its travel.
	}

	if (actor->pitch > 0)
		actor->pitch -= 80;
	else if (actor->pitch <= -60)
		actor->pitch += 80;

	//HOW TO MOVE:
	if (b->missile && (P_AproxDistance(actor->x-b->missile->x, actor->y-b->missile->y)<AVOID_DIST)) //try avoid missile got from P_Mobj.c thinking part.
	{
		Pitch (actor, b->missile);
		actor->player->angle = R_PointToAngle2(actor->x, actor->y, b->missile->x, b->missile->y);
		cmd->ucmd.sidemove = b->sleft ? -SIDERUN : SIDERUN;
		cmd->ucmd.forwardmove = -FORWARDRUN; //Back IS best.

		if ((P_AproxDistance(actor->x-b->oldx, actor->y-b->oldy)<50000)
			&& b->t_strafe<=0)
		{
			b->t_strafe = 5;
			b->sleft = !b->sleft;
		}

		//If able to see enemy while avoiding missile, still fire at enemy.
		if (b->enemy && Check_LOS (actor, b->enemy, SHOOTFOV)) 
			Dofire (actor, cmd); //Order bot to fire current weapon
	}
	else if (b->enemy && P_CheckSight (actor, b->enemy, false)) //Fight!
	{
		Pitch (actor, b->enemy);

		//Check if it's more important to get an item than fight.
		if (b->dest && (b->dest->flags&MF_SPECIAL)) //Must be an item, that is close enough.
		{
#define is(x) b->dest->IsKindOf (TypeInfo::FindType (#x))
			if (
				(
				 (actor->health < b->skill.isp &&
				  (is (AMedikit) ||
				   is (AStimpack) ||
				   is (ASoulsphere) ||
				   is (AMegasphere) ||
				   is (ACrystalVial)
				  )
				 ) || (
				  is (AInvulnerability) ||
				  is (AInvisibility) ||
				  is (AMegasphere)
				 ) || 
// Kilgore (HSDEBUG): this is not unreasonable, but it doesn't
// work right now, because the bot pathing is bad. Maybe we should
// activate it again once the pathing is fixed.
//				 dist < (GETINCOMBAT/4) ||
				 (b->readyweapon == wp_pistol || b->readyweapon == wp_fist ||
				  b->readyweapon == wp_goldwand || b->readyweapon == wp_staff)
				)
				&& (dist < GETINCOMBAT || (b->readyweapon == wp_pistol ||
					b->readyweapon == wp_fist || b->readyweapon == wp_staff ||
					b->readyweapon == wp_goldwand))
				&& Reachable (actor, b->dest))
#undef is
			{
				goto roam; //Pick it up, no matter the situation. All bonuses are nice close up.
			}
		}

		b->dest = NULL; //To let bot turn right

		if (b->readyweapon != wp_pistol && b->readyweapon != wp_fist &&
			b->readyweapon != wp_goldwand && b->readyweapon != wp_staff)
			actor->flags &= ~MF_DROPOFF; //Don't jump off any ledges when fighting.

		if (!(b->enemy->flags & MF_COUNTKILL))
			b->t_fight = AFTERTICS;

		if (b->t_strafe <= 0 &&
				( P_AproxDistance(actor->x-b->oldx, actor->y-b->oldy)<50000 ||
				 (P_Random(pr_botmove)%30)==10 ) )
		{
			stuck = true;
			b->t_strafe = 5;
			b->sleft = !b->sleft;
		}

		b->angle = R_PointToAngle2(actor->x, actor->y, b->enemy->x, b->enemy->y);

		if (P_AproxDistance(actor->x-b->enemy->x, actor->y-b->enemy->y) > bglobal.combatdst[b->readyweapon])
		{
			// If a monster, use lower speed (just for cooler apperance while strafing down doomed monster)
			cmd->ucmd.forwardmove = (b->enemy->flags & MF_COUNTKILL) ? FORWARDWALK : FORWARDRUN;
		}
		else if (!stuck) //Too close, so move away.
		{
			// If a monster, use lower speed (just for cooler apperance while strafing down doomed monster)
			cmd->ucmd.forwardmove = (b->enemy->flags & MF_COUNTKILL) ? -FORWARDWALK : -FORWARDRUN;
		}

		//Strafing.
		if (b->enemy->flags & MF_COUNTKILL) //It's just a monster so take it down cool.
		{
			cmd->ucmd.sidemove = b->sleft ? -SIDEWALK : SIDEWALK;
		}
		else
		{
			cmd->ucmd.sidemove = b->sleft ? -SIDERUN : SIDERUN;
		}
		Dofire (actor, cmd); //Order bot to fire current weapon
	}
	else if (b->mate && !b->enemy && (!b->dest || b->dest==b->mate)) //Follow mate move.
	{
		fixed_t matedist;

		Pitch (actor, b->mate);

		if (!Reachable(actor, b->mate))
		{
			if (b->mate == b->dest && P_Random(pr_botmove) < 32)
			{ // [RH] If the mate is the dest, pick a new dest sometimes
				b->dest = NULL;
			}
			goto roam;
		}

		actor->player->angle = R_PointToAngle2(actor->x, actor->y, b->mate->x, b->mate->y);

		matedist = P_AproxDistance(actor->x - b->mate->x, actor->y - b->mate->y);
		if (matedist > (FRIEND_DIST*2))
			cmd->ucmd.forwardmove = FORWARDRUN;
		else if (matedist > FRIEND_DIST)
			cmd->ucmd.forwardmove = FORWARDWALK; //Walk, when starting to get close.
		else if (matedist < FRIEND_DIST-(FRIEND_DIST/3)) //Got too close, so move away.
			cmd->ucmd.forwardmove = -FORWARDWALK;
	}
	else //Roam after something.
	{
		b->first_shot = true;

	/////
	roam:
	/////
		if (b->enemy && Check_LOS (actor, b->enemy, SHOOTFOV*3/2)) //If able to see enemy while avoiding missile , still fire at it.
			Dofire (actor, cmd); //Order bot to fire current weapon

		if (b->dest && !(b->dest->flags&MF_SPECIAL) && b->dest->health < 0)
			b->dest = NULL; //Roaming after something dead.

		if (!b->dest)
		{
			if (b->t_fight && b->enemy) //Enemy/bot has jumped around corner. So what to do?
			{
				if (b->enemy->player)
				{
					if ((b->enemy->player->readyweapon==wp_missile || (P_Random(pr_botmove)%100)>b->skill.isp) && !(b->readyweapon==wp_pistol || b->readyweapon==wp_fist))
						b->dest = b->enemy;//Dont let enemy kill the bot by supressive fire. So charge enemy.
					else //hide while b->t_fight, but keep view at enemy.
						b->angle = R_PointToAngle2(actor->x, actor->y, b->enemy->x, b->enemy->y);
				} //Just a monster, so kill it.
				else
					b->dest = b->enemy;

				//VerifFavoritWeapon(actor->player); //Dont know why here.., but it must be here, i know the reason, but not why at this spot, uh.
			}
			else //Choose a distant target. to get things going.
			{
				r = P_Random(pr_botmove);
				if ((r%100)<50 && bglobal.thingnum)
					b->dest = bglobal.things[(r%(bglobal.thingnum-1))];
				else if (b->mate && (P_CheckSight(actor, b->mate) || (r%100)<70))
					b->dest = b->mate;
				// [NightFang] - appended
				// Kilgore: fixed
				else
				{
					player_t *pl;

					r = r % (top_client+1);
					pl = players + r;
					if (playeringame[r] && pl->mo && pl->mo->health>0 &&
						!pl->spectator &&  b!=pl &&  !actor->IsTeammate(pl->mo) )
						b->dest = pl->mo;
				}
			}
			if (b->dest)
				b->t_roam = MAXROAM;
		}
		if (b->dest) //Bot has a target so roam after it.
			Roam (actor, cmd);

	} //End of movement main part.

	if (!b->t_roam && b->dest)
	{
		b->prev = b->dest;
		b->dest = NULL;
	}

	if (b->t_fight<(AFTERTICS/2))
		actor->flags |= MF_DROPOFF;

	b->oldx = actor->x;
	b->oldy = actor->y;
}

//BOT_WhatToGet
//
//Determines if the bot will roam after an item or not.
void DCajunMaster::WhatToGet (AActor *actor, AActor *item)
{
	if (!actor) return;
	player_t *b = actor->player;

	if (b == NULL)
	{
		return;
	}

#define typeis(x) item->IsKindOf (TypeInfo::FindType (#x))

	//Kilgore: Need to improve item targeting (HSDEBUG)
	if (!item || (item->renderflags & RF_INVISIBLE) //Under respawn and away.
		|| item == b->prev)
	{
		return;
	}
	int weapgiveammo = (alwaysapplydmflags || deathmatch) && !(dmflags & DF_WEAPONS_STAY);

	//if(pos && !bglobal.thingvis[pos->id][item->id]) continue;
	if (item->IsKindOf(ZDRUNTIME_CLASS(AArtifact)))
		return;	// don't know how to use artifacts
	if (item->IsKindOf(ZDRUNTIME_CLASS(AWeapon)))
	{
		AWeapon *weapon = static_cast<AWeapon *> (item);
		weapontype_t weaptype = weapon->OldStyleID ();

		if (weaptype >= NUMWEAPONS)
		{ // bad weapon
			return;
		}

		ammotype_t ammotype = wpnlev1info[weaptype]->ammo;

		if (b->weaponowned[weaptype])
		{
			if (!weapgiveammo)
				return;
			if (ammotype >= NUMAMMO)
				return;
			if (b->ammo[ammotype] >= b->maxammo[ammotype])
				return;
		}
	}
	else if (item->IsKindOf(ZDRUNTIME_CLASS(AAmmo)))
	{
		AAmmo *ammo = static_cast<AAmmo *> (item);
		ammotype_t ammotype = ammo->GetAmmoType ();

		if (ammotype < NUMAMMO)
		{
			if (b->ammo[ammotype] >= b->maxammo[ammotype])
				return;
		}
		else if (ammotype == MANA_BOTH)
		{
			if (b->ammo[MANA_1] >= b->maxammo[MANA_1] && b->ammo[MANA_2] >= b->maxammo[MANA_2])
				return;
		}
	}
	else if ((typeis (Megasphere) || typeis (Soulsphere) || typeis (HealthBonus)) && actor->health >= deh.MaxSoulsphere)
		return;
	else if (item->IsKindOf (ZDRUNTIME_CLASS(AHealth)) && actor->health >= MAXHEALTH)
		return;

	if ((b->dest == NULL ||
		!(b->dest->flags & MF_SPECIAL) ||
		!Reachable (actor, b->dest)) &&
		Reachable (actor, item))
	{
		b->prev = b->dest;
		b->dest = item;
		b->t_roam = MAXROAM;
	}
}

void DCajunMaster::Set_enemy (AActor *actor)
{
	AActor *enemy, *newenemy;

	enemy = actor->player->enemy;

	// [RH] Don't even bother looking for a different enemy if this is not deathmatch
	// and we already have an existing enemy.
	if (deathmatch || !enemy)
	{
		actor->player->allround = !!enemy;
		// Kilgore: Find_enemy() returns the closest opponent no matter whether he's
		// reachable or not. The reachability requirement may not be necessary (eg.,
		// maybe the bot should shoot at someone who is unreachable, but within
		// weapon range), but it's probably a good idea to make a prioritization;
		// for example, maybe it makes more sense to go after the strongest (or
		// weakest) opponent if they are sufficiently close. (HSDEBUG)
		if ( (newenemy = Find_enemy(actor)) == NULL )
		{
			//Try go for last (it will be NULL if there wasn't anyone)
			// Kilgore (HSDEBUG): There is no point here calling P_CheckSight()
			// If it returned true, then Find_enemy() would have already
			// returned that player. Therefore, the statement below is
			// guaranteed to evaluate to NULL (so it doesn't do anything
			// really). I would suggest that we better try using the last
			// enemy (if alive), even if the bot cannot see him right now.
			//newenemy = (enemy && enemy->health>0 && P_CheckSight(actor,enemy)) ? enemy : NULL;
			newenemy = (enemy && enemy->health>0) ? enemy : NULL;
		}
		enemy = newenemy;
	}
	//Verify that that enemy is really something alive that bot can kill.
	if (enemy && (enemy->health < 0 || !(enemy->flags&MF_SHOOTABLE)))
		enemy = NULL;
	actor->player->enemy = enemy;
}


CCMD(botdebug)
{
	memset(show_bot_thoughts,1,sizeof(show_bot_thoughts));
}
