#if __CTF__
//======================================================
//====== Zdaemon Capture The Flag by Duke4Ever! ========
//======================================================

#include "vectors.h"
#include "actor.h"
#include "p_local.h"
#include "sv_main.h"
#include "doomtype.h"

void						ZD_ctfs(int num);
//void						ZD_ctfs_1(int i,int num);

EXTERN_CVAR(Int, teamscorelimit)

fixed_t						ctf_flagbasex[2];
fixed_t						ctf_flagbasey[2];
fixed_t						ctf_flagbasez[2];
AActor						*ctf_flags_mo[2];
int							ctf_flagstate[2];
int							ctf_carrier_id[2];

//static int					ctf_la[2];
//static int					ctf_lapn[2];
static int					in_base_counter[2];
static int					in_dropped_counter[2];
static int					ctf_lostcnt[2];
static fixed_t				ctf_flagdroppedx[2];
static fixed_t				ctf_flagdroppedy[2];
static fixed_t				ctf_flagdroppedz[2];
static const char			*tnames[2] = { "Red", "Blue" };

// Values for the ctf_flagstate variable
#define CTF_FS_INBASE		1
#define CTF_FS_TAKEN		2
#define CTF_FS_DROPPED		3

#define CTF_MAXLOST			(10*TICRATE)
#define CTF_MAXASSIST		(5*TICRATE)
#define CTF_MAXUPD			3

// Prepare ctf vars before the map starts
void CTF_Prepare(void)
{
	ctf_flagstate[0]		= ctf_flagstate[1]		= CTF_FS_INBASE;
	in_base_counter[0]		= in_base_counter[1]	= CTF_MAXUPD;
	in_dropped_counter[0]	= in_dropped_counter[1]	= CTF_MAXUPD;
	ctf_carrier_id[0]		= ctf_carrier_id[1]		= -1;
	memset(ctf_lostcnt,0,sizeof(ctf_lostcnt));
	memset(ctf_flagbasex,0,sizeof(ctf_flagbasex));
	memset(ctf_flagbasey,0,sizeof(ctf_flagbasey));
	memset(ctf_flagbasez,0,sizeof(ctf_flagbasez));
	memset(ctf_flags_mo,0,sizeof(ctf_flags_mo));
//	memset(ctf_la,0,sizeof(ctf_la));
//	memset(ctf_lapn,0,sizeof(ctf_lapn));
}

static void update_flag_pos(AActor *mobj)
{
	if (gamestate != GS_LEVEL) return;
	ZDOP.Init();
	ZDOP.WriteByte (sv_movething);
	ZDOP.WriteShort(mobj->netid);
	ZDOP.WriteByte (CM_X | CM_Y | CM_Z | CM_ANGLE);
	ZDOP.WriteShort(mobj->x >> FRACBITS);
	ZDOP.WriteShort(mobj->y >> FRACBITS);
	ZDOP.WriteShort(mobj->z >> FRACBITS);
	ZDOP.WriteLong (mobj->angle);
	for (int i=top_client;  i>=0;  i--)
	{ 
		if (!ZD_ValidClient(i) || clients[i].netstate!=ZD_PLAYING) continue;
		ZDOP.ToPlayer(i);	
	}
}

static void return_flag_to_base(int team,bool set_origin)
{
	AActor *flag;

	flag = ctf_flags_mo[team];
	if (!flag) { ZD_Printf("return_flag_to_base: NULL POINTER\n"); return; }
	if (set_origin)
		flag->SetOrigin(ctf_flagbasex[team],ctf_flagbasey[team],ctf_flagbasez[team]);
	update_flag_pos(flag);
}

static void set_dropped_flag(int team,bool set_origin)
{
	AActor *flag;

	flag = ctf_flags_mo[team];
	if (!flag) { ZD_Printf("set_dropped_flag: NULL POINTER\n"); return; }
	if (set_origin)
		flag->SetOrigin(ctf_flagdroppedx[team],ctf_flagdroppedy[team],ctf_flagdroppedz[team]);
	update_flag_pos(flag);
}

static int ctf_opponent(int t)
{
	return !t;
}

void CTF_FlagTouch(int flag_team, player_t *pl)
{
	int					player_team, opponent_team, player_id;
	char				*player_name;

	player_id			= (int)(pl-players);
	player_team			= pl->userinfo.team;
	opponent_team		= ctf_opponent(player_team);
	player_name			= pl->userinfo.netname;
	
	/***************************************************************************
	 * RETURNED BY A PLAYER
	 ***************************************************************************/
	if (player_team==flag_team && ctf_flagstate[flag_team]==CTF_FS_DROPPED)
	{
		/*********************************************************
		Kilgore: just use normal frags for now; we'll fix the points later
		// 1 point for returning
		ZD_Update_Player_Frags(pl,1);
		// assistance stuff
		ctf_la[player_team] = level.time;
		ctf_lapn[player_team] = player_id;
		***********************************************************/
		ctf_flagstate[flag_team] = CTF_FS_INBASE;
		in_base_counter[flag_team] = CTF_MAXUPD;
		ZD_Printf("%s returned the %s flag\n",player_name,tnames[flag_team]);
		ZD_ctfs( (flag_team==0) ? 3 : 7 );
		return_flag_to_base(flag_team, true);
	}

	/***************************************************************************
	 * TAKEN FROM BASE
	 ***************************************************************************/
	else if (player_team!=flag_team && ctf_flagstate[flag_team]==CTF_FS_INBASE && !pl->hasflag[flag_team])
	{
		pl->hasflag[flag_team]		= true;
		ctf_flagstate[flag_team]	= CTF_FS_TAKEN;
		ctf_carrier_id[flag_team]	= player_id;
		ZD_Printf("%s has taken the %s flag\n",player_name, tnames[flag_team]);
		ZD_ctfs( (flag_team==0) ? 1 : 5 );
	}

	/***************************************************************************
	 * TAKEN FROM THE DROPPED STATE
	 ***************************************************************************/
	else if (player_team!=flag_team && ctf_flagstate[flag_team]==CTF_FS_DROPPED && !pl->hasflag[flag_team])
	{
		pl->hasflag[flag_team]		= true;
		ctf_flagstate[flag_team]	= CTF_FS_TAKEN;
		ctf_carrier_id[flag_team]	= player_id;
		ZD_Printf("%s picked up the %s flag\n",player_name,tnames[flag_team]);
		ZD_ctfs( (flag_team==0) ? 1 : 5 );
	}

	/***************************************************************************
	 * SCORED
	 ***************************************************************************/
	else if (player_team==flag_team && pl->hasflag[opponent_team] && ctf_flagstate[flag_team]==CTF_FS_INBASE)
	{
		/********************************************************************
		Kilgore: just use normal frags for now; we'll fix the points later
		// 15 points for capture, 10 for every teammate
		int i;
		for (i=top_client;  i>=0;  i--)
		{
			if (!playeringame[i]) continue;
			if (players[i].userinfo.team == pl->userinfo.team)
				ZD_Update_Player_Frags(&players[i], (i==player_id) ? 15 : 10);
		}
		// assistance , 1 point
		if (level.time - ctf_la[player_team] <= CTF_MAXASSIST)
		{
			ZD_Update_Player_Frags(pl,1);
			ZD_Printf("%s made an assist\n",player_name);
			ZD_ctfs_1(player_id,9);
		}
		********************************************************************/
		
		ZD_Update_Team_Score(flag_team,1);
		ZD_Printf("%s scored for the %s team\n",player_name,tnames[flag_team]);

		pl->hasflag[opponent_team]		= false;
		ctf_flagstate[opponent_team]	= CTF_FS_INBASE;
		in_base_counter[opponent_team]	= CTF_MAXUPD;
		ctf_carrier_id[opponent_team]	= -1;
		return_flag_to_base(opponent_team, true);

		// Check for the teamscorelimit variable. Also play a "score" audio
		// for all captures except the winning one.
		if (teamscorelimit>0 && TeamInfo[flag_team].score >= teamscorelimit)
		{
			ZD_Printf("Flag Capture Limit Reached\n");
			ZD_ctfs(0);
			G_ExitLevel(0);
		}
		else
		{
			ZD_ctfs( (flag_team==0) ? 4 : 8 );
		}
	}
}

// called when a player dies (only by other player)

void CTF_DeathControl(player_t *victim, player_t *killer)
{
/********************************************************************
Kilgore: just use normal frags for now; we'll fix the points later
	int victim_team = victim->userinfo.team;
	int killer_team = killer->userinfo.team;

	// 1 frag for killer

	if (victim_team == ctf_opponent(killer_team))
		ZD_Update_Player_Frags(killer,1);

	// 2 frag for kill enemy flag carrier

	if (victim->hasflag[killer_team])
		ZD_Update_Player_Frags(killer,2);
********************************************************************/
}

// Called when a player dies (all cases, suicide, frag, etc)
void CTF_PlayerDies(player_t *pl)
{
	int i;

	for (i=0; i<2; i++)
	{
		if (pl->hasflag[i])
		{
			pl->hasflag[i]			= false;
			ctf_flagdroppedx[i]		= pl->mo->x;		//HSDEBUG: Maybe we want
			ctf_flagdroppedy[i]		= pl->mo->y;		//to put the dropped flag
			ctf_flagdroppedz[i]		= pl->mo->z;		//where the corpse lies.
			ctf_flagstate[i]		= CTF_FS_DROPPED;
			ctf_lostcnt[i]			= CTF_MAXLOST;
			in_dropped_counter[i]	= CTF_MAXUPD;
			ctf_carrier_id[i]		= -1;
			ZD_Printf("%s lost the %s flag\n",pl->userinfo.netname, tnames[i]);
			ZD_ctfs( (i==0) ? 2 : 6 );
			set_dropped_flag(i,true);
		}
	}
}


// flag thinks every tic
void CTF_FlagThink(int team)
{
	switch (ctf_flagstate[team])
	{
		case CTF_FS_INBASE:
			if (in_base_counter[team]>0 && (gametic & 7)==0)
			{
				return_flag_to_base(team, false);
				in_base_counter[team]--;
			}
			break;

		case CTF_FS_DROPPED:
			if (ctf_lostcnt[team]<=0)
			{
				ctf_flagstate[team] = CTF_FS_INBASE;
				in_base_counter[team] = CTF_MAXUPD;
				ZD_Printf("%s flag returned\n",tnames[team]);
				ZD_ctfs( (team==0) ? 3 : 7 );
				return_flag_to_base(team, true);
			}
			else
			{
				ctf_lostcnt[team]--;
				if (in_dropped_counter[team]>0 && (gametic & 7)==0)
				{
					set_dropped_flag(team,false);
					in_dropped_counter[team]--;
				}
			}
			break;
	}
}
#endif
