// Emacs style mode select	 -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: d_net.cpp,v 1.4 2004/10/10 18:40:27 incubus Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log: d_net.cpp,v $
// Revision 1.4  2004/10/10 18:40:27  incubus
// Sync with ZDaemon 1.06.07
//
// Revision 1.3  2004/07/23 09:18:12  incubus
// Removal of some unused or unnecessary functions.
//
// Revision 1.2  2004/07/21 22:24:20  incubus
// Remove StatusBar code dependancies. It's not needed in the server.
//
// Revision 1.1.1.1  2004/07/20 02:19:19  incubus
// ZDaemon 1.06 source import
//
//
// DESCRIPTION:
//		DOOM Network game communication and protocol,
//		all OS independent parts.
//
//-----------------------------------------------------------------------------

#include <stddef.h>

#include "version.h"
#include "m_alloc.h"
#include "m_random.h"
#include "i_system.h"
#include "i_video.h"
#include "i_net.h"
#include "g_game.h"
#include "doomdef.h"
#include "doomstat.h"
#include "c_console.h"
#include "d_netinf.h"
#include "cmdlib.h"
#include "s_sound.h"
#include "m_cheat.h"
#include "p_effect.h"
#include "p_local.h"
#include "c_dispatch.h"
#include "gi.h"
#include "sv_main.h"

doomcom_t*		doomcom;		
doomdata_t* 	netbuffer;		// points inside doomcom

//
// NETWORKING
//
// gametic is the tic about to (or currently being) run
// maketic is the tick that hasn't had control made for it yet
//
int 			maketic;
int 			ticdup; 		

// [RH] Special "ticcmds" get stored in here
static struct TicSpecial
{
	byte *streams[BACKUPTICS];
	int	  used[BACKUPTICS];
	byte *streamptr;
	int	  streamoffs;
	int   specialsize;
	int	  lastmaketic;
	BOOL  okay;

	TicSpecial ()
	{
		int i;

		lastmaketic = -1;
		specialsize = 256;

		for (i = 0; i < BACKUPTICS; i++)
			streams[i] = NULL;

		for (i = 0; i < BACKUPTICS; i++)
		{
			streams[i] = (byte *)Malloc (256);
			used[i] = 0;
		}
		okay = true;
	}

	~TicSpecial ()
	{
		int i;

		for (i = 0; i < BACKUPTICS; i++)
		{
			if (streams[i])
			{
				free (streams[i]);
				streams[i] = NULL;
				used[i] = 0;
			}
		}
		okay = false;
	}

	// Make more room for special commands.
	void GetMoreSpace ()
	{
		int i;

		specialsize <<= 1;

		DPrintf ("Expanding special size to %d\n", specialsize);

		for (i = 0; i < BACKUPTICS; i++)
			streams[i] = (byte *)Realloc (streams[i], specialsize);

		streamptr = streams[maketic%BACKUPTICS] + streamoffs;
	}

	void CheckSpace (int needed)
	{
		if (streamoffs >= specialsize - needed)
			GetMoreSpace ();

		streamoffs += needed;
	}

	void NewMakeTic ()
	{
		if (lastmaketic != -1)
			used[lastmaketic%BACKUPTICS] = streamoffs;

		lastmaketic = maketic;
		streamptr = streams[maketic%BACKUPTICS];
		streamoffs = 0;
	}

	TicSpecial &operator << (byte it)
	{
		if (streamptr)
		{
			CheckSpace (1);
			WriteByte (it, &streamptr);
		}
		return *this;
	}

	TicSpecial &operator << (const char *it)
	{
		if (streamptr)
		{
			CheckSpace (strlen (it) + 1);
			WriteString (it, &streamptr);
		}
		return *this;
	}

} specials;

void Net_ClearBuffers ()
{
	gametic = 0;
	maketic = 0;
}

int gametime;

//
// D_CheckNetGame
// Works out player numbers among the net participants
//
void D_CheckNetGame (void)
{
	int i;

	// I_InitNetwork sets doomcom and netgame
	I_InitNetwork ();
	if (doomcom->id != DOOMCOM_ID)
		I_FatalError ("Doomcom buffer invalid!");
	
	netbuffer = &doomcom->data;
	consoleplayer = displayplayer = doomcom->consoleplayer;

	// read values out of doomcom
	ticdup = doomcom->ticdup;

	// [NightFang] - overridden
	ticdup = 1;

	for (i = 0; i < doomcom->numplayers; i++)
		playeringame[i] = true;

	Printf ("player %i of %i (%i nodes)\n",
			consoleplayer+1, doomcom->numplayers, doomcom->numnodes);
}


//
// D_QuitNetGame
// Called before quitting to leave a net game
// without hanging the other players
//
void STACK_ARGS D_QuitNetGame (void)
{
	int i;

	if (debugfile)
	{
		fclose (debugfile);
		debugfile = NULL;
	}

	if (!netgame || !usergame || consoleplayer == -1)
		return;

	// send a bunch of packets for security
	netbuffer->player = consoleplayer;
	netbuffer->numtics = 0;
	for (i = 0; i < 4; i++)
	{
		I_WaitVBL (1);
	}
}

void Net_NewMakeTic (void)
{
	specials.NewMakeTic ();
}

void Net_WriteByte (byte it)
{
	specials << it;
}

void Net_WriteString (const char *it)
{
	specials << it;
}

// [RH] List "ping" times
CCMD (pings)
{
	int i;

	for (i=0; i<=top_client;  i++)
	{
		if (!ZD_ValidClient(i)) continue;
		Printf ("%4d %s\n",clients[i].ping,players[i].userinfo.netname);
	}
}
