// Emacs style mode select	 -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: p_tick.cpp,v 1.3 2004/10/10 18:40:30 incubus Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log: p_tick.cpp,v $
// Revision 1.3  2004/10/10 18:40:30  incubus
// Sync with ZDaemon 1.06.07
//
// Revision 1.2  2004/07/21 22:24:20  incubus
// Remove StatusBar code dependancies. It's not needed in the server.
//
// Revision 1.1.1.1  2004/07/20 02:19:19  incubus
// ZDaemon 1.06 source import
//
//
// DESCRIPTION:
//		Ticker.
//
//-----------------------------------------------------------------------------


#include "z_zone.h"
#include "p_local.h"
#include "p_effect.h"
#include "p_acs.h"
#include "c_console.h"
#include "b_bot.h"

#include "doomstat.h"

extern constate_e ConsoleState;
extern gamestate_t wipegamestate;
extern int top_client;

//
// P_Ticker
//
void P_Ticker (void)
{
	int i;

	// run the tic

	/*Added by MC: Freeze mode.*/
	for (i=top_client;  i>=0;  i--)
	{
		//if (playeringame[i] &&
		//	!(bglobal.freeze && players[i].isbot))

		// [NightFang] - modified
		//if (playeringame[i] && !players[i].isbot)
		if (playeringame[i])
		{
			// [NightFang] - only bots think every tic. Clients think when
			// we get a CMD
			if (players[i].mo && players[i].isbot)
			{ P_PlayerThink (&players[i]); }
		}
	}

	level.Tick ();			// [RH] let the level tick
	DThinker::RunThinkers ();

	//if added by MC: Freeze mode.
	if (!bglobal.freeze)
	{
		P_UpdateSpecials ();
	}

	// for par times
	level.time++;
}
