#include <stdio.h>

#ifdef	WIN32
#include <conio.h>
#endif

#include "doomdef.h"
#include "doomstat.h"
#include "gstrings.h"
#include "d_player.h"
#include "c_cvars.h"
#include "c_dispatch.h"
#include "c_bind.h"
#include "c_console.h"
#include "p_local.h"
#include "i_system.h"
#include "g_game.h"
#include "gstrings.h"
#include "s_sound.h"
#include "m_argv.h"
#include "r_defs.h"
#include "cmdlib.h"
#include "version.h"
#include "m_misc.h"
#include "m_random.h"
#include "a_sharedglobal.h"
#include "a_doomglobal.h"
#include "a_action.h"
#include "w_wad.h"
#include "g_level.h"							//Kilgore
#include "sv_main.h"
#include "log.h"
#include "submit.h"
#include "ip2c.h"
#include "watchdog.h"
#include "d_event.h"

#if __CTF__
//duke
//==
#include "ctf.h"
//==
#endif

#define		TIMEOUT_TIME		30*TICRATE		// 30 secs should be enough

//
// ZDaemon specific vars
//
int			zd_nextpos;								// Next level pos
int			parse_cl;								// Client whom we are reading info for
client_t	clients[MAXPLAYERS];					// A bunch of clients
bool		switching_kill;							// Kilgore: flag when killing team switchers
//Kilgore: it's better to avoid refreshing pings at the
//end of a level, as they are grossly inaccurate.
int			skip_ping_update = 0;
//
// ZDaemon local, externals (wtf?)
//
void		ZD_UpdateSectors(int j);
void		SV_KickPlayer(int pnum, char *reason);

//
// ZDaemon specific CVARS
//
CVAR (String, motd, "Welcome to ZDaemon<br>1.0<br><br><br>Happy fragging!", CVAR_SERVERINFO|CVAR_ARCHIVE)
CVAR (String, rcon_password, "password", CVAR_SERVERINFO|CVAR_ARCHIVE)
CVAR (Int,	  enable_rcon, -10, CVAR_SERVERINFO|CVAR_ARCHIVE)
CVAR (Int,	  cfg_activated, -10, CVAR_SERVERINFO|CVAR_ARCHIVE)

CVAR (Int, maxplayers,		MAXPLAYERS,	CVAR_SERVERINFO|CVAR_ARCHIVE);
CVAR (Int, maxclients,		MAXPLAYERS,	CVAR_SERVERINFO|CVAR_ARCHIVE);
CVAR (Int, minplayers,		0,			CVAR_SERVERINFO|CVAR_ARCHIVE);
CVAR (Int, removebotswhenhumans, 0,		CVAR_SERVERINFO|CVAR_ARCHIVE);

CVAR (Int,		master_advertise,	1,				CVAR_SERVERINFO|CVAR_ARCHIVE);
CVAR (Int,		force_password,		0,				CVAR_SERVERINFO|CVAR_ARCHIVE);
CVAR (String,	password,			"password",		CVAR_SERVERINFO|CVAR_ARCHIVE);
CVAR (Int,		load_skins,			0,				CVAR_SERVERINFO|CVAR_ARCHIVE);
CVAR (Int,		speed_check,		1,				CVAR_SERVERINFO|CVAR_ARCHIVE);

CVAR (Bool, sv_restartemptymap, false, CVAR_ARCHIVE|CVAR_GLOBALCONFIG);	// [Dash|RD] -- Restart the server if all the players leave.

EXTERN_CVAR (Float, sv_gravity)
EXTERN_CVAR (Float, sv_aircontrol)
EXTERN_CVAR (Int,	timelimit)

int	top_client;
//
// ZDaemon specific commands
//

CCMD(players)
{
	int			i;
	player_t	*p;
	const char	*fmt;

	fmt = (deathmatch) ?	"%d:  %s (%s) (Frags: %d) (Deaths: %d) (Time: %d) %s\n" :
							"%d:  %s (%s) (Kills: %d) (Deaths: %d) (Time: %d) %s\n";

	for (i=0; i<=top_client; i++)
	{
		if (!playeringame[i])	continue;
		p = players+i;
		Printf(fmt,
			i, p->userinfo.netname,
			NET_AdrToString(&clients[i].address),
			(deathmatch) ? p->fragcount : p->killcount , p->deathcount,
			p->minutesingame /*timeplay*/,
			(p->spectator) ? "  *SPEC*" : (p->isbot) ? "  *BOT*" :  ""
			);
	}
	Printf("%d players\n\n", ZD_ClientCount());
}

//
// ZD_Printf - Sends out global text
//
#define	MSGBUFSIZE		1024
void STACK_ARGS ZD_Printf(const char *string,...)
{
    va_list       argptr;
    char          sendstr[MSGBUFSIZE];

    va_start (argptr,string);
#ifdef _MSC_VER
	_vsnprintf (sendstr, MSGBUFSIZE-1, string, argptr);
#else
	vsnprintf (sendstr, MSGBUFSIZE-1, string, argptr);
#endif
    va_end (argptr);

	Printf("> %s", sendstr);

	// Send out to players
	ZDOP.Init();
	ZDOP.WriteByte(sv_printf);
	ZDOP.WriteString(sendstr);
	ZDOP.Broadcast();
}

//
// ZD_FindThingById - Ripped from the old src
//
AActor* ZD_FindThingById(int id)
{
    AActor *mo;
	
    // Try normal AActors first
	TThinkerIterator<AActor> iterator;
    while ( (mo = iterator.Next() ) )
    {
		if (mo->netid == id)
    	    return mo;
    }

    return NULL;
}

//
// ZD_ValidClient - checks and makes sure that this player is not a bot
//					and that its safe to send packets to
//

bool ZD_ValidClient(int i)
{
	return (playeringame[i] && !players[i].isbot);
}


//
// ZD_BroadcastDMFlags
//

void	ZD_ValidateCFG(void)
{
	UCVarValue	num;
	char		*cfgfile;

	gamestate = GS_LEVEL;

	cfgfile = Args.CheckValue ("-cfg");
	if (!cfgfile) cfgfile = "zserv.cfg";

        // [Dash|RD] To avoid an ambigious error if the config file doesn't exist we now check
        //           and report back to the user if it isn't there.
        if (C_ExecFile(cfgfile, false) == 1)
                { I_Error("Couldn't load configuration file (%s).", cfgfile);}	
	gamestate = GS_STARTUP;
	//AddCommandString("exec zserv.cfg");
	
	num = cfg_activated.GetGenericRep (CVAR_Int);

        // [Dash|RD] Previously at 0 -- This meant that the stock config would work. Not cool.
        if (num.Int < 1)
        { I_Error("You need to activate %s before zserv will run. %d", cfgfile, num.Int); }

}

static int var_current_clients = 0;

void notify_add_client(int idx)
{
      var_current_clients++;
      if (idx>top_client)
              top_client = idx;
}
 
void notify_del_client(int idx)
{
      int i;

      var_current_clients--;
      if (idx != top_client) return;
      for (i=idx-1; i>=0; i--)
      {
             if (playeringame[i]) break;
      }
     top_client = i;
}
  
//
// ZD_ClientCount - Returns the number of connected clients / spawned bots
//
int ZD_ClientCount(void)
{
     return var_current_clients;
}
 
//
// ZD_ClientCount - Returns the number of players / bots actually in game
//
int ZD_PlayerCount(void)
{
     int             i, pcount;

     pcount = 0;
     for (i=top_client;  i>=0;  i--)
     {
             if (playeringame[i] && !players[i].spectator)
                     pcount++;
     }
     return pcount;
}

//
// ZD_FindClientByAddr - Returns the client number that matches a clients
// address. Returns < 0 if not found
//
int	ZD_FindClientByAddr(netadr_t *addr)
{
	int		i;

	for (i=top_client;  i>=0;  i--)
	{	
		// There is a catch of course, we gotta be connected
		if (!clients[i].connected)
			continue;

		// We have a winnah!
		if (NET_CompareAdr(&clients[i].address, addr))
			return i;
	}

	// This dude gotta be trying to connect
	return -10;
}


//Kilgore
void ZD_Special_To_Player(int pnum,spec_event_t et,unsigned parm)
{
	if (!ZD_ValidClient(pnum)) return;
	ZDOP.Init();
	ZDOP.WriteByte(sv_special_event);
	ZDOP.WriteByte((byte) et);
	ZDOP.WriteByte((byte) parm);
	ZDOP.ToPlayer(pnum);
}

//Kilgore
void ZD_Special_To_All(spec_event_t et, unsigned parm)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_special_event);
	ZDOP.WriteByte((byte) et);
	ZDOP.WriteByte((byte) parm);
	ZDOP.Broadcast();
}

//Kilgore: implement lead tracking
static void Set_Player_Lead_State(int i, leadstate_t newstate, bool announce)
{
	spec_event_t se;

	if (players[i].lead_state == newstate)	return;
	switch (players[i].lead_state = newstate)
	{
		case LS_LEAD_HAS:		se = SE_LEADGOT;	break;
		case LS_LEAD_TIED:		se = SE_LEADTIED;	break;
		case LS_LEAD_NOTHAVE:	se = SE_LEADLOST;	break;
		default:				return;				// he's a spectator, so no message
	}
	if (announce) ZD_Special_To_Player(i,se,0);
}


//Kilgore: set player lead state based on his team's lead state
static void Update_Player_LS_From_Team_LS(bool announce)
{
	int i,tm;

	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i]) continue;
		tm = players[i].userinfo.team;
		if (tm<0 || tm>=NUM_TEAMS) continue;
		Set_Player_Lead_State( i,
							  (players[i].spectator) ? LS_LEAD_UNDEFINED : TeamInfo[tm].lead_state,
							  announce );
	}
}

EXTERN_CVAR (Int, maxteams)	//Kilgore

void ZD_Recalc_Team_Lead_States(void)
{
	int			nmax, maxv, i, tm, ts, nteams, actual_teams, membercount[NUM_TEAMS];
	leadstate_t	newstate;

	nteams = maxteams;
	nmax = 0;
	maxv = -100000;
	for (i=nteams-1; i>=0; i--)
	{
		ts = TeamInfo[i].score;
		if (ts > maxv)		{	maxv = ts;	nmax = 1;	}
		else if (ts==maxv)	nmax++;
	}
	newstate = (nmax==1) ? LS_LEAD_HAS : LS_LEAD_TIED;
	level.running_maxscore = maxv;
	for (i=nteams-1; i>=0; i--)
		TeamInfo[i].lead_state = (TeamInfo[i].score==maxv) ? newstate : LS_LEAD_NOTHAVE;

	// Find out how many teams are active in order to avoid announcements
	// when there is a single team only
	memset(membercount,0,sizeof(membercount));
	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i] || players[i].spectator) continue;
		tm = players[i].userinfo.team;
		if (tm<0 || tm>=nteams) continue;
		(membercount[tm])++;
	}
	actual_teams = 0;
	for (i=nteams-1; i>=0; i--)
		if (membercount[i]) actual_teams++;

	Update_Player_LS_From_Team_LS(actual_teams>1);
}


//Kilgore
void ZD_Update_Team_Score(int tm,int v)
{
	int			newscore, i;
	leadstate_t	newstate;

	if (!teamplay || tm<0 || tm>=NUM_TEAMS)	return;

	TeamInfo[tm].score += v;
	ZD_UpdateTeamScore(tm);

	//
	// Keep track of the lead
	//
	newscore = TeamInfo[tm].score;
	if (v>0)		// Positive change
	{
		if (newscore >= level.running_maxscore)
		{
			newstate = (newscore==level.running_maxscore) ? LS_LEAD_TIED : LS_LEAD_HAS;
			level.running_maxscore = newscore;
			for (i=maxteams-1; i>=0; i--)
				TeamInfo[i].lead_state = (TeamInfo[i].score==newscore) ? newstate : LS_LEAD_NOTHAVE;
			Update_Player_LS_From_Team_LS(true);
		}
	}
	else		// Negative change (suicide, env. kill, friendly kill)
	{
		if (newscore-v >= level.running_maxscore)
		{
			ZD_Recalc_Team_Lead_States();
		}
	}
}


void ZD_Recalc_Player_Lead_States(void)
{
	int				i,nmax,maxv,fc,nplayers;
	leadstate_t		newstate;
	bool			do_announce;

	nmax = nplayers = 0;
	maxv = -100000;
	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i] || players[i].spectator) continue;
		nplayers++;
		fc = players[i].fragcount;
		if (fc > maxv)		{	maxv = fc;	nmax = 1;	}
		else if (fc==maxv)	nmax++;
	}
	level.running_maxscore = (nplayers==0) ? 0 : maxv;
	newstate = (nmax==1) ? LS_LEAD_HAS : LS_LEAD_TIED;
	do_announce = (nplayers>1);
	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i]) continue;
		Set_Player_Lead_State(i, (players[i].spectator) ?		LS_LEAD_UNDEFINED :
								 (players[i].fragcount==maxv) ?	newstate :
																LS_LEAD_NOTHAVE,
							 do_announce );
	}
}


//Kilgore
void ZD_Update_Player_Frags(player_t *p,int v)
{
	int			i,newscore;
	leadstate_t	newstate;

	p->fragcount += v;
	ZD_UpdateFrags(p->netid);

	//
	// Keep track of the lead
	//
	if (!deathmatch) return;	// No point in tracking lead for cooperative games

	if (teamplay) return;		// Lead-tracking for team games is performed
								// in the UpdateTeamScore() function.

	newscore = p->fragcount;
	if (v>0)					// Positive change (normal kill)
	{
		if (newscore >= level.running_maxscore)
		{
			newstate = (newscore==level.running_maxscore) ? LS_LEAD_TIED : LS_LEAD_HAS;
			level.running_maxscore = newscore;
			for (i=top_client;  i>=0;  i--)
			{
				if (!playeringame[i]) continue;
				Set_Player_Lead_State(i, (players[i].spectator) ?			LS_LEAD_UNDEFINED :
										 (players[i].fragcount==newscore) ?	newstate :
																			LS_LEAD_NOTHAVE,
										true);
			}
		}
	}
	else						// Negative change (suicide, env. kill, friendly kill)
	{
		if (newscore-v >= level.running_maxscore)
		{
			ZD_Recalc_Player_Lead_States();
		}
	}
}

//Kilgore
static bool ZD_is_anybody_in_playing_teams(void)
{
	int i, tm;

	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i]) continue;
		tm = players[i].userinfo.team;
		if (tm>=0 && tm<maxteams) return true;
	}
	return false;
}

//Kilgore
static void ZD_Reset_Team_Scores(void)
{
	int i;

	for (i=maxteams-1; i>=0; i--)
	{
		TeamInfo[i].score = 0;
		TeamInfo[i].lead_state = LS_LEAD_TIED;
		ZD_UpdateTeamScore(i);
	}
}


//
// ZD_DisconnectClient - Will disconnect a client, server side
//
void ZD_DisconnectClient(int cl)
{
	int				i;
	player_t		*p;
	char			*s;

	if (!ZD_ValidClient(cl)) return;
	p = players+cl;

	#if __CTF__
	//duke
	//==
	if (ctf)
		CTF_PlayerDies(p);
	//==
	#endif

	// Before we disconnect them, attempt to update their stats
	ZD_UpdatePlayerStats(cl);
	
	s = p->userinfo.netname;
	if (*s)
		connlog_printf("%s disconnected", s);
	else
		s = NET_AdrToString (&clients[cl].address);

	if ((gametic - clients[cl].lastcmdtic) >= TIMEOUT_TIME)
		ZD_Printf("%s timed out.\n", s);
	ZD_Printf("%s disconnected\n", s);

	// Let everyone know of this
	ZDOP.Init();
	ZDOP.WriteByte(sv_disconnectclient);
	ZDOP.WriteByte(cl);

	for (i=top_client;  i>=0;  i--)
	{
		if (!ZD_ValidClient(i) || cl == i) continue;
		ZDOP.ToPlayer(i);
	}

	// Remove the AActor first
	if (p->mo)
	{
		p->mo->Destroy();
		p->mo = NULL;
	}

	client_clear(clients+cl);

	playeringame[cl] = false;
	GUI_DelPlayer(cl);
	notify_del_client(cl);

	//Kilgore: implement lead tracking
	#if __CTF__
	if (!ctf)
	#endif
	if (teamplay)
		ZD_Recalc_Team_Lead_States();
	else if (deathmatch)
		ZD_Recalc_Player_Lead_States();

	player_clear(p);

	if (teamplay)
	{
		// Check if anybody left in playing teams: if not, reset team scores
		if (!ZD_is_anybody_in_playing_teams())
			ZD_Reset_Team_Scores();
	}

	bglobal.min_player_control();

	// [Dash|RD] -- If this is the last player that was left reload the map to `freshen' it. Only do so
	// 		if we are in a game though, not at intermission/etc.
	if (!ZD_PlayerCount() && sv_restartemptymap && gameaction == ga_nothing && gamestate == GS_LEVEL)
	{
	   Printf("NOTICE: All players have left, restarting the map.\n");
	   G_DeferedInitNew (level.mapname);
	}
}

//
// ZD_UpdateState - updates current mobj states
//

void ZD_UpdateState(AActor	*mo, int statetype)
{
	if (!mo) 	// this shouldent happen
		return;

	if (mo->player) // players have their own way of doing this
		return;

	ZDOP.Init();
	ZDOP.WriteByte(sv_mobjstate);
	ZDOP.WriteShort(mo->netid);
	ZDOP.WriteLong(mo->angle);
	ZDOP.WriteByte(statetype);
	ZDOP.Broadcast();
}

//
// ZD_UpdatePlayerState
//

void ZD_UpdatePlayerState(int id, int statetype)
{
	player_t*	pl = &players[id];

	if (!playeringame[id]) 	// this shouldent happen
	{
		Printf("ZD_UpdatePlayerState: Cannot find %s\n", pl->userinfo.netname); 
		return;
	}
	ZDOP.Init();
	ZDOP.WriteByte(sv_playerstate);
	ZDOP.WriteByte(pl->netid);
	ZDOP.WriteByte(statetype);
	ZDOP.Broadcast();
}

//
// ZD_UpdateSpecificState - updates specific states that arent general (NOT USED)
// Kilgore: this looks completely unused by the client side, so why send the traffic?
//
#if 0
void ZD_UpdateSpecificState(AActor *mo)
{
	if (!mo) 	// this shouldent happen
		return;
	ZDOP.Init();
	ZDOP.WriteByte(sv_setspecificstate);
	ZDOP.WriteShort(mo->netid);
	ZDOP.WriteByte(mo->frame);
	ZDOP.Broadcast();
}
#endif
	


//
// ZD_SendOutPackets - Checks  everyones netbuf for anything that needs to be sent
//

void ZD_SendOutPackets(void)
{
	int			i;

	for (i=top_client;  i>=0;  i--)
	{
		if (!ZD_ValidClient(i))				continue;
		if (clients[i].netbuf.cursize<=0)	continue;
		ZD_SendPacket(i);
	}
}

//
// ZD_ClientError - Sends a error message to the client that requires
// disconnect.
// 

static void ZD_ClientError(int cl, char *text)
{
	// Display is locally in the console
	Printf("%s\n", text);

	ZDOP.Init();
	ZDOP.WriteByte(NETWORK_ERROR);
	ZDOP.WriteString(text);
	ZDOP.ToPlayer(cl);
	ZD_SendPacket(cl);

	// Disconnect em
	ZD_DisconnectClient(cl);
}


static void ZD_ConnectionError(netadr_t *adr, char *text)
{
	Printf("%s\n", text);

	ZDOP.Init();
	ZDOP.WriteByte(NETWORK_ERROR);
	ZDOP.WriteString(text);
	ZDOP.SendTo(adr,true);
}


//Kilgore
static void ZD_Send_User_Info(int receiver,player_t *player)
{
	ZDOP.Init();
	ZDOP.WriteByte  (sv_userinfo);
	ZDOP.WriteByte  (player->netid);
	ZDOP.WriteString(player->userinfo.netname); 
	ZDOP.WriteByte  (player->userinfo.team);											//Kilgore
	ZDOP.WriteBytes (clients[player->netid].address.ip,sizeof(clients[0].address.ip));	//Kilgore
	ZDOP.WriteWord  (clients[player->netid].address.port);								//Kilgore
	ZDOP.WriteByte  (player->userinfo.gender);
	ZDOP.WriteLong  (player->userinfo.color);
	//ZDOP.WriteLong(player->userinfo.aimdist);
	ZDOP.WriteString((char *)skins[player->userinfo.skin].name);

//	HSDEBUG: wait for 1.07
//	const char *c2 = (player->isbot) ? "_z" : clients[player->netid].c2;
//	if (!c2) c2 = "  ";
//	ZDOP.WriteBytes(c2,2);

	ZDOP.ToPlayer(receiver);
}

//
// ZD_UpdateUserinfo - Updates other players with userinfo changes
// our player
//
void ZD_UpdateUserinfo(int num,bool to_all)
{
	int	i;
	player_t*	player;

	player = players + num;
	for (i=top_client;  i>=0;  i--)
	{
		if (!ZD_ValidClient(i) || (!to_all && i==num) )	//Kilgore
			continue;
		ZD_Send_User_Info(i,player);
	}
}



//
// ZD_GetUserInfo - Gets the client name/team/color etc 
//

void ZD_GetUserInfo(void)
{
    player_t	*p;
	char		*str;
	char		*skin;
	int			old_team;
	
    p = &players[parse_cl];

	// Players name
	str = ZD_ReadString();
	if (strlen(str) > MAXPLAYERNAME)
		str[MAXPLAYERNAME] = '\0';
	strcpy(p->userinfo.netname, str);

	//Kilgore: read team info; default team is the last one
	old_team = p->userinfo.team;
	p->userinfo.team = ZD_ReadByte();
	if (p->userinfo.team<0 || p->userinfo.team>=NUM_TEAMS) p->userinfo.team = NUM_TEAMS-1;

    // Other info (gender, color, aim)
	p->userinfo.gender = ZD_ReadByte();
    p->userinfo.color = ZD_ReadLong();
    p->userinfo.aimdist = ZD_ReadLong();
	
	// Make sure the skin is valid
	skin = ZD_ReadString();
	p->userinfo.skin = R_FindSkin(skin);

	// Never switch on pickup
	p->userinfo.neverswitch = (ZD_ReadByte() > 0);

	//p->maxrate = ZD_ReadLong();

	//Kilgore: If teamplay active, enforce the team colors and announce the team
	AssignTeamColor(&p->userinfo);
	ZD_UpdateUserinfo(parse_cl,teamplay != 0);

	//Kilgore:	kill the people who switch teams: of course, they have to be
	//			alive and playing.
	if (teamplay && old_team!=p->userinfo.team)
	{
		if ( old_team!=NUM_TEAMS &&				// if it's not a new connection
			 p->playerstate!=PST_DEAD &&		// if he's not already dead
			 p->playerstate!=PST_WATCHING)		// if he's not spectating
		{
			#if __CTF__
			//duke
			//==
			if (ctf)
				CTF_PlayerDies(p);
			//==
			#endif
			switching_kill = true;
			P_PoisonDamage(p, NULL, 10000, false);
			switching_kill = false;
		}

		// Enforce max. team limit; members of non-playing teams will
		// always be spectators
		if (p->userinfo.team>=maxteams  &&  p->playerstate!=PST_WATCHING)
		{
			p->spectator = true;				// Make him a spectator
			p->playerstate = PST_WATCHING;

			// Tell everybody about his status
			ZDOP.Init();
			ZDOP.WriteByte (sv_spawnplayer);
			ZDOP.WriteByte (10);
			ZDOP.WriteByte (parse_cl);
			ZDOP.WriteByte (PST_WATCHING);
			ZDOP.WriteByte (10);
			ZDOP.WriteShort(p->mo->netid);
			ZDOP.WriteLong (p->mo->angle);
			ZDOP.WriteLong (p->mo->x);
			ZDOP.WriteLong (p->mo->y);
			ZDOP.WriteLong (p->mo->z);
			ZDOP.Broadcast();

			// Check if anybody left in playing teams: if not, reset team scores
			if (!ZD_is_anybody_in_playing_teams())
				ZD_Reset_Team_Scores();

		}
		ZD_Printf("%s is now on the %s team.\n", p->userinfo.netname,GetTeamName(p->userinfo.team));
		ZD_Recalc_Team_Lead_States();
	}

}

#if __CTF__
//duke
//==
/*******************
num values:
	0. Status report
	1. Red flag taken
	2. Red flag dropped
	3. Red flag returned
	4. Red team scores
	5. Blue flag taken
	6. Blue flag dropped
	7. Blue flag returned
	8. Blue Team scores
	9. Assist
********************/

void ZD_ctfs(int num)
{
	int i;

	ZDOP.Init();
	ZDOP.WriteByte(sv_ctf_event);
	ZDOP.WriteByte(num);
	for (i=0; i<2; i++)
		ZDOP.WriteByte(ctf_flagstate[i]);
	for (i=0; i<2; i++)
		ZDOP.WriteShort(ctf_carrier_id[i]);

	for (i=top_client;  i>=0;  i--)
	{
		if (!ZD_ValidClient(i) || clients[i].netstate != ZD_PLAYING) continue;
		ZDOP.ToPlayer(i);
	}
}

void ZD_ctf_state(int i)
{
	int j;

	ZDOP.Init();
	ZDOP.WriteByte(sv_ctf_state);
	for (j=0; j<2; j++)
		ZDOP.WriteByte(ctf_flagstate[j]);
	for (j=0; j<2; j++)
		ZDOP.WriteShort(ctf_carrier_id[j]);
	ZDOP.ToPlayer(i);
}

//==
#endif

//
// ZD_UpdateFrags - updates all players about pl
//
void ZD_UpdateFrags(int pl)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_updatefrags);
	ZDOP.WriteByte(pl);
	ZDOP.WriteShort(players[pl].fragcount);
	ZDOP.Broadcast();
	GUI_UpdateFrags(pl);
}

//Kilgore
void ZD_UpdateTeamScore(int tm)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_updateteamscore);
	ZDOP.WriteByte(tm);
	ZDOP.WriteShort(TeamInfo[tm].score);
	ZDOP.Broadcast();
}

//
// ZD_UpdateExperience - update the experience amount for a player
//
void ZD_UpdateExperience(int pl)
{
	if (!ZD_ValidClient(pl))	return;
	ZDOP.Init();
	ZDOP.WriteByte(sv_experience);
	ZDOP.WriteShort(players[pl].experience);
	ZDOP.ToPlayer(pl);
}


//Kilgore
CCMD (resetscores)
{
	int			i;
	player_t	*p;

	for (i=top_client;  i>=0;  i--)
	{ 
		p = players + i;
		memset (p->frags,0,sizeof(p->frags)); 
		p->fragcount = p->experience = p->killcount = p->deathcount = 
			p->spreecount = p->multicount = 0;
		if (playeringame[i])	
		{
			GUI_UpdateFrags(i);
			p->lead_state = (p->spectator) ? LS_LEAD_UNDEFINED : LS_LEAD_TIED;
			ZD_UpdateFrags(i);
			ZD_UpdateExperience(i);
		}
		else 
		{
			p->lead_state = LS_LEAD_UNDEFINED;
		}
	}
	level.running_maxscore = 0;
	if (teamplay)
		ZD_Reset_Team_Scores();
	ZD_Printf("=== ALL SCORES RESET BY SERVER ADMIN ===\n");
}

//
// ZD_SendFullUpdate
//
static void ZD_SendFullUpdate (int	cl)
{
	AActor		*mo;
	int			i;
	int			playerstate;
	player_t	*pl;

	// send players info to the client
	for (i=0; i<=top_client; i++)
	{
		// Todo: implement this
		if (!playeringame[i]) continue;
		if (!teamplay && cl==i) continue;		//Kilgore
		pl = players + i;

		if (!pl->mo) continue;

		if (pl->playerstate == PST_WATCHING || pl->spectator)
		{ playerstate = PST_WATCHING; }
		else
		{ playerstate = PST_REBORN; }

		ZDOP.Init();
		if (pl->isbot)
		{
			ZDOP.WriteByte(sv_spawnbot);
			ZDOP.WriteByte(10);		// do reborn, who cares?
			ZDOP.WriteByte(i);
		}
		else
		{
			ZDOP.WriteByte(sv_spawnplayer);
			ZDOP.WriteByte(10);		// do reborn, who cares?
			ZDOP.WriteByte(i);
			ZDOP.WriteByte(playerstate);
			ZDOP.WriteByte((pl->spectator) ? 10 : 0);
		}
		ZDOP.WriteShort(pl->mo->netid);
		ZDOP.WriteLong(pl->mo->angle);
		ZDOP.WriteLong(pl->mo->x);
		ZDOP.WriteLong(pl->mo->y);
		ZDOP.WriteLong(pl->mo->z);
		ZDOP.ToPlayer(cl);

		ZD_Send_User_Info(cl,pl);
	}

	// Send all bunch of userinfo to our client
	//ZD_UpdateUserinfo(cl);

	// Update frags for everyone
	ZDOP.Init();
	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i])	continue;
		ZDOP.WriteByte(sv_updatefrags);
		ZDOP.WriteByte(i);
		ZDOP.WriteShort(players[i].fragcount);
	}
	ZDOP.ToPlayer(cl);

	// Update players time (FREE BONUS!)
	ZDOP.Init();
	for (i=top_client;  i>=0;  i--)
	{
		// Todo: do this
		if (!playeringame[i]) continue;
		ZDOP.WriteByte(sv_playertimer);
		ZDOP.WriteByte(i);
		ZDOP.WriteShort(players[i].minutesingame);
	}
	ZDOP.ToPlayer(cl);

		// Kilgore: Update team scores
	if (teamplay)
	{
		ZDOP.Init();
		for (i=0; i<NUM_TEAMS; i++)
		{
			ZDOP.WriteByte(sv_updateteamscore);
			ZDOP.WriteByte(i);
			ZDOP.WriteShort(TeamInfo[i].score);
		}
		ZDOP.ToPlayer(cl);
	}

	// update things
	TThinkerIterator<AActor> iterator;
	const	TypeInfo *type;

    while ( (mo = iterator.Next() ) )
    {
		if (!mo->netid)
			continue;

		type = ZDRUNTIME_TYPE(mo);

        // Standard non-shootable thing
		if (!mo->IsKindOf (ZDRUNTIME_CLASS(APlayerPawn)) && 
			!(mo->flags & MF_MISSILE) && 
			!mo->IsKindOf (ZDRUNTIME_CLASS(ARainPillar)))
		{	
			// Wow! 20 bytes! Thats alot I can see alot of overflows
			// here...best check it up!
			ZDOP.Init();
			ZDOP.WriteByte(sv_spawnmobj);
			ZDOP.WriteLong(mo->x);
			ZDOP.WriteLong(mo->y);
			ZDOP.WriteLong(mo->z);
			ZDOP.WriteString((char *)type->Name + 1);
			ZDOP.WriteShort(mo->netid);
			ZDOP.ToPlayer(cl);
		}

		/*
		// We have a missile, spawn it as a missile
		if ((mo->flags & MF_MISSILE) && 
			!mo->IsKindOf (ZDRUNTIME_CLASS(ARainPillar)))
		{
			ZDOP.Init();
			ZDOP.WriteByte(sv_spawnmissile);
			ZDOP.WriteString((char *)type->Name + 1);		
			ZDOP.WriteShort(mo->netid);
			ZDOP.WriteShort(mo->x >> FRACBITS);
			ZDOP.WriteShort(mo->y >> FRACBITS);
			ZDOP.WriteShort(mo->z >> FRACBITS);
			ZDOP.WriteShort(mo->momx >> FRACBITS);
			ZDOP.WriteShort(mo->momy >> FRACBITS);
			ZDOP.WriteShort(mo->momz >> FRACBITS);
			ZDOP.WriteLong(mo->angle);
			ZDOP.ToPlayer(cl);
		}
		*/

		// a monster
		if (mo->IsKindOf (ZDRUNTIME_CLASS(ALostSoul)) || (mo->flags & MF_COUNTKILL) )
		{
			ZDOP.Init();
			ZDOP.WriteByte(sv_mobjangle);
			ZDOP.WriteShort(mo->netid);
			ZDOP.WriteLong(mo->angle);
			ZDOP.ToPlayer(cl);
		}

		// corpses
		if (mo->health <= 0 && (mo->flags & MF_COUNTKILL))
		{
			// We just gotta know its a corpse
			ZDOP.Init();
			ZDOP.WriteByte(sv_corpse);
			ZDOP.WriteShort(mo->netid);
			ZDOP.ToPlayer(cl);
		}

    }

	#if __CTF__
		ZD_ctf_state(cl);
	#endif

	if (timelimit>0)
	{
		int timeleft = level.end_time - level.time;		// in ticks
		if (timeleft<0) timeleft=0;
		ZDOP.Init();
		ZDOP.WriteByte(sv_timeleft);
		ZDOP.WriteLong(timeleft);
		ZDOP.ToPlayer(cl);
	}

	ZD_SendPacket(cl);
}


EXTERN_CVAR (Int, fraglimit)
EXTERN_CVAR (Int, teamscorelimit)
EXTERN_CVAR (Int, spam_window)
EXTERN_CVAR (Int, spam_limit)

static void send_init_sequence(int i)
{
	UCVarValue	num;

	ZDOP.Init();

	// Player Identifier
	ZDOP.WriteByte(sv_consoleplayer);
	ZDOP.WriteByte(i);

	// Current dmflags
	ZDOP.WriteByte(sv_dmflags);
	ZDOP.WriteLong((int) dmflags);
	ZDOP.WriteLong((int) dmflags2);

	// Skill
	ZDOP.WriteByte(sv_skill);
	ZDOP.WriteLong((int) gameskill);

	// Lots of game info
	ZDOP.WriteByte(sv_gametype);
	ZDOP.WriteByte(
	#if __CTF__
					(ctf) ?			3 : // CTF
	#endif
					(teamplay) ?	1 :	// Team DM
					(deathmatch) ?	0 :	// Deathmatch (FFA)
									2 	// Coop. games
				);
	num = teamdamage.GetGenericRep(CVAR_Float);
	ZDOP.WriteFloat(num.Float);
	ZDOP.WriteShort((int)fraglimit);
	ZDOP.WriteShort((int)teamscorelimit);
	ZDOP.WriteShort((int)timelimit);			// in minutes
	ZDOP.WriteShort((int)spam_window);
	ZDOP.WriteShort((int)spam_limit);
	num = sv_gravity.GetGenericRep(CVAR_Float);
	ZDOP.WriteFloat(num.Float);
	num = sv_aircontrol.GetGenericRep(CVAR_Float);
	ZDOP.WriteFloat(num.Float);

	ZDOP.ToPlayer(i);
}

//
// ZD_ConnectNewPlayer - Sends all the data about the server (map, players...etc)
// 
static void ZD_ConnectNewPlayer()
{
	UCVarValue	num;
	player_s	*pl;
	client_t	*cl;
	char		*addr, *colon;

	// Set our new state
	cl = clients + parse_cl;
	pl = players + parse_cl;

	cl->netstate = ZD_CONNECTED;
	cl->lastgametic = gametic;
	cl->lastcmdtic = gametic;

	SZ_Clear(&cl->netbuf);

	send_init_sequence(parse_cl);

	ZDOP.Init();

	// Send and have client load the map up
	ZDOP.WriteByte(sv_loadmap);
	ZDOP.WriteString(level.mapname);

	// Send the MOTD
	num = motd.GetGenericRep(CVAR_String);
	ZDOP.WriteByte(sv_motd);
	ZDOP.WriteString(num.String);

	ZDOP.ToPlayer(parse_cl);

	// Apparently, we know the client is in the game, but the 
	// client dosent know this. So instead of calling multiple 
	// P_SpawnPlayers and messing ourselves up, we just re-send
	// the spawn data. Make sense?
	if (cl->netstate == ZD_PLAYING)
	{
		ZDOP.Init();
		ZDOP.WriteByte (sv_spawnplayer);
		ZDOP.WriteByte (10);
		ZDOP.WriteByte (parse_cl);
		ZDOP.WriteByte (PST_REBORN);
		ZDOP.WriteByte ((pl->spectator) ? 10 : 0 );
		ZDOP.WriteShort(pl->mo->netid);
		ZDOP.WriteLong (pl->mo->angle);
		ZDOP.WriteLong (pl->mo->x);
		ZDOP.WriteLong (pl->mo->y);
		ZDOP.WriteLong (pl->mo->z);
		ZDOP.ToPlayer(parse_cl);
	}
	else
	{
		if (deathmatch)		G_DeathMatchSpawnPlayer(parse_cl);
		else				P_SpawnPlayer(&playerstarts[parse_cl % 4], parse_cl);
	}

	ZD_UpdateSectors(parse_cl);
	ZD_SendFullUpdate(parse_cl);
	cl->netstate = ZD_PLAYING;

	//Kilgore: reset scores and all player info.
	pl->fragcount = pl->experience =  pl->killcount = pl->deathcount = 0;
	memset(&(pl->userinfo),0,sizeof(pl->userinfo));
	pl->userinfo.team = NUM_TEAMS;		//Make sure the team is invalid
	pl->lead_state = LS_LEAD_UNDEFINED;	//He's not playing yet
	pl->join_time = pl->past_time = 0;
	pl->last_check_time = 0;
	pl->npackets = 0;
	pl->turbo_counter = 0;
	pl->hispeed_counter = 0;


	ZD_ReadByte();		// read cl_userinfo
	ZD_GetUserInfo();	// Process userinfo

	ZD_Printf("%s has connected.\n", pl->userinfo.netname);

	addr = NET_AdrToString (&cl->address);
	if ( (colon=strchr(addr,':')) != NULL ) *colon = '\0';
	connlog_printf("%s (%s) has connected", pl->userinfo.netname, addr );

	GUI_UpdateName(parse_cl);
}

//
// ZD_GetUserCmd 
//
void ZD_GetUserCmd(void)
{
	player_t	*pl;
	angle_t		angle;
	angle_t     restore_pitch;// [Duke4Ever!] to backup the pitch value
	angle_t		pitch;
	int			tic;

	pl = players + parse_cl;
	tic = ZD_ReadLong();
	pl->cmd.ucmd.buttons = ZD_ReadByte();

	pitch =	(angle_t)(ZD_ReadWord()*-1);
#if 0		//HSDEBUG: Starting to debug the freelook problem
{
unsigned dw = ZD_ReadWord();
if (dw) Printf("dw = %u (%04x)\n",dw,dw);
pitch = (angle_t) ( ((int)dw)*-1 );
}

if (pitch) Printf("pitch = %u\n",(unsigned)pitch);
#endif
	pl->cmd.ucmd.yaw =			ZD_ReadWord();
	pl->cmd.ucmd.forwardmove =	ZD_ReadWord();
	pl->cmd.ucmd.sidemove =		ZD_ReadWord();
	pl->cmd.ucmd.upmove =		ZD_ReadWord();
	pl->cmd.ucmd.roll =			ZD_ReadWord();
	angle			=			ZD_ReadLong();

	if (pl->cmd.ucmd.buttons & BT_ATTACK)
	{
		// This varible is gonna travel!
		pl->clientwep = (weapontype_t)ZD_ReadByte();
	}

	if (gamestate == GS_LEVEL) // intermission or something
	{
		if (pl->mo)
		{
			pl->mo->angle = angle;
			// Up/down stuff
			
			// [Duke4Ever!] make a backup of the pitch value:
			restore_pitch = pl->mo->pitch;
			
			//Duke4Ever changed to fix freelook:
			//pl->mo->pitch = pitch << 16;
			pl->mo->pitch += pitch << 16;

			// [Duke4Ever!] added - restore the pitch value when aim is to short:
			if (pl->mo->pitch < -381774848) pl->mo->pitch = restore_pitch;
            
            // [Duke4Ever!] added - restore the pitch value when aim is to big
            if (pl->mo->pitch > 668105984) pl->mo->pitch = restore_pitch;
		}

		P_PlayerThink (pl);
		if (pl->mo)
			pl->mo->Tick();
	}

	// Dont timeout.
	clients[parse_cl].lastcmdtic = gametic;

	clients[parse_cl].gametics = tic;

	if (++(pl->npackets)>=35)
	{
		unsigned	cur_time,elapsed, min_elapsed;

		cur_time = I_MSTime();
		elapsed = cur_time - pl->last_check_time;
		pl->last_check_time = cur_time;

		min_elapsed = 1000 * (pl->npackets-1);
		min_elapsed /= TICRATE;					// Assumed ticrate of clients
		min_elapsed *= 6;						// Safety margin (85%)
		min_elapsed /= 7;

		if (elapsed<min_elapsed)
		{
			if (++(pl->hispeed_counter) >= 30)
			{
				if (speed_check)
					SV_KickPlayer(parse_cl,"SPEEDHACK");
				else
					connlog_printf("%s failed the SPEEDHACK test",pl->userinfo.netname);
			}
		}
		else
		{
			if (pl->hispeed_counter>0)
				(pl->hispeed_counter)--;
		}

		pl->npackets = 0;

	}
}


//
// ZD_TriggerLine
//
void ZD_TriggerLine(line_t* line, player_t* player, bool repeat)
{
	int		lnum;

	if (!player)	return;

	for (lnum=numlines-1; lnum>=0; lnum--)
	{
		if (lines[lnum].id == line->id)
			break;;
	}
	if (lnum<0) return;

	ZDOP.Init();
	ZDOP.WriteByte(sv_toggleline);
	ZDOP.WriteLong(lnum);
	ZDOP.WriteByte((repeat) ? 10 : 0);
	ZDOP.Broadcast();
}

//
// ZD_TriggerDoor
//
void ZD_TriggerDoor(sector_t*	sec, int direction, int time, int type, fixed_t speed)
{

}


//
// ZD_TriggerPlat
//

void ZD_TriggerPlat(sector_t* sec, int type, int status, int wait, fixed_t speed, fixed_t high, fixed_t low)
{
	
}

//
// ZD_UpdateSectors - Other than doors/platforms this function updates everything else
//

void ZD_UpdateSectors(int j)
{
	int		i;
	sector_t*	sec;

	if (!ZD_ValidClient(j))
		return;

	for (i=0; i<numsectors; i++)
	{
		sec = &sectors[i];

		// NOTHING going on!

		// Check and see if flats need to be updated
		if (sec->flatchange)
		{
			ZDOP.Init();
			ZDOP.WriteByte(sv_updatesector);
			ZDOP.WriteShort(sec->netid);
			ZDOP.WriteString(lumpinfo[sec->floorpic+firstflat].name);
			//ZDOP.WriteString(lumpinfo[sec->ceilingpic+firstflat].name);
			ZDOP.ToPlayer(j);
		}

		// Hardcore- update the ceiling/floor heights
		//////////////////////////////////////////////////

		if (sec->heightchange)
		{
			ZDOP.Init();
			ZDOP.WriteByte(sv_moveplane);
			ZDOP.WriteShort(sec->netid);
			if (sec->floorOrCeiling == 0)
			{
				ZDOP.WriteShort(sec->floorplane.d >> FRACBITS);
				//ZDOP.WriteLong(sec->CenterFloor());
			}
			else
			{
				ZDOP.WriteShort(sec->ceilingplane.d >> FRACBITS);
				//ZDOP.WriteLong(sec->CenterCeiling());
			}
			ZDOP.WriteShort(sec->destlevel >> FRACBITS);
			ZDOP.WriteByte(sec->crush);
			ZDOP.WriteByte(sec->floorOrCeiling);
			ZDOP.WriteByte(sec->direction);
			ZDOP.ToPlayer(j);
		}


	}
}

//
// ZD_DestroyAActor - This was orginally in AActor::Destroy but calling it for every single
// thing like removal of bullet puffs was un-nescessary bandwidth being eaten up.
//

void ZD_DestroyAActor(AActor *mo)
{
	// [NightFang] - BUT FIRST! Let all clients know
	ZDOP.Init();
	ZDOP.WriteByte(sv_destroymobj);
	ZDOP.WriteShort(mo->netid);
	ZDOP.Broadcast();
}

//
// ZD_UpdatePlayerCorpses
//

void ZD_UpdatePlayerCorpses(void)
{
	int			i;
	player_t*	player;

	if (gametic % TICRATE)
		return;

	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i])
			continue;

		player = &players[i];

		if (!player->mo)
			continue;

		if (player->playerstate == PST_DEAD)
		{
			ZDOP.Init();
			ZDOP.WriteByte(sv_killplayer);
			ZDOP.WriteByte(player->netid);
			ZDOP.WriteShort(player->mo->health);
			ZDOP.Broadcast();
		}
	}
}


//
// ZD_UpdateThings
//

void ZD_UpdateThings(void)
{
	AActor	*mobj;

	if (gametic & 1) return;
	TThinkerIterator<AActor> iterator;
	const	TypeInfo *type;

	while ( (mobj = iterator.Next()))
	{
		if (mobj->player)
			continue;

		type = ZDRUNTIME_TYPE(mobj);
	
		if ( (mobj->flags & MF_SHOOTABLE) && (mobj->target || mobj->goal) )
		{
			unsigned bits = 0;

			if (mobj->x != mobj->oldx)			bits |= CM_X;
			if (mobj->y != mobj->oldy)			bits |= CM_Y;
			if (mobj->z != mobj->oldz)			bits |= CM_Z;
			if (mobj->angle != mobj->oldangle)	bits |= CM_ANGLE;
			if (mobj->momx != mobj->oldmomx)	bits |= CM_MOMX;
			if (mobj->momy != mobj->oldmomy)	bits |= CM_MOMY;
			if (mobj->momz != mobj->oldmomz)	bits |= CM_MOMZ;
			if (bits)
			{
				ZDOP.Init();
				ZDOP.WriteByte (sv_movething);
				ZDOP.WriteShort(mobj->netid);
				ZDOP.WriteByte (bits);
				if (bits & CM_X)		ZDOP.WriteShort(mobj->x >> FRACBITS);
				if (bits & CM_Y)		ZDOP.WriteShort(mobj->y >> FRACBITS);
				if (bits & CM_Z)		ZDOP.WriteShort(mobj->z >> FRACBITS);
				if (bits & CM_ANGLE)	ZDOP.WriteLong (mobj->angle);
				if (bits & CM_MOMX)		ZDOP.WriteShort(mobj->momx >> FRACBITS);
				if (bits & CM_MOMY)		ZDOP.WriteShort(mobj->momy >> FRACBITS);
				if (bits & CM_MOMZ)		ZDOP.WriteShort(mobj->momz >> FRACBITS);
				ZDOP.Broadcast();
			}
	    }

		mobj->oldx = mobj->x;
		mobj->oldy = mobj->y;
		mobj->oldz = mobj->z;
		mobj->oldangle = mobj->angle;
		mobj->oldframe = mobj->frame;
		mobj->oldmomx = mobj->momx;
		mobj->oldmomy = mobj->momy;
		mobj->oldmomz = mobj->momz;
	}
}


//
// ZD_UpdateConsolePlayer
//
	
static void ZD_UpdateConsolePlayer(int cl)
{
	player_t *player = &players[cl];
	
	// Spectators can move around freely, without us 
	// telling it what to do (lag-less)
	if (!player->mo || player->spectator)	return;

	// client player will update his position if packets were missed
	ZDOP.Init();
	ZDOP.WriteByte (sv_updatelocalplayer);
	ZDOP.WriteLong (clients[cl].gametics);
	ZDOP.WriteByte (player->playerstate);
	ZDOP.WriteLong (player->mo->x);
	ZDOP.WriteLong (player->mo->y);
	ZDOP.WriteLong (player->mo->z);
	ZDOP.WriteLong (player->mo->momx);
	ZDOP.WriteLong (player->mo->momy);
	ZDOP.WriteLong (player->mo->momz);
	ZDOP.ToPlayer(cl);
}

//
// ZD_UpdatePings
//
static void ZD_UpdatePings()
{
	int i;

	if (gametic % (4*TICRATE))
		return;

	if (skip_ping_update>0)
	{
		skip_ping_update--;
		return;
	}

	ZDOP.Init();
	for (i=top_client;  i>=0;  i--)
	{
		if (!ZD_ValidClient(i)) continue;
		ZDOP.WriteByte(sv_updateping);
		ZDOP.WriteByte(i);
		ZDOP.WriteShort(clients[i].ping);
	}
	ZDOP.Broadcast();
}

//
// ZD_WriteCommands
//
void ZD_WriteCommands(void)
{
	AActor		*mobj;
	int			i, j;
	unsigned	bits;
	
	ZD_UpdateThings();
	ZD_SendHeartBeat();
	ZD_UpdatePlayerCorpses();

	if ( (gametic & 1) == 0 )
	{
		for (j=top_client;  j>=0;  j--)
		{
			// Update all players (including bots)
			if (!playeringame[j] || players[j].spectator) continue;

			mobj = players[j].mo;
			if (!mobj) continue;

			bits = 0;
			if (mobj->x != mobj->oldx)			bits |= CM_X;
			if (mobj->y != mobj->oldy)			bits |= CM_Y;
			if (mobj->z != mobj->oldz)			bits |= CM_Z;
			if (mobj->angle != mobj->oldangle)	bits |= CM_ANGLE;
			if (mobj->momx != mobj->oldmomx)	bits |= CM_MOMX;
			if (mobj->momy != mobj->oldmomy)	bits |= CM_MOMY;
			if (mobj->momz != mobj->oldmomz)	bits |= CM_MOMZ;

			ZDOP.Init();
			ZDOP.WriteByte(sv_moveplayer);
			ZDOP.WriteByte(j);     // player number
			ZDOP.WriteByte(bits);
			if (bits & CM_X)		ZDOP.WriteShort(mobj->x >> FRACBITS);
			if (bits & CM_Y)		ZDOP.WriteShort(mobj->y >> FRACBITS);
			if (bits & CM_Z)		ZDOP.WriteShort(mobj->z >> FRACBITS);
			if (bits & CM_ANGLE)	ZDOP.WriteLong (mobj->angle);
			if (bits & CM_MOMX)		ZDOP.WriteShort(mobj->momx >> FRACBITS);
			if (bits & CM_MOMY)		ZDOP.WriteShort(mobj->momy >> FRACBITS);
			if (bits & CM_MOMZ)		ZDOP.WriteShort(mobj->momz >> FRACBITS);
			// Dead or alive? We decide!
			ZDOP.WriteByte(mobj->health > 0);

			for (i=top_client;  i>=0;  i--)
			{
				if (i==j ||  !ZD_ValidClient(i))	continue;
				ZDOP.ToPlayer(i);
			}
		}
	}

	// It's not a good idea to send 30 bytes every tic.
	// [Danni] was 3
	if ( (gametic % 5)==0 )
	{
		for (i=top_client;  i>=0;  i--)
		{
			if (!ZD_ValidClient(i))	continue;
			ZD_UpdateConsolePlayer(i);
		}
	}

	ZD_UpdatePings();

	for (i=top_client;  i>=0;  i--)
	{
		if (!playeringame[i])		continue;
		if (players[i].spectator)	continue;

		mobj = players[i].mo;

		if (!mobj)					continue;

		mobj->oldx = mobj->x;
		mobj->oldy = mobj->y;
		mobj->oldz = mobj->z;
		mobj->oldangle = mobj->angle;
		mobj->oldframe = mobj->frame;
		mobj->oldmomx = mobj->momx;
		mobj->oldmomy = mobj->momy;
		mobj->oldmomz = mobj->momz;
	}

}

void client_clear(client_t *clp)
{
	sizebuf_t	netbuf, relpackets;

	memcpy(&netbuf,&clp->netbuf,sizeof(netbuf));
	memcpy(&relpackets, &clp->relpackets, sizeof(relpackets));
	memset(clp,0,sizeof(client_t));
	memcpy(&clp->netbuf,&netbuf,sizeof(netbuf));
	memcpy(&clp->relpackets,&relpackets,sizeof(relpackets));
	SZ_Clear(&clp->netbuf);
	SZ_Clear(&clp->relpackets);
}

void player_clear(player_t *plp)
{
	plp->playerstate = PST_UNDEFINED;

	plp->spectator = false;
	plp->needreborn = false;
	plp->lastreborn = 0;
	plp->cheats = 0;
	plp->netid = 0;
	plp->level = 0;
	plp->isbot = false;

	memset (plp->frags,0,sizeof(plp->frags)); 
	plp->fragcount = plp->killcount =  plp->deathcount = plp->experience = 0;
	plp->timeplay = plp->minutesingame = 0;
	plp->join_time = plp->past_time = 0;
	plp->last_check_time = 0;
	plp->npackets = 0;
	plp->turbo_counter = 0;
	plp->hispeed_counter = 0;

	memset(&(plp->userinfo),0,sizeof(plp->userinfo));
	plp->userinfo.team = NUM_TEAMS;
	plp->lead_state = LS_LEAD_UNDEFINED;

	plp->readytogo = 0;

	#if __CTF__
		memset(plp->hasflag,0,sizeof(plp->hasflag));
	#endif
}

//
// ZD_SetupNewConnection 
//
static void ZD_SetupNewConnection(bool newplayer)
{
	int				version, i, player, level, client_nwads;
	char			*clientpassword, *client_wadname, *errmsg;
	client_t		*clp;
	player_t		*plp;
	unsigned long	ipv;
	byte			client_checksum[16];
	
	// Find a place in our array
	if (newplayer)
	{
		// Make sure our variables can handle another player first
		if (ZD_ClientCount() >= maxclients)
		{
			ZD_ConnectionError(&net_from, "Server is full.");
			return;
		}
		// Search for an opening in the array
		for (i=0; i<MAXPLAYERS; i++)
		{
			if (!playeringame[i])
				break;
		}
		if (i>=MAXPLAYERS)				// No room
		{
			ZD_ConnectionError(&net_from, "Server is full.");
			return;
		}
		player = i;
	}
	else	// Must have missed the packet
	{
		player = parse_cl;
	}
	version = ZD_ReadByte();					// Version Info
	level = ZD_ReadByte();						// Read their level
	clientpassword = ZD_ReadString();			// Password (case insensitive)

	// Don't let players join during an intermission
	if (gamestate != GS_LEVEL)
		return;

	// Who is connecting
	Printf("%s connection (v. %d)\n", NET_AdrToString(&net_from), version);

	playeringame[player] = true;

	// Keep track of highest used index in the player/client arrays
	if (newplayer)	notify_add_client(player);
	
	// Setup the client 
	clp = clients + player;
	client_clear(clp);

	clp->connected = true;
	clp->address = net_from;
	clp->netstate = ZD_CONNECTING;
	clp->playernum = player;

	// Client is now in the loop, prevent from a early timeout
	clp->lastcmdtic = clp->lastgametic = gametic;

	// Find out the country from where he's connecting
	ipv = 0;
	for (i=0; i<4; i++)
		ipv = (ipv << 8) + clp->address.ip[i];
	ip2c_info_n2(ipv,&clp->c2,&clp->country_name,NULL,NULL);

	// Setup the player

	plp = players + player;
	player_clear(plp);	

	plp->playerstate = PST_WATCHING;
	plp->spectator = true;
	plp->needreborn = true;
	plp->cheats |= CF_NOTARGET;
	plp->netid = player;
	plp->level = level;

	// [NightFang] - update server list
	if (newplayer) GUI_AddPlayer(player);

	// Make sure the version number matches
//	if (version != 255)		//Kilgore: Special version number for the betas (HSDEBUG)
	if (version != VERSION)
	{
		ZD_ClientError(player, "You are using an outdated version of ZDaemon. Visit:\n   http://www.zdaemon.org/\nto download the most recent version.\n");
		return;
	}

	// [NightFang:1.04] - Great, the version number matches, now check
	// the password (if needed, of course)
	if ( force_password && stricmp(password, clientpassword) )
	{
		ZD_ClientError(player, "Incorrect Password.");
		return;
	}

	// Now check if the client has loaded the appropriate WADs and
	// verify their integrity.
	client_nwads = ZD_ReadByte();
	WC_begin();
	for (i=0; i<client_nwads; i++)
	{
		client_wadname = ZD_ReadString();
		ZD_ReadBytes(client_checksum,16);
		if ( (errmsg =  WC_check_wad(client_wadname,client_checksum)) != NULL )
		{
			ZD_ClientError(player,errmsg);
			return;
		}
	}
	if ( (errmsg=WC_end()) != NULL )
	{
		ZD_ClientError(player,errmsg);
		return;
	}

	// Send heartbeat back
	ZDOP.Init();
	ZDOP.WriteByte(CONNECT_READY);
	ZDOP.ToPlayer(player);
	ZD_SendPacket(player);

	// Check for banned ip addresses
	SV_EnforceBans(player);
}


void ZD_WeaponSlot(void)
{
	byte slot = ZD_ReadByte();
	int	 player = parse_cl;

	if (slot < NUM_WEAPON_SLOTS)
	{
		weapontype_t newweap = WeaponSlots[slot].PickWeapon (&players[player]);
		if (newweap < NUMWEAPONS && newweap != players[player].readyweapon)
		{
			players[player].pendingweapon = newweap;
		}
	}
}

//
// ZD_WeaponSelect
//
void ZD_WeaponSelect(void)
{
	int	 player = parse_cl;
	byte which = ZD_ReadByte ();
	FWeaponInfo **infos = (players[player].powers[pw_weaponlevel2]
					&& deathmatch) ? wpnlev2info : wpnlev1info;

	if (which < NUMWEAPONS
		&& which != players[player].readyweapon
		&& players[player].weaponowned[which]
		&& (infos[which]->ammo >= NUMAMMO ||
		    players[player].ammo[infos[which]->ammo] >= infos[which]->ammouse))
	{
		// The actual changing of the weapon is done when the weapon
		// psprite can do it (A_WeaponReady), so it doesn't happen in
		// the middle of an attack.
		players[player].pendingweapon = (weapontype_t)which;
	}
}


//
// ZD_SendHeartbeat
//

void ZD_SendHeartBeat(void)
{
	int		i;
	unsigned t;

	if (gametic % (3*TICRATE))
		return;

	t = I_MSTime();

	for (i=top_client; i>=0; i--)
	{
		if (!ZD_ValidClient(i)) continue;
		clients[i].lastgametic = t;
		ZDOP.Init();
		ZDOP.WriteByte(sv_ping);
		ZDOP.WriteLong(t);
		ZDOP.ToPlayer(i);
		GUI_UpdatePing(i);
	}
}
//
// ZD_DoPlayerTime - calculates the number of minutes based apon how long the player
// has been in the game (in tics)
//

void ZD_DoPlayerTime(void)
{
	int			i;
	player_t	*pl;

	for (i=top_client; i>=0; i--)
	{
		// Because of select() quering the kernel, this screws up the timer for bots when
		// there are no active connections. With that said, bots are unable to have a timer.5
		if (!playeringame[i])
			continue;

		pl = players + i;

		if (++pl->timeplay >= TICRATE*60)
		{
			pl->minutesingame++;
			pl->timeplay = 0;
			GUI_UpdateTime(i);

			// Send to all clients about the update
			// This maybe should be done client side, but this is way more
			// accurate and its only done in intervals of *1* minute for 3
			// lousy bytes!

			ZDOP.Init();
			ZDOP.WriteByte(sv_playertimer);
			ZDOP.WriteByte(i);
			ZDOP.WriteShort(pl->minutesingame);
			ZDOP.Broadcast();
		}

	}
}


//
// ZD_CheckTimeouts - Sometimes players can lag too horribly and we're forced to disconnect
//

void ZD_CheckTimeouts(void)
{
	int		i;

	for (i=top_client; i>=0; i--)
	{
		// Bots cant time-out
		if (players[i].isbot || !clients[i].connected)
			continue;

		if ((gametic - clients[i].lastcmdtic) >= TIMEOUT_TIME)
		{
			ZD_DisconnectClient(i);
		}
	}
}

//
// ZD_UpdateClientPing 
//

void ZD_UpdateClientPing(void)
{
	int		clientping = ZD_ReadLong();

	clients[parse_cl].ping = I_MSTime() - clientping;
}

//
// ZD_SectorSound - By char* name
//

void ZD_SectorSound(sector_t* sec, char *sound)
{
	// [NightFang] - send the sound
	ZDOP.Init();
	ZDOP.WriteByte(sv_secsound);
	ZDOP.WriteShort(sec->netid);
	ZDOP.WriteString(sound);
	ZDOP.Broadcast();
}

		
//
// ZD_SectorSoundID - by ID #
//
void ZD_SectorSoundID(sector_t* sec, int id)
{
	// [NightFang] - send the sound
	ZDOP.Init();
	ZDOP.WriteByte(sv_secsoundid);
	ZDOP.WriteShort(sec->netid);
	ZDOP.WriteByte(id);
	ZDOP.Broadcast();
}
 

//
// ZD_StopSequence - Stops sound sequences
//

void ZD_StopSoundSeqence(sector_t*	sec)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_stopsecseq);
	ZDOP.WriteShort(sec->netid);
	ZDOP.Broadcast();
}


//
// ZD_LoadNewLevel - Loads a level and sends all the info to clients
// 

void ZD_LoadNewLevel(char *levelname)
{
	int	i;

	for (i=0; i<=top_client; i++)
	{
		if (!ZD_ValidClient(i))	continue;
		SZ_Clear(&clients[i].netbuf);
		ZDOP.Init();
		ZDOP.WriteByte(sv_loadmap);
		ZDOP.WriteString(levelname);
		ZDOP.ToPlayer(i);
		if (deathmatch)	G_DeathMatchSpawnPlayer(i);
		else			P_SpawnPlayer(&playerstarts[i % 4], i);
		ZD_SendFullUpdate(i);
		ZD_SendPacket(i);
	}
}

//
// ZD_LoadNewClientLevel
//
static void ZD_LoadNewClientLevel(char *levelname, int i)
{
	player_s	*pli;

	if (!ZD_ValidClient(i))	return;

	pli = players+i;

	SZ_Clear(&clients[i].netbuf);

	send_init_sequence(i);

	ZDOP.Init();
	ZDOP.WriteByte(sv_newmap2);
	ZDOP.WriteString(levelname);
	ZDOP.WriteByte (sv_spawnplayer);
	ZDOP.WriteByte (0);
	ZDOP.WriteByte (i);
	ZDOP.WriteByte (PST_REBORN);
	ZDOP.WriteByte ((pli->spectator) ? 10 : 0 );  // always start as a spectator
	ZDOP.WriteShort(pli->mo->netid);
	ZDOP.WriteLong (pli->mo->angle);
	ZDOP.WriteLong (pli->mo->x);
	ZDOP.WriteLong (pli->mo->y);
	ZDOP.WriteLong (pli->mo->z);
	ZDOP.ToPlayer(i);

	ZD_SendFullUpdate(i);
	ZD_UpdateSectors(i);

	ZD_SendPacket(i);
}


//
// ZD_ReconnectNewLevel - This will tell clients to reconnect to get the new
// level. Useful only when changing the maps manually
//
void ZD_ReconnectNewLevel(char	*levelname)
{
	int	i;

	for (i=top_client; i>=0; i--)
	{
		if (!ZD_ValidClient(i))	continue;
		SZ_Clear(&clients[i].netbuf);
		ZDOP.Init();
		ZDOP.WriteByte(sv_newmap);
		ZDOP.WriteString(levelname);
		ZDOP.ToPlayer(i);
		ZD_SendPacket(i);
		ZD_DisconnectClient(i);
	}
}


//
// ZD_UpdateFlat - Will update a flat texture
//
void ZD_UpdateFlat(sector_t	*sec, int FloorOrCeil, int tex)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_flattexture);
	ZDOP.WriteByte(FloorOrCeil);
	ZDOP.WriteShort(sec->netid);
	ZDOP.WriteString(lumpinfo[tex+firstflat].name);
	ZDOP.Broadcast();
	sec->flatchange = true;
}


//
// ZD_QueryThing
//

void ZD_QueryThing(void)
{
	int		id;
	AActor*	mo;
	const	TypeInfo *type;

	id = ZD_ReadShort();
	mo = ZD_FindThingById(id);
	
	// [NightFang] - this is really bad, but dont complain
	if (!mo)
		return;

	type = ZDRUNTIME_TYPE(mo);

	ZDOP.Init();
	ZDOP.WriteByte(sv_spawnmobj);
	ZDOP.WriteLong(mo->x);
	ZDOP.WriteLong(mo->y);
	ZDOP.WriteLong(mo->z);
	ZDOP.WriteString((char *)type->Name + 1);
	ZDOP.WriteShort(mo->netid);
	ZDOP.ToPlayer(parse_cl);
}

void ZD_ChatSend(int chat_type,const char *s,int sender,int tgt)
{
	int		i;
	char	*sender_name, *tgt_name;

	if (sender<0 || sender>top_client || !playeringame[sender])
	{
		Printf(PRINT_CHAT,"Invalid chat sender\n");
		return;
	}
	sender_name = players[sender].userinfo.netname;

	// Ensure the validity of the recipient of private msgs.
	if (chat_type==2)
	{
		if (tgt<0 || tgt>top_client || !ZD_ValidClient(tgt))
		{
			Printf(PRINT_CHAT,"Invalid target player for private msg\n");
			return;
		}
		tgt_name = players[tgt].userinfo.netname;
	}
	else tgt_name = NULL;

	// Kilgore: just in case somebody has hacked the client
	// Disallow spectators sending non-public messages
	if (chat_type!=0 && players[sender].spectator)
	{
		Printf(PRINT_CHAT,"Ignoring non-public chat from spectator %s: %s\n",sender_name, s);
		return;
	}
	// Kilgore: just in case somebody has hacked the client
	// Disallow private msgs. to members of opposing teams
	if (chat_type==2 && teamplay && players[sender].userinfo.team != players[tgt].userinfo.team)
	{
		Printf(PRINT_CHAT,"Ignoring private chat from %s to %s (opposing team member): %s\n",
				sender_name, tgt_name, s);
		return;
	}

	// Send it out
	switch (chat_type)
	{
		case 0:
			Printf(PRINT_CHAT, "<%s> %s\n", sender_name, s);
			ZDOP.Init();
			ZDOP.WriteByte(sv_chat);
			ZDOP.WriteByte(sender);
			ZDOP.WriteString(s);
			ZDOP.Broadcast();
			break;
		case 1:
			Printf(PRINT_TEAMCHAT, "<%s> %s\n", sender_name, s);
			ZDOP.Init();
			ZDOP.WriteByte(sv_teamchat);
			ZDOP.WriteByte(sender);
			ZDOP.WriteString(s);
			for (i=top_client; i>=0; i--)
			{
				if (!ZD_ValidClient(i)) continue;
				if (teamplay && players[i].userinfo.team != players[sender].userinfo.team)  continue;
				ZDOP.ToPlayer(i);
			}
			break;
		case 2:
			Printf(PRINT_PRIVCHAT, "<%s> -> <%s> %s\n", sender_name, tgt_name, s);
			ZDOP.Init();
			ZDOP.WriteByte(sv_privchat);
			ZDOP.WriteByte(sender);
			ZDOP.WriteString(s);
			ZDOP.ToPlayer(sender);		//echo to sender
			ZDOP.ToPlayer(tgt);			//send to target as well
			break;
	}
}

//
// ZD_DoChat
//
static void ZD_DoChat(int chat_type)
{
	int			tgt;
	const char	*s;

	tgt = (chat_type==2) ? ZD_ReadByte() : -1;
	s = ZD_ReadString();
	ZD_ChatSend(chat_type,s,parse_cl,tgt);
}


//
// ZD_ConnectionType - Determine
//

static void ZD_ConnectionType(void)
{
	int	cmd;
	
	for (;;)
	{
		cmd = ZD_ReadByte();

		// OEM
		if (cmd <= 0)	break;

		// Setup a new player (setup client_t and player_t)
		if (cmd == CONNECT_CHALLENGE)
		{
			ZD_SetupNewConnection(true);
		}
		// its the encoded message from that stupid huffbuff crap
		else if (cmd == LAUNCHER_CHALLENGE_LSB)
		{
			// Read 3 more bytes, since it was a long that was sent to us
			ZD_ReadByte();
			ZD_ReadByte();
			ZD_ReadByte();
			ZD_SendInfo();
			return;
		}
		else if (cmd == READ_BANLIST)
		{
			SV_ReReadBans(ZD_ReadString());
			return;
		}
		else if (cmd == REFRESH_BANLIST)
		{
			SV_ReFreshBans();
			return;
		}
	}
}


//
// ZD_MissingPlayer
//

void ZD_MissingPlayer(void)
{
	int	pnum = ZD_ReadByte();		// the player that our client is missing
	int cl = parse_cl;
	player_t*	player = &players[pnum];

	if (!playeringame[pnum])
	{
		Printf("ZD_MissingPlayer: BIG PROBLEM!!\n");
		return;
	}
	ZDOP.Init();
	if (player->isbot)
	{
		ZDOP.WriteByte(sv_spawnbot);
		ZDOP.WriteByte(10);		// do reborn, who cares?
		ZDOP.WriteByte(pnum);
	}
	else
	{
		ZDOP.WriteByte(sv_spawnplayer);
		ZDOP.WriteByte(10);		// do reborn, who cares?
		ZDOP.WriteByte(pnum);
		ZDOP.WriteByte(player->playerstate);
		ZDOP.WriteByte( (player->spectator) ? 10 : 0 );
	}
	ZDOP.WriteShort(player->mo->netid);
	ZDOP.WriteLong(player->mo->angle);
	ZDOP.WriteLong(player->mo->x);
	ZDOP.WriteLong(player->mo->y);
	ZDOP.WriteLong(player->mo->z);
	ZDOP.ToPlayer(cl);
	ZD_UpdateUserinfo(cl,false);
}

//
// ZD_DisconnectBot - Informs every player about a bots leave
//

void ZD_DisconnectBot(int	pl)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_disconnectbot);
	ZDOP.WriteByte(pl);
	ZDOP.Broadcast();
}


//
// ZD_UseItem
//

void ZD_UseItem(void)
{
	int which = ZD_ReadByte();
	int	i;

	// None left!
	if (players[parse_cl].inventory[which] <= 0)
	{
		ZDOP.Init();
		ZDOP.WriteByte(sv_updateinv);
		ZDOP.WriteByte(which);
		ZDOP.WriteByte(players[parse_cl].inventory[which]);
		ZDOP.ToPlayer(parse_cl);
		return;
	}

	if (which == arti_none)
	{ // Use one of each artifact (except puzzle artifacts)
		for (i = 1; i < arti_firstpuzzitem; i++)
		{
			P_PlayerUseArtifact (&players[parse_cl], (artitype_t)i);
		}
	}
	else
	{
		if (players[parse_cl].inventorytics)
		{
			players[parse_cl].inventorytics = 0;
		}
		else
		{
			P_PlayerUseArtifact (&players[parse_cl], (artitype_t)which);
		}
	}

	// Its done, now let all other players know of this

	for (i=top_client; i>=0; i--)
	{
		if (!ZD_ValidClient(i))  continue;

		ZDOP.Init();
		ZDOP.WriteByte(sv_useinv);
		ZDOP.WriteByte(parse_cl);
		ZDOP.WriteByte(which);
		// When resending data, update the inventory
		if (i==parse_cl)
			ZDOP.WriteByte(players[parse_cl].inventory[which]);
		ZDOP.ToPlayer(i);
	}

}

//
// ZD_BroadcastDMFlags
//

void	ZD_BroadcastDMFlags(FBaseCVar *cvar)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_dmflags);
	ZDOP.WriteLong(dmflags);
	ZDOP.WriteLong(dmflags2);
	ZDOP.Broadcast();
	if (cvar == &dmflags)
		ZD_Printf("DMFLAGS now: %d\n", (int)dmflags);
	if (cvar == &dmflags2)
		ZD_Printf("DMFLAGS2 now: %d\n", (int)dmflags2);
}

void	ZD_AttemptRCON(void)
{
	UCVarValue			charttl;
	char				rconpassword[32];
	char				*attempt = ZD_ReadString();

	// [NightFang- 1.03] - Only do this if rcon is enabled
	if (enable_rcon <= 0)
		return;

	charttl = rcon_password.GetGenericRep (CVAR_String);
	strcpy(rconpassword, charttl.String);	

	ZDOP.Init();
	ZDOP.WriteByte(sv_rconaccess);
	if (!strcmp(rconpassword, attempt))
	{
		Printf("RCON for %s is granted!\n", players[parse_cl].userinfo.netname);
		clients[parse_cl].rconaccess = true;
		ZDOP.WriteByte(1);
	}
	else
	{
		Printf("RCON for %s is denied!\n", players[parse_cl].userinfo.netname);
		clients[parse_cl].rconaccess = false;
		ZDOP.WriteByte(0);
	}
	ZDOP.ToPlayer(parse_cl);
}

void	ZD_RCONCommand(void)
{
	char	*cmd = ZD_ReadString();

	// [NightFang- 1.03] - Only do this if rcon is enabled
	if (enable_rcon <= 0)
		return;

	// DENIED!!!!
	if (!clients[parse_cl].rconaccess)
	{
		Printf("RCON for %s is denied! (%s)\n", players[parse_cl].userinfo.netname, cmd);
		ZDOP.Init();
		ZDOP.WriteByte(sv_rconaccess);
		ZDOP.WriteByte(0);
		ZDOP.ToPlayer(parse_cl);
		return;
	}

	Printf("%s RCON (%s)\n", players[parse_cl].userinfo.netname, cmd);

	C_DoCommand(cmd);
}


//
// ZD_BroadcastSpree - Broadcasts and special spree messages & kills
//

void ZD_BroadcastSpree(int pl, int level, char *msg)
{
	ZDOP.Init();
	ZDOP.WriteByte(sv_spreemsg);
	ZDOP.WriteByte(pl);
	ZDOP.WriteByte(level);
	ZDOP.WriteString(msg);
	ZDOP.Broadcast();
}

//
// ZD_BroadcastKills
//
void ZD_BroadcastKills(int pl, int level, char *msg)
{
	if (!ZD_ValidClient(pl))	return;
	ZDOP.Init();
	ZDOP.WriteByte(sv_killmsg);
	ZDOP.WriteByte(level);
	ZDOP.ToPlayer(pl);
}


//
// ZD_Teleport - Dont ask
//

void ZD_Teleport(void)
{
	player_t*		pl = &players[parse_cl];
	int				i;
	fixed_t			x = ZD_ReadShort() << FRACBITS;
	fixed_t			y = ZD_ReadShort() << FRACBITS;
	fixed_t			z = ZD_ReadShort() << FRACBITS;

	if (!pl->mo)
		return;

	P_TeleportMove(pl->mo, x, y, z, true);

	ZDOP.Init();
	ZDOP.WriteByte(sv_telemove);
	ZDOP.WriteByte(parse_cl);
	ZDOP.WriteShort(x >> FRACBITS);
	ZDOP.WriteShort(y >> FRACBITS);
	ZDOP.WriteShort(z >> FRACBITS);
	ZDOP.WriteLong(pl->mo->angle);

	for (i=top_client; i>=0; i--)
	{
		if (!ZD_ValidClient(i) || i == parse_cl) continue;
		ZDOP.ToPlayer(i);
	}
}



//
// ZD_ParsePackets - Parses all our network info
//
static void ZD_ParsePackets(void)
{
	int		cmd;

	//if (clients[parse_cl].netstate < ZD_CONNECTED)
	//	return;

	while ( (cmd=ZD_ReadByte()) > 0 )
	{
		switch(cmd)
		{
			case CONNECT_CHALLENGE:	ZD_SetupNewConnection(false);	break;
			case CONNECT_QUIT:		ZD_DisconnectClient(parse_cl);	return;
			case CONNECT_GETDATA:	ZD_ConnectNewPlayer();			break;
			case cl_userinfo:		ZD_GetUserInfo();				break;
			case cl_clientmove:		ZD_GetUserCmd();				break;
			case cl_weapslot:		ZD_WeaponSlot();				break;
			case cl_weapsel:		ZD_WeaponSelect();				break;
			case cl_pong:			ZD_UpdateClientPing();			break;
			case cl_querything:		ZD_QueryThing();				break;
			case cl_chat:			ZD_DoChat(0);					break;
			case cl_teamchat:		ZD_DoChat(1);					break;
			case cl_privchat:		ZD_DoChat(2);					break;
			case cl_missingplayer:	ZD_MissingPlayer();				break;
			case cl_useitem:		ZD_UseItem();					break;
			case cl_requestrcon:	ZD_AttemptRCON();				break;
			case cl_rconcmd:		ZD_RCONCommand();				break;
			case cl_teleport:		ZD_Teleport();					break;
			case cl_ack:			ZD_AcknowledgePacket();			break;
			case cl_wantnewlevel:
				if (gamestate != GS_INTERMISSION)
					ZD_LoadNewClientLevel(level.mapname, parse_cl);
				break;
			default:				Printf("Unknown client message: %d\n", cmd);	return;
		}
	}
}


//
// ZD_RecievePackets
//

static void ZD_RecievePackets(void)
{
	while ( ZD_GetPackets() > 0 )
	{
		// Packet loss emulation, server side
		//if (P_Random(pr_misc) < 170)
		//{ 
		//	return;
		//}

		// Find out who this is coming from
		if ( (parse_cl = ZD_FindClientByAddr(&net_from)) < 0 )
		{
			ZD_ConnectionType();
			return;
		}
	
		ZD_ParsePackets();
	}
}

static void ZD_UpdateClientTime(void)
{
	int timeleft;

	// Send the message every minute
	// at 12 seconds before the minute.
	if ( (gametic % (TICRATE*60)) != 48*TICRATE) return;

	if (timelimit==0) return;
	timeleft = level.end_time - level.time;		// in ticks
	if (timeleft<0) timeleft=0;
	ZDOP.Init();
	ZDOP.WriteByte(sv_timeleft);
	ZDOP.WriteLong(timeleft);
	ZDOP.Broadcast();
}

//
// SV_RunTics
//

int 		realtics;
int 		availabletics;
int 		counts;
static unsigned	next_alarm_time = 24*60*60*TICRATE;		// "ring" 24 hours from startup

void SV_RunTics (void)
{
	int              nowtime;
	int              newtics;

	I_DoSelect();

	nowtime = I_GetTime();
	if (nowtime<gametime)
	{
		gametime = nowtime;
		static char *s =  "ERROR in I_GetTime(): it would cause the clock to go crazy";
		connlog_printf("%s\n",s);
		Printf("%s\n",s);
	}
    newtics = nowtime - gametime;

#ifndef USEGUI
	// console input
	char *cmd = I_ConsoleInput();
	if (cmd)
		AddCommandString (cmd);
#endif

	// Recieve packets
	ZD_RecievePackets();

	// run the newtime tics
	if (newtics > 0)
	{
		while (newtics--)
		{

			DObject::BeginFrame ();

			int	i;
			for (i=top_client; i>=0; i--)
			{
				if (playeringame[i] && players[i].isbot && players[i].mo)
				{	
					{
						players[i].savedyaw = players[i].mo->angle;
						players[i].savedpitch = players[i].mo->pitch;
					}
				}
			}
			bglobal.Main (maketic % BACKUPTICS);
			for (i=top_client; i>=0; i--)
			{
				if (playeringame[i] && players[i].isbot && players[i].mo)
				{
					players[i].mo->angle = players[i].savedyaw;
					players[i].mo->pitch = players[i].savedpitch;
				}
			}

			ZD_UpdateClientTime();

			G_Ticker ();

			ZD_UpdateMaster();

			// Punch time every 512 seconds = 512/35 = 14.62 seconds
			if ( (gametic & 511) == 0 )
				watchdog_punch_time();

			maketic++;
			gametic++;

			/*
			 * Automatic log rotation and fetching of master ban list
			 */
			if (gametic > next_alarm_time)
			{
				log_alarm();
				submit_attempt();
				SV_FetchMasterBanList();
				set_alarm_to_next_midnight();
			}

			DObject::EndFrame ();
		}
	}
	gametime = nowtime;
}

CCMD(fraglog)
{
	fraglog_control("frag");
}

CCMD(weaponlog)
{
	weaponlog_control("weap");
}

CCMD(connectionlog)
{
	connlog_control("conn");
}

CCMD(debuglog)
{
	dbglog_control("dbg");
}

CCMD(logfile)
{
	genlog_control("gen");
}

void set_alarm(unsigned nsecs)
{
	next_alarm_time = gametic + nsecs*TICRATE;
}
