#ifndef __SV_MAIN_H__
#define __SV_MAIN_H__

#define MASTER_CHALLENGE		5560020				// Master server heartbeat
#define	MASTER_PLAYERSTATS		47741				// Update a player's stats in the master

//#define LAUNCHER_CHALLENGE		777123  // csdl challenge
#define LAUNCHER_CHALLENGE		"\xA3\xDB\x0B\x00"  // csdl challenge in LSB order
#define LAUNCHER_CHALLENGE_LSB	163		// Least significant byte of above number

#define	NUM_WAD_PATHS			5		// Number of wads launcher will report

#define	MAX_UDP_PACKET			1400		//Kilgore: was 8192

#define	SERVER_PORT				10666
#define	CLIENT_PORT				10667
#define	MASTER_PORT				15300

// Challengers
#define	CONNECT_CHALLENGE		200
#define	CONNECT_READY			201
#define	CONNECT_GETDATA			202
#define	CONNECT_QUIT			203

#define READ_BANLIST			204			// Internal message about re-reading the master ban list
#define REFRESH_BANLIST			205			// Msg. from master to refresh the global ban list

// Network messages (universal)
#define	NETWORK_ERROR			254

// Client network status
#define	ZD_DISCONNECTED		0
#define	ZD_CONNECTING		2
#define	ZD_CONNECTED		4
#define	ZD_PLAYING			8

// Number of maps allowed in map cycles
#define		ZD_MAX_MAPS		36

// Stuff
#define CM_X      1
#define CM_Y      2
#define CM_Z      4
#define CM_ANGLE  8
#define CM_MOMX   16
#define CM_MOMY   32
#define CM_MOMZ   64
#define CM_FRAME  128

// Identifying states (the cheap & easy way out)
#define	STATE_SPAWN				1
#define	STATE_SEE				2
#define	STATE_PAIN				3
#define	STATE_MELEE				4					
#define	STATE_MISSILE			5
#define	STATE_DEATH				6

// Identifying player states (again, cheap & easy)
#define	STATE_PLAYER_IDLE		7
#define	STATE_PLAYER_SEE		8
#define	STATE_PLAYER_ATTACK		9
#define	STATE_PLAYER_ATTACK2	10

// Flags for updating sectors
#define SUPDATE_CEILING			1	
#define SUPDATE_FLOOR			2
#define SUPDATE_FLOORTEXTURE	4
#define SUPDATE_CEILINGTEXTURE	8

// Client --> Server messages
#define		cl_userinfo				1
#define		cl_clientmove			2
#define		cl_weapslot				3
#define		cl_weapsel				4
#define		cl_pong					5
#define		cl_wantnewlevel			6
#define		cl_querything			7
#define		cl_chat					8
#define		cl_requestspawn			9
#define		cl_tryfire				10
#define		cl_missingplayer		11
#define		cl_useitem				12
#define		cl_requestrcon			13
#define		cl_rconcmd				14
#define		cl_teleport				15
#define		cl_ack					16
#define		cl_teamchat				17	//Kilgore
#define		cl_privchat				18	//Kilgore

// Server --> Client messages
#define		sv_consoleplayer		1
#define		sv_dmflags				2
#define		sv_skill				3
#define		sv_loadmap				4
#define		sv_spawnmobj			5
#define		sv_mobjangle			6
#define		sv_corpse				7
#define		sv_moveplayer			8
#define		sv_gametype				9
#define		sv_mobjstate			10
#define		sv_movething			11
#define		sv_spawnplayer			12
#define		sv_updatelocalplayer	13
#define		sv_spawnmissile			14
#define		sv_explodemissile		15
#define		sv_fireweapon			16
#define		sv_refireweapon			17
#define		sv_touchthing			18
#define		sv_ping					19
#define		sv_updateping			20
#define		sv_respawnitem			21
#define		sv_damagemobj			22
#define		sv_killmobj				23
#define		sv_damageplayer			24
#define		sv_killplayer			25
#define		sv_setspecificstate		26
#define		sv_toggleline			27
#define		sv_playernoway			28
#define		sv_dodoor				29
#define		sv_doplat				30
#define		sv_updatesector			31
#define		sv_destroymobj			32
#define		sv_secsound				33
#define		sv_secsoundid			34
#define		sv_stopsecseq			35
#define		sv_exitlevel			36
#define		sv_doreborn				37
#define		sv_newmap				38
#define		sv_moveplane			39
#define		sv_flattexture			40
#define		sv_dropitem				41
#define		sv_telemove				42
#define		sv_chat					43
#define		sv_spawnbot				44
#define		sv_playerstate			45
#define		sv_firepistol			46
#define		sv_fireshotgun			47
#define		sv_fireshotgun2			48
#define		sv_firechaingun			49
#define		sv_firerocket			50
#define		sv_fireplasma			51
#define		sv_firebfg				52
#define		sv_openshotgun2			53
#define		sv_loadshotgun2			54
#define		sv_closeshotgun2		55
#define		sv_userinfo				56
#define		sv_updatefrags			57
#define		sv_wepchange			58
#define		sv_rerespawn			59
#define		sv_newmap2				60		// does not disconnect
#define		sv_adminchat			61
#define		sv_disconnectclient		62
#define		sv_printf				63
#define		sv_firerailgun			64
#define		sv_disconnectbot		65
#define		sv_updateinv			66
#define		sv_useinv				67
#define		sv_givearti				68
#define		sv_spawnrain			69
#define		sv_motd					70
#define		sv_rconaccess			71
#define		sv_cantjoin				72
#define		sv_spreemsg				73
#define		sv_killmsg				74
#define		sv_playertimer			75
#define		sv_sawhit				76
#define		sv_missedpacket			77
#define		sv_kick					78
#define		sv_experience			79
#define		sv_header				80
#define		sv_teamchat				81	//Kilgore
#define		sv_updateteamscore		82	//Kilgore
#define		sv_special_event		83	//Kilgore
#define		sv_badteam				84	//Kilgore
#define		sv_privchat				85	//Kilgore
#define		sv_timeleft				86	//Kilgore
#if __CTF__
//duke
//==
#define		sv_ctf_event			87
#define		sv_ctf_state			88
//==                                  
#endif

//
// STRUCTS
// 


typedef unsigned char byte;

typedef struct
{
   byte    ip[4];
   unsigned short  port;
   unsigned short  pad;
} netadr_t;

typedef	struct
{
	char	name[256];
}wadpath_t;

typedef struct sizebuf_s
{
	byte	*data;
	int		maxsize;
	int		cursize;
	int		readcount;
} sizebuf_t;

typedef	struct
{
	bool		connected;		// Is this client connected?
	netadr_t	address;
	const char	*c2;			// ip2c country code
	const char	*country_name;	// ip2c country name
	sizebuf_t	netbuf;			// I/O network buffer
	int			playernum;		// Player number in players array
	int			netstate;		// network status
	unsigned	lastcmdtic;
	unsigned	lastgametic;	// Used for calculating pings
	int			ping;			// Used for calculating pings
	bool		needfullupdate; // Client is not in sync
	bool		rconaccess;		// Access to rcon?
	int			gametics;		// Client's gametics

	// Old zdaemon/csdoom stuff (bleh)
	sizebuf_t   relpackets; // save reliable packets here
	int         packetbegin[256]; // the beginning of a packet
	int         packetsize[256]; // the size of a packet
	int         packetseq[256];
	int         sequence;
	int         last_sequence;
	byte        packetnum;

}client_t;


// Kilgore: special events (playing audio in client)
typedef enum
{
	SE_DOUBLE,
	SE_MULTI,
	SE_ULTRA,
	SE_MONSTER,
	SE_SPREE,
	SE_RAMPAGE,
	SE_DOMINATING,
	SE_UNSTOPPABLE,
	SE_GODLIKE,			// The events up to here will not be handled by ZD_Special_xxx()
						// They are already communicated to the client by
						// ZD_BroadcastKills() and ZD_BroadcastSpree()().

	SE_1MIN_LEFT,		// The following events will be handled by ZD_Special_xxx()
	SE_5MIN_LEFT,
	SE_1FRAG_LEFT,
	SE_2FRAG_LEFT,
	SE_3FRAG_LEFT,
	SE_TEAMMATE_KILL,
	SE_SUICIDE,
	SE_PREPARE,
	SE_START,
	SE_LEADGOT,
	SE_LEADLOST,
	SE_LEADTIED,
	SE_WIN,
	SE_LOSE,
	SE_TIED,
	SE_IMPRESSIVE,
	SE_HUMILIATION,
	SE_HOLY_SHIT,

	SE_WICKED_SICK,
	SE_ASSIST,
	SE_RED_TAKEN,
	SE_RED_DROPPED,
	SE_RED_RETURNED,
	SE_RED_SCORES,
	SE_BLUE_TAKEN,
	SE_BLUE_DROPPED,
	SE_BLUE_RETURNED,
	SE_BLUE_SCORES,

	NUM_SPEC_EVENTS
} spec_event_t;

//
// EXTERNAL VARIABLES
// 
extern		int			parse_cl;						// ...and thats where baby packets come from...
extern		char		*zd_mapcycle[ZD_MAX_MAPS];
extern		int			zd_nummaps;
extern		bool		zd_cycleactive;					// Are we using our map cycle or the engines?
extern		int			zd_nextmap;						// Next # in the array
extern		wadpath_t	wadpaths[NUM_WAD_PATHS];
extern		int			numusedwads;		// Pwads only
extern		int			gametime;
extern		client_t	clients[MAXPLAYERS];
extern		netadr_t	net_from;			// address of who sent the packet
extern		netadr_t	net_local_adr;
extern		int			localport;
extern		int			gametime;
extern		bool		zd_localplay;		// playing locally?
extern		int			zd_netstate;		// Network status (connected, connecting..? etc)
extern		int			numdoors;			// [NightFang] - keep track of doors
extern		int			zd_nextpos;			// Next level pos?
extern		bool		switching_kill;		// Kilgore: flag when killing team switchers

// For win32 gui server only
#ifdef USEGUI
	void GUI_DelPlayer(int i);
	void GUI_AddPlayer(int i);
	void GUI_Exit(void);
	void GUI_fputs(const char *s);
	void GUI_UpdateName(int i);
	void GUI_UpdateFrags(int i);
	void GUI_UpdateTime(int i);
	void GUI_UpdatePing(int i);
	void GUI_UpdateWindow(void);
	void GUI_Init(int i);
	void GUI_Save(player_t *p);
	void GUI_Restore(player_t *p);
#else
	#define GUI_DelPlayer(i)
	#define GUI_AddPlayer(i)
	#define GUI_Exit()				exit(0)
	#define GUI_fputs(s)			fputs((s),stdout)
	#define GUI_UpdateName(i)
	#define GUI_UpdateFrags(i)
	#define GUI_UpdateTime(i)
	#define GUI_UpdatePing(i)
	#define GUI_UpdateWindow()
	#define GUI_Init(i)
	#define GUI_Save(p)
	#define GUI_Restore(p)
#endif


//
// EXTERNAL FUNCTIONS
//
EXTERN_CVAR (Int, maxplayers);
EXTERN_CVAR (Int, maxclients);
extern		int		top_client;

void		copy_file(const char *infile,const char *outfile);

char		*NET_AdrToString (const netadr_t * const a);
bool		NET_StringToAdr (const char *s, netadr_t *a);
bool		NET_CompareAdr (netadr_t *a, netadr_t *b);
int			ZD_GetPackets (void);
void		NET_GetLocalAddress (void);
void		I_SetPort(netadr_t *addr, int port);

void		ZD_AcknowledgePacket(void);
void		ZD_SendCmd(void);
void		G_PlayerReborn (int player);
void		P_SpawnPlayer (mapthing2_t *mthing, int playernum);
void		SV_RunTics (void);
void		printErrorExit(char *text);
char		*I_ConsoleInput (void);
void		I_DoSelect (void);
void		ZD_StartNetwork(void);
void		InitNetCommon2(void);
void		ZD_CloseNetwork(void);
void		ZD_UpdateMaster(void);
void		ZD_SendInfo(void);
void		ZD_WriteCommands(void);
void		ZD_SendOutPackets(void);
void		ZD_UpdateState(AActor	*mo, int statetype);
void		ZD_SendHeartBeat(void);
void		ZD_TriggerLine(line_t* line, player_t* player, bool repeat);
void		ZD_TriggerDoor(sector_t*	sec, int direction, int time, int type, fixed_t speed);
void		ZD_TriggerPlat(sector_t* sec, int type, int status, int wait, fixed_t speed, fixed_t high, fixed_t low);
void		ZD_DestroyAActor(AActor *mo);
void		ZD_SectorSound(sector_t* sec, char *sound);
void		ZD_SectorSoundID(sector_t* sec, int id);
void		ZD_StopSoundSeqence(sector_t*	sec);
void		ZD_LoadNewLevel (char *levelname);
void		ZD_ReconnectNewLevel(char	*levelname);
void		ZD_UpdateFlat(sector_t	*sec, int FloorOrCeil, int tex);
bool		ZD_ValidClient(int i);
void		ZD_CheckTimeouts(void);
void		ZD_DoPlayerTime(void);
int			ZD_ClientCount(void);
int			ZD_PlayerCount(void);
void		ZD_UpdatePlayerState(int id, int statetype);
void		ZD_UpdateUserinfo(int num,bool to_all);
void		ZD_UpdateFrags(int pl);
void		ZD_UpdateTeamScore(int tm);
void		STACK_ARGS ZD_Printf(const char *string,...);
void		ZD_DisconnectBot(int	pl);
void		ZD_AddWad(char	*wadfile);
void		ZD_NextMap(void);
void		ZD_PrevMap(void);
void		ZD_BroadcastDMFlags(FBaseCVar *cvar);
void		ZD_BroadcastSpree(int pl, int level, char *msg);
void		ZD_BroadcastKills(int pl, int level, char *msg);
void		ZD_ValidateCFG(void);
void		ZD_UpdatePlayers(void);
void		ZD_UpdatePlayerStats(int pl);
void		ZD_UpdateExperience(int	pl);
void		ZD_Special_To_Player(int pnum,spec_event_t et,unsigned parm);	//Kilgore
void		ZD_Special_To_All(spec_event_t et,unsigned parm);				//Kilgore
void		ZD_Update_Player_Frags(player_t *p,int v);						//Kilgore
void		ZD_Update_Team_Score(int tm,int v);								//Kilgore
void		ZD_Recalc_Team_Lead_States(void);								//Kilgore
void		ZD_Recalc_Player_Lead_States(void);								//Kilgore
void		ZD_DisconnectClient(int cl);

int			SV_EnforceBans(int 	cl);
void		SV_ReadLocalBans(void);
void		SV_ReReadBans(const char *buf);
void		SV_FetchMasterBanList(void);
void		SV_ReFreshBans(void);

const netadr_t * const masteraddr(void);
const netadr_t * const localhost_addr(void);
bool		is_trusted_address(const netadr_t *a);

void		notify_add_client(int idx);
void		notify_del_client(int idx);

void		client_clear(client_t *clp);
void		player_clear(player_t *plp);
void		ZD_ChatSend(int chat_type,const char *s,int sender,int tgt);


//
// ZDaemon Client Functions
// 

void		ZD_AttemptConnection(void);
void		ZD_ParsePacket(void);

//
// HARD CORE NET STUFF
//

void		ZD_SendPacket(int		cl);
void		SZ_Init (sizebuf_t *buf, int length);
void		SZ_Clear (sizebuf_t *buf);
void		SZ_Write (sizebuf_t *buf, void *data, int length);

void		ZD_BeginReading (void);

int			ZD_ReadChar (void);
int			ZD_ReadByte (void);
int			ZD_ReadShort (void);
int			ZD_ReadWord (void);
int			ZD_ReadLong (void);
char		*ZD_ReadString (void);
bool		ZD_ReadBytes(byte *buf,int bufsz);

class ZD_OutPacket
{
	private:
		unsigned char	*pout, *plast, buf[8*(MAX_UDP_PACKET+32)];

	public:
				ZD_OutPacket();
				~ZD_OutPacket()		{				}
		void	Init()				{ pout = buf;	}
		void	WriteByte(int c);
		void	WriteBytes(const void *buf,int bufsz);
		void	WriteShort(int c);
		void	WriteWord(unsigned v);
		void	WriteLong(unsigned long c);
		void	WriteFloat(float f);
		void	WriteString(const char *s);
		void	ToPlayer(int cl);
		void	SendTo(const netadr_t *adr, bool do_compress);
		void	Broadcast();
};
extern ZD_OutPacket ZDOP;

#endif		//__SV_MAIN_H__

