#include "doomtype.h"
#include "doomstat.h"
#include "p_local.h"
#include "sv_main.h"


EXTERN_CVAR(Int, maxrate);

char str[256];

//
// SV_SendPackets
//
void ZD_SendPacket(int cl)
{
	client_t	*clp;
	ZD_OutPacket	ZDOP;	// Use local copy instead of global one
							// because this can be called from SendTo(), Broadcast() or ToPlayer()

	clp = clients + cl;
	if (clp->netbuf.cursize<=0) return;

	// save the reliable message 
	// it will be retransmited, if it's missed

	// the end of the buffer is reached
	if (clp->relpackets.cursize + clp->netbuf.cursize >= clp->relpackets.maxsize)
		clp->relpackets.cursize = 0;

	// copy the beginning and the size of a packet to the buffer
	clp->packetbegin[clp->packetnum] = clp->relpackets.cursize;
	clp->packetsize[clp->packetnum] = clp->netbuf.cursize;
	clp->packetseq[clp->packetnum] = clp->sequence;

	if (clp->netbuf.cursize)
		SZ_Write (&clp->relpackets, clp->netbuf.data, clp->netbuf.cursize);

	clp->packetnum++;	// packetnum will never be more than 255
						// because sizeof(packetnum) == 1. Don't need
						// to use &0xff. Cool, eh? ;-)
	// copy sequence
	ZDOP.Init();
	ZDOP.WriteByte(sv_header);
	ZDOP.WriteLong(clp->sequence);
   
	// copy the reliable message to the packet first
	if (clp->netbuf.cursize)
	{
		ZDOP.WriteBytes(clp->netbuf.data, clp->netbuf.cursize);
		//cl->reliable_bps += cl->reliablebuf.cursize;
	}

	clp->sequence++;

	ZDOP.SendTo(&clp->address,true);

	SZ_Clear(&clp->netbuf);
}

//
// SV_AcknowledgePacket
//
void ZD_AcknowledgePacket(void)
{
	client_t	*cl;
	int			n, seq;
	bool		needfullupdate;

	int sequence = ZD_ReadLong();

	// packet is missed
	cl = clients + parse_cl;
	if (sequence - cl->last_sequence > 1)
	{
		// resend
		for (seq = cl->last_sequence+1;  seq < sequence;  seq++)
		{
			needfullupdate = true;
			for (n=0; n<256; n++)
			{
				if (cl->packetseq[n] == seq)
				{
					needfullupdate = false;
					break;
				}
			}

			if  (needfullupdate)
			{
				// do full update
				Printf("*** sequence screwed (need full update)\n");
				cl->last_sequence = sequence;
				return;
			}

			ZDOP.Init();
			ZDOP.WriteByte(sv_missedpacket);
			ZDOP.WriteLong(seq);
			ZDOP.WriteShort(cl->packetsize[n]);
			if (cl->packetsize[n])
				ZDOP.WriteBytes(cl->relpackets.data + cl->packetbegin[n],cl->packetsize[n]);
			ZDOP.ToPlayer(parse_cl);
		}
	}

	cl->last_sequence = sequence;
}
