#define ENABLE_WATCHDOG	1
#define USE_CRITSEC		0
#define USE_DETACHED	1

#if _WIN32
	#include <windows.h>
	#include <process.h>
	typedef unsigned long TID_T;
	#define THREAD_START(tid,f,p)	( ((tid)=_beginthread((f),0,(p))) != -1L)
	#if USE_DETACHED
		#define THREAD_WAIT(tid)
	#else
		#define THREAD_WAIT(tid)		WaitForSingleObject((HANDLE)tid,INFINITE)
	#endif
	#define THREAD_INIT_ATTR()
#else
	#include <unistd.h>
	#include <pthread.h>
	#define _sleep(n)		sleep( ((n)+999) / 1000 )
	typedef pthread_t	TID_T;
	#define THREAD_START(tid,f,p)	(pthread_create(&tid,NULL,(f),(p))==0)

	#if USE_DETACHED
		#define THREAD_WAIT(tid)
		#define THREAD_INIT_ATTR()	\
		do\
		{\
			pthread_attr_t attr;\
			pthread_attr_init(&attr);\
			pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);\
		}\
		while (0)
	#else
		#define THREAD_WAIT(tid)		pthread_join( tid, NULL)
		#define THREAD_INIT_ATTR()	\
		do\
		{\
			pthread_attr_t attr;\
			pthread_attr_init(&attr);\
			pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);\
		}\
		while (0)
	#endif
#endif
#include <stdio.h>
#include <time.h>
#include "doomtype.h"
#include "watchdog.h"

#if ENABLE_WATCHDOG
	
#if USE_CRITSEC	
	#if _WIN32
		class Mutex
		{
			private:
				CRITICAL_SECTION	cs;
			
			public:
					Mutex()		{	InitializeCriticalSection(&cs);	}
					~Mutex()	{	DeleteCriticalSection(&cs);		}
			void	enter()		{	EnterCriticalSection(&cs);		}
			void	exit()		{	LeaveCriticalSection(&cs);		}
		};
	#else
		class Mutex
		{
			private:
				pthread_mutex_t	cs;
			
			public:
					Mutex()		{	pthread_mutex_init(&cs,NULL);	}
					~Mutex()	{									}
			void	enter()		{	pthread_mutex_lock(&cs);		}
			void	exit()		{	pthread_mutex_unlock(&cs);		}
		};
	#endif
	static Mutex		wd_cs;
	#define CRITSEC_ENTER()	wd_cs.enter
	#define CRITSEC_EXIT()	wd_cs.exit
#else
	#define CRITSEC_ENTER()
	#define CRITSEC_EXIT()
#endif

static bool				wd_running = false;
static unsigned long	wd_last_time = 0;
static TID_T			wd_tid = 0;
static bool				wd_please_stop = false;

static void
#if _WIN32
__cdecl
#else
*
#endif
watchdog_bgd(void *pv)
{
	FILE			*f;
	struct tm		*lt;
	unsigned long	t, last;

	wd_running = true;
	for (;;)
	{
		_sleep(15000);
		if (wd_please_stop) break;
		CRITSEC_ENTER();
		last = wd_last_time;
		CRITSEC_EXIT();
		t = time(NULL);
		if (t - last > 40)
		{
			if ( (f=fopen("zserv.crashlog","a")) != NULL )
			{
				lt = localtime( (time_t *) &t);
				fprintf(f,"%04d-%02d-%02d %02d:%02d:%02d : Infinite loop detected\n",
						lt->tm_year+1900, lt->tm_mon+1, lt->tm_mday,
						lt->tm_hour, lt->tm_min, lt->tm_sec);
				fclose(f);
			}
			//
			// Make it crash on purpose; it should be restarted automatically
			//
			lt = NULL;
			if (lt->tm_year)
				t++;
		}
	}
	wd_running = false;
#if !_WIN32
	return NULL;
#endif
}

void watchdog_punch_time(void)
{
	unsigned long t = time(NULL);
	CRITSEC_ENTER();
	wd_last_time = t;
	CRITSEC_EXIT();
}

void watchdog_start(void)
{
	if (wd_running) return;
	wd_please_stop	= false;
	watchdog_punch_time();
	THREAD_INIT_ATTR();
	if (THREAD_START(wd_tid,watchdog_bgd,NULL))
	{
		/* Make sure that the background thread is on */
		while (!wd_running)
			_sleep(100);
	}

}

void STACK_ARGS watchdog_stop(void)
{
	if (!wd_running) return;
	wd_please_stop = true;
	THREAD_WAIT(wd_tid);
	wd_tid = 0;
}

#else

void watchdog_punch_time(void)		{		}
void watchdog_start(void)			{		}
void STACK_ARGS watchdog_stop(void)	{		}

#endif

